/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.search.matching;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;

public class ReferenceToTeamPackagePattern
extends JavaSearchPattern {
    protected static char[][] CATEGORIES = new char[][]{IIndexConstants.REF_TO_TEAMPACKAGE};
    protected char[] teamQualifiedName;
    protected char[] roleName;
    protected char[] _indexKey;

    public static char[] createIndexKey(char[] teamName, char[] roleName) {
        char[] result = CharOperation.concat(teamName, roleName, '/');
        assert (result != null);
        return result;
    }

    public ReferenceToTeamPackagePattern(char[] teamName, int matchRule) {
        this(teamName, null, matchRule);
    }

    public ReferenceToTeamPackagePattern(char[] teamQualifiedName, char[] roleName, int matchRule) {
        super(524288, matchRule | 8);
        this.mustResolve = false;
        if (teamQualifiedName == null) {
            throw new NullPointerException("teamQualifiedName must not be null");
        }
        this.teamQualifiedName = teamQualifiedName;
        this.roleName = roleName;
        this.createIndexKey();
    }

    protected ReferenceToTeamPackagePattern(int patternKind, int matchRule) {
        super(524288, 0 | 8);
        this.mustResolve = false;
    }

    public SearchPattern getBlankPattern() {
        return new ReferenceToTeamPackagePattern(524288, 8);
    }

    public char[][] getIndexCategories() {
        return CATEGORIES;
    }

    public boolean matchesDecodedKey(SearchPattern decodedPattern) {
        ReferenceToTeamPackagePattern pattern = (ReferenceToTeamPackagePattern)decodedPattern;
        boolean teamMatches = this.matchesName(this.teamQualifiedName, pattern.teamQualifiedName);
        if (!teamMatches) {
            return false;
        }
        return this.matchesName(this.roleName, pattern.roleName);
    }

    public int matches(ImportReference importRef) {
        if (this.matchesName(this.teamQualifiedName, CharOperation.concatWith(importRef.tokens, '.'))) {
            return 3;
        }
        return 0;
    }

    private void createIndexKey() {
        this._indexKey = ReferenceToTeamPackagePattern.createIndexKey(this.teamQualifiedName, this.roleName);
    }

    public char[] getIndexKey() {
        assert (this._indexKey != null);
        return this._indexKey;
    }

    public void decodeIndexKey(char[] key) {
        int slash = CharOperation.indexOf('/', key);
        this.teamQualifiedName = CharOperation.subarray(key, 0, slash);
        if (slash > 0 && slash < key.length - 2) {
            this.roleName = CharOperation.subarray(key, slash + 1, -1);
        }
    }
}

