/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.eclipselink.ui.internal.details;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.node.AbstractNode;
import org.eclipse.jpt.common.utility.node.Node;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConvert;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverter;
import org.eclipse.jpt.jpa.eclipselink.core.context.EclipseLinkConverterContainer;
import org.eclipse.jpt.jpa.eclipselink.core.context.persistence.EclipseLinkPersistenceUnit;
import org.eclipse.jpt.jpa.eclipselink.ui.details.JptJpaEclipseLinkUiDetailsMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EclipseLinkConverterStateObject
extends AbstractNode {
    private String name;
    private Class<? extends EclipseLinkConverter> converterType;
    private Node.Validator validator;
    private EclipseLinkConverterContainer converterContainer;
    static final String NAME_PROPERTY = "name";
    static final String CONVERTER_TYPE_PROPERTY = "converterType";

    EclipseLinkConverterStateObject(EclipseLinkConverterContainer converterContainer) {
        super(null);
        this.converterContainer = converterContainer;
    }

    private boolean addNumberOfConvertersProblemsTo(List<Node.Problem> currentProblems) {
        if (this.converterContainer.getMaximumAllowedConverters() <= this.converterContainer.getConvertersSize()) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTERS_COMPOSITE_MAX_CONVERTERS_ERROR_MESSAGE, 3, new Object[]{this.converterContainer.getMaximumAllowedConverters()}));
            return false;
        }
        return true;
    }

    private void addNameProblemsTo(List<Node.Problem> currentProblems) {
        if (StringTools.isBlank((String)this.name)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_STATE_OBJECT_NAME_MUST_BE_SPECIFIED, 3));
        } else if (this.names().contains(this.name)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_STATE_OBJECT_NAME_EXISTS, 2));
        } else if (ArrayTools.contains((Object[])EclipseLinkConvert.RESERVED_CONVERTER_NAMES, (Object)this.name)) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_STATE_OBJECT_NAME_IS_RESERVED, 3));
        }
    }

    private void addConverterTypeProblemsTo(List<Node.Problem> currentProblems) {
        if (this.converterType == null) {
            currentProblems.add(this.buildProblem(JptJpaEclipseLinkUiDetailsMessages.ECLIPSELINK_CONVERTER_STATE_OBJECT_TYPE_MUST_BE_SPECIFIED, 3));
        }
    }

    protected void addProblemsTo(List<Node.Problem> currentProblems) {
        super.addProblemsTo(currentProblems);
        boolean continueValidating = this.addNumberOfConvertersProblemsTo(currentProblems);
        if (continueValidating) {
            this.addNameProblemsTo(currentProblems);
            this.addConverterTypeProblemsTo(currentProblems);
        }
    }

    private List<String> names() {
        ArrayList<String> names = new ArrayList<String>();
        for (EclipseLinkConverter converter : this.getPersistenceUnit().getAllConverters()) {
            names.add(converter.getName());
        }
        return names;
    }

    private EclipseLinkPersistenceUnit getPersistenceUnit() {
        return (EclipseLinkPersistenceUnit)this.converterContainer.getPersistenceUnit();
    }

    protected void checkParent(Node parentNode) {
    }

    public String displayString() {
        return null;
    }

    String getName() {
        return this.name;
    }

    Class<? extends EclipseLinkConverter> getConverterType() {
        return this.converterType;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        this.firePropertyChanged(NAME_PROPERTY, oldName, newName);
    }

    public void setConverterType(Class<? extends EclipseLinkConverter> newConverterType) {
        Class<? extends EclipseLinkConverter> oldConverterType = this.converterType;
        this.converterType = newConverterType;
        this.firePropertyChanged(CONVERTER_TYPE_PROPERTY, oldConverterType, newConverterType);
    }

    public void setValidator(Node.Validator validator) {
        this.validator = validator;
    }

    public Node.Validator getValidator() {
        return this.validator;
    }
}

