/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.ui.internal.menus;

import com.ibm.icu.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.utility.internal.ArrayTools;
import org.eclipse.jpt.common.utility.internal.ComparatorAdapter;
import org.eclipse.jpt.common.utility.internal.iterable.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.TransformationIterable;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jpa.core.JpaStructureNode;
import org.eclipse.jpt.jpa.ui.JpaPlatformUi;
import org.eclipse.jpt.jpa.ui.details.DefaultMappingUiDefinition;
import org.eclipse.jpt.jpa.ui.details.MappingUiDefinition;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapAsContribution<T extends JpaStructureNode>
extends CompoundContributionItem
implements IWorkbenchContribution {
    private IServiceLocator serviceLocator;
    protected static final Comparator<MappingUiDefinition> MAPPING_UI_DEFINITION_COMPARATOR = new MappingUiDefinitionComparator();

    public void initialize(IServiceLocator locator) {
        this.serviceLocator = locator;
    }

    protected IContributionItem[] getContributionItems() {
        return (IContributionItem[])ArrayTools.array(this.getContributionItems_(), IContributionItem.class);
    }

    protected Iterable<IContributionItem> getContributionItems_() {
        return new TransformationIterable(this.getMappingUiDefinitions(), (Transformer)new MappingUiDefinitionTransformer());
    }

    protected Iterable<MappingUiDefinition> getMappingUiDefinitions() {
        return this.getMappingUiDefinitions(this.getFirstSelectedElement());
    }

    protected T getFirstSelectedElement() {
        return (T)((JpaStructureNode)this.getSelection().getFirstElement());
    }

    protected IStructuredSelection getSelection() {
        return (IStructuredSelection)this.getHandlerService().getCurrentState().getVariable("selection");
    }

    protected IHandlerService getHandlerService() {
        return (IHandlerService)this.serviceLocator.getService(IHandlerService.class);
    }

    protected Iterable<MappingUiDefinition> getMappingUiDefinitions(T node) {
        JpaPlatformUi jpaPlatformUi = (JpaPlatformUi)node.getJpaPlatform().getAdapter(JpaPlatformUi.class);
        CompositeIterable defs = jpaPlatformUi != null ? this.getSortedMappingUiDefinitions(jpaPlatformUi, node) : IterableTools.emptyIterable();
        DefaultMappingUiDefinition defaultDef = jpaPlatformUi != null ? this.getDefaultMappingUiDefinition(jpaPlatformUi, node) : null;
        return defaultDef == null ? defs : IterableTools.insert((Object)defaultDef, defs);
    }

    protected Iterable<MappingUiDefinition> getSortedMappingUiDefinitions(JpaPlatformUi jpaPlatformUi, T node) {
        return IterableTools.sort(this.getMappingUiDefinitions(jpaPlatformUi, node), this.getDefinitionsComparator());
    }

    protected abstract Iterable<MappingUiDefinition> getMappingUiDefinitions(JpaPlatformUi var1, T var2);

    protected Comparator<MappingUiDefinition> getDefinitionsComparator() {
        return MAPPING_UI_DEFINITION_COMPARATOR;
    }

    protected abstract DefaultMappingUiDefinition getDefaultMappingUiDefinition(JpaPlatformUi var1, T var2);

    protected IContributionItem buildContributionItem(MappingUiDefinition mappingUiProvider) {
        return new CommandContributionItem(this.buildContributionItemParameter(mappingUiProvider));
    }

    protected CommandContributionItemParameter buildContributionItemParameter(MappingUiDefinition mappingUiDefinition) {
        CommandContributionItemParameter parameter = new CommandContributionItemParameter(this.serviceLocator, this.buildCommandContributionItemParameterID(mappingUiDefinition), this.getCommandID(), 32);
        parameter.label = mappingUiDefinition.getLabel();
        HashMap<String, String> parameters = new HashMap<String, String>(1);
        parameters.put(this.getCommandParameterID(), mappingUiDefinition.getKey());
        parameter.parameters = parameters;
        parameter.icon = mappingUiDefinition.getImageDescriptor();
        parameter.visibleEnabled = true;
        return parameter;
    }

    protected String buildCommandContributionItemParameterID(MappingUiDefinition mappingUiDefinition) {
        return String.valueOf(this.getCommandID()) + '.' + mappingUiDefinition.getKey();
    }

    protected abstract String getCommandID();

    protected abstract String getCommandParameterID();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class MappingUiDefinitionComparator
    extends ComparatorAdapter<MappingUiDefinition> {
        protected MappingUiDefinitionComparator() {
        }

        public int compare(MappingUiDefinition def1, MappingUiDefinition def2) {
            return Collator.getInstance().compare(def1.getLabel(), def2.getLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MappingUiDefinitionTransformer
    extends TransformerAdapter<MappingUiDefinition, IContributionItem> {
        protected MappingUiDefinitionTransformer() {
        }

        public IContributionItem transform(MappingUiDefinition def) {
            return MapAsContribution.this.buildContributionItem(def);
        }
    }
}

