/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.analyze.impl.standard.analyze;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jubula.client.analyze.definition.IAnalyze;
import org.eclipse.jubula.client.analyze.impl.standard.i18n.Messages;
import org.eclipse.jubula.client.analyze.internal.AnalyzeParameter;
import org.eclipse.jubula.client.analyze.internal.AnalyzeResult;
import org.eclipse.jubula.client.analyze.internal.helper.PortableNodeInformationHelper;
import org.eclipse.jubula.client.analyze.internal.helper.ProjectContextHelper;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.TreeTraverser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Chain
implements IAnalyze {
    private List<Object> m_chains = new ArrayList<Object>();
    private List<ISpecTestCasePO> m_chainParents;
    private ISpecTestCasePO m_parentSpecTC;
    private IProgressMonitor m_monitor;
    private List<String> m_chain;
    private List<List<String>> m_lists;

    public List<List<String>> getLists() {
        return this.m_lists;
    }

    public void setLists(List<List<String>> lists) {
        this.m_lists = lists;
    }

    public List<String> getChain() {
        return this.m_chain;
    }

    public void setChain(List<String> chain) {
        this.m_chain = chain;
    }

    public IProgressMonitor getMonitor() {
        return this.m_monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.m_monitor = monitor;
    }

    public ISpecTestCasePO getParentSpecTC() {
        return this.m_parentSpecTC;
    }

    public void setParentSpecTC(ISpecTestCasePO parent) {
        this.m_parentSpecTC = parent;
    }

    public List<ISpecTestCasePO> getParents() {
        return this.m_chainParents;
    }

    public void setParents(List<ISpecTestCasePO> parents) {
        this.m_chainParents = parents;
    }

    public List<Object> getChains() {
        return this.m_chains;
    }

    public AnalyzeResult execute(Object obj2analyze, IProgressMonitor monitor, String resultType, List<AnalyzeParameter> param, String analyzeName, ExecutionEvent event) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        monitor.subTask(Messages.AnalysingProjects);
        int traverseAmount = 1;
        if (obj2analyze instanceof IProjectPO) {
            traverseAmount = (int)NodePM.getNumNodes((long)((IProjectPO)obj2analyze).getId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        } else if (obj2analyze instanceof INodePO) {
            traverseAmount = (int)NodePM.getNumNodes((long)((INodePO)obj2analyze).getParentProjectId(), (EntityManager)GeneralStorage.getInstance().getMasterSession());
        }
        NodeOperation nodeOp = new NodeOperation(progress.newChild(30).setWorkRemaining(traverseAmount));
        this.traverse(obj2analyze, nodeOp, ProjectContextHelper.getObjContType());
        monitor.subTask(Messages.ChainBeginning);
        this.setParents(new ArrayList<ISpecTestCasePO>());
        monitor.subTask(Messages.PossibleChildren);
        this.anlayzePossibleChainElements(nodeOp, progress.newChild(65));
        List<ISpecTestCasePO> l = this.getParents();
        l.size();
        monitor.subTask(Messages.ConstructChains);
        this.constructChains(progress.newChild(5));
        return new AnalyzeResult(resultType, this.getLists(), null);
    }

    private void traverse(Object obj, NodeOperation nodeOp, String objContType) {
        if (obj instanceof INodePO && objContType.equals("IExecObjContPO")) {
            INodePO root = (INodePO)obj;
            TreeTraverser tt = new TreeTraverser(root, (ITreeNodeOperation)nodeOp, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        } else if (obj instanceof INodePO && objContType.equals("ISpecObjContPO")) {
            INodePO root = (INodePO)obj;
            TreeTraverser tt = new TreeTraverser(root, (ITreeNodeOperation)nodeOp, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        } else if (obj instanceof INodePO && objContType.equals("project")) {
            INodePO root = (INodePO)obj;
            TreeTraverser tt = new TreeTraverser(root, (ITreeNodeOperation)nodeOp, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        } else if (obj instanceof INodePO && objContType.equals("")) {
            INodePO root = (INodePO)obj;
            TreeTraverser tt = new TreeTraverser(root, (ITreeNodeOperation)nodeOp, true, true){

                protected void traverseReusedProjectSpecPart(ITreeTraverserContext<INodePO> context, IProjectPO project) {
                }
            };
            tt.traverse(true);
        }
    }

    private void anlayzePossibleChainElements(NodeOperation nodeOp, SubMonitor monitor) {
        monitor.setWorkRemaining(nodeOp.getSingleUsedNodeGUIDs().size());
        int counter = 0;
        for (ISpecTestCasePO sp : nodeOp.getSingleUsedSpecTCs()) {
            boolean isParent = true;
            monitor.subTask(String.valueOf(Messages.PossibleChildren) + " " + ++counter + "/" + nodeOp.getSingleUsedSpecTCs().size());
            for (ISpecTestCasePO pp : nodeOp.getSingleUsedSpecTCs()) {
                ISpecTestCasePO spec;
                IExecTestCasePO exec;
                if (pp == null || pp.getUnmodifiableNodeList().size() != 1 || (exec = (IExecTestCasePO)pp.getUnmodifiableNodeList().get(0)) == null || (spec = exec.getSpecTestCase()) == null || !spec.getGuid().equals(sp.getGuid()) && NodePM.getInternalExecTestCases((String)sp.getGuid(), (long)sp.getParentProjectId()).size() != 0 && sp.getUnmodifiableNodeList().size() != 0) continue;
                isParent = false;
            }
            if (isParent && !this.getParents().contains(sp) && sp.getUnmodifiableNodeList().size() == 1 && NodePM.getInternalExecTestCases((String)sp.getGuid(), (long)sp.getParentProjectId()).size() == 1) {
                this.getParents().add(sp);
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            monitor.done();
            throw new OperationCanceledException();
        }
    }

    private void constructChains(SubMonitor monitor) {
        monitor.setWorkRemaining(this.getParents().size());
        this.setLists(new ArrayList<List<String>>());
        for (ISpecTestCasePO curr : this.getParents()) {
            this.setChain(new ArrayList<String>());
            this.getChain().add(curr.getGuid());
            this.getChainChildren(curr, this.getChain());
            this.getLists().add(this.getChain());
            monitor.worked(1);
            if (!monitor.isCanceled()) continue;
            monitor.done();
            throw new OperationCanceledException();
        }
    }

    private ISpecTestCasePO getChainChildren(ISpecTestCasePO parent, List<String> chain) {
        ISpecTestCasePO child;
        IExecTestCasePO exec;
        if (parent.getUnmodifiableNodeList().size() == 1 && parent.getUnmodifiableNodeList().get(0) != null && parent.getUnmodifiableNodeList().get(0) instanceof IExecTestCasePO && (exec = (IExecTestCasePO)parent.getUnmodifiableNodeList().get(0)) != null && (child = exec.getSpecTestCase()) != null) {
            chain.add(child.getGuid());
            this.getChainChildren(child, chain);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NodeOperation
    extends AbstractNonPostOperatingTreeNodeOperation<INodePO> {
        private SubMonitor m_progress;
        private List<String> m_singleUseNodeGUID = new ArrayList<String>();
        private List<ISpecTestCasePO> m_singleUsedSpecTCs = new ArrayList<ISpecTestCasePO>();

        public NodeOperation(SubMonitor monitor) {
            this.setMonitor(monitor);
        }

        public void setMonitor(SubMonitor monitor) {
            this.m_progress = monitor;
        }

        public SubMonitor getMonitor() {
            return this.m_progress;
        }

        private List<String> getSingleUsedNodeGUIDs() {
            return this.m_singleUseNodeGUID;
        }

        private List<ISpecTestCasePO> getSingleUsedSpecTCs() {
            return this.m_singleUsedSpecTCs;
        }

        public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
            if (!(node instanceof IEventExecTestCasePO)) {
                if (node instanceof ISpecTestCasePO) {
                    ISpecTestCasePO spec = (ISpecTestCasePO)node;
                    PortableNodeInformationHelper.getNodeInformation().put(spec.getGuid(), spec.getParentProjectId());
                    if (!this.getSingleUsedNodeGUIDs().contains(spec.getGuid()) && NodePM.getInternalExecTestCases((String)spec.getGuid(), (long)spec.getParentProjectId()).size() == 1 && spec.getUnmodifiableNodeList().size() <= 1) {
                        this.getSingleUsedNodeGUIDs().add(spec.getGuid());
                        this.getSingleUsedSpecTCs().add(spec);
                        return !alreadyVisited;
                    }
                }
                if (node instanceof IExecTestCasePO) {
                    ISpecTestCasePO spec;
                    IExecTestCasePO exec = (IExecTestCasePO)node;
                    exec.getSpecTestCase();
                    if (exec.getSpecTestCase() != null && (spec = exec.getSpecTestCase()).getParentProjectId() != GeneralStorage.getInstance().getProject().getId()) {
                        PortableNodeInformationHelper.getNodeInformation().put(spec.getGuid(), spec.getParentProjectId());
                        if (!this.getSingleUsedNodeGUIDs().contains(spec.getGuid()) && NodePM.getInternalExecTestCases((String)spec.getGuid(), (long)spec.getParentProjectId()).size() == 1 && spec.getParentProjectId().toString().equals(GeneralStorage.getInstance().getProject().getId().toString())) {
                            this.getSingleUsedNodeGUIDs().add(spec.getGuid());
                            this.getSingleUsedSpecTCs().add(spec);
                            return !alreadyVisited;
                        }
                    }
                    return !alreadyVisited;
                }
                this.getMonitor().worked(1);
                if (this.getMonitor().isCanceled()) {
                    this.getMonitor().done();
                    throw new OperationCanceledException();
                }
            }
            return !alreadyVisited;
        }
    }
}

