/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.businessprocess.db.TestSuiteBP;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.NodePM;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.PersistenceManager;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.utils.AbstractNonPostOperatingTreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.ITreeTraverserContext;
import org.eclipse.jubula.client.core.utils.SpecTreeTraverser;
import org.eclipse.jubula.toolkit.common.utils.ToolkitUtils;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.JBException;
import org.eclipse.jubula.tools.exception.ProjectDeletedException;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsedToolkitBP {
    private static Logger log = LoggerFactory.getLogger(UsedToolkitBP.class);
    private static UsedToolkitBP instance = null;
    private Set<IUsedToolkitPO> m_usedToolkits = new HashSet<IUsedToolkitPO>();

    private UsedToolkitBP() {
    }

    public void addToolkit(ISpecTestCasePO specTC, IProjectPO project) throws PMException, ProjectDeletedException {
        Iterator<INodePO> childs = specTC.getNodeListIterator();
        HashSet<IUsedToolkitPO> addedToolkits = new HashSet<IUsedToolkitPO>();
        Set<IUsedToolkitPO> currentToolkits = this.readUsedToolkitsFromDB(project);
        while (childs.hasNext()) {
            IUsedToolkitPO usedToolkit;
            INodePO child = childs.next();
            if (!(child instanceof ICapPO) || (usedToolkit = this.addToolkit((ICapPO)child, project)) == null || currentToolkits.contains(usedToolkit)) continue;
            addedToolkits.add(usedToolkit);
        }
        this.insertIntoDB(addedToolkits);
    }

    private IUsedToolkitPO addToolkit(ICapPO capPO, IProjectPO project) {
        String compType = capPO.getComponentType();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component component = compSystem.findComponent(compType);
        ToolkitPluginDescriptor descr = component.getToolkitDesriptor();
        Long projectID = project.getId();
        IUsedToolkitPO usedToolkit = PoMaker.createUsedToolkitsPO(descr.getToolkitID(), descr.getMajorVersion(), descr.getMinorVersion(), projectID);
        boolean isAdded = this.m_usedToolkits.add(usedToolkit);
        if (isAdded) {
            return usedToolkit;
        }
        return null;
    }

    private void insertIntoDB(Set<IUsedToolkitPO> usedToolkits) throws PMException, ProjectDeletedException {
        if (usedToolkits.isEmpty()) {
            return;
        }
        EntityManager session = Persistor.instance().openSession();
        IUsedToolkitPO currToolkit = null;
        try {
            try {
                EntityTransaction tx = Persistor.instance().getTransaction(session);
                Iterator<IUsedToolkitPO> iterator = usedToolkits.iterator();
                while (iterator.hasNext()) {
                    IUsedToolkitPO toolkit;
                    currToolkit = toolkit = iterator.next();
                    session.persist((Object)toolkit);
                }
                Persistor.instance().commitTransaction(session, tx);
            }
            catch (PersistenceException e) {
                PersistenceManager.handleDBExceptionForAnySession(currToolkit, e, session);
                Persistor.instance().dropSession(session);
            }
        }
        finally {
            Persistor.instance().dropSession(session);
        }
    }

    public synchronized Set<IUsedToolkitPO> readUsedToolkitsFromDB(IProjectPO project) throws PMException {
        block6: {
            if (project == null) {
                this.m_usedToolkits = new HashSet<IUsedToolkitPO>(0);
                return new HashSet<IUsedToolkitPO>(this.m_usedToolkits);
            }
            EntityManager session = Persistor.instance().openSession();
            try {
                try {
                    Query q = session.createQuery("select USEDTOOLKITS from UsedToolkitPO as USEDTOOLKITS where USEDTOOLKITS.hbmParentProjectId = :projectID");
                    q.setParameter("projectID", (Object)project.getId());
                    List toolkits = q.getResultList();
                    this.m_usedToolkits = new HashSet<IUsedToolkitPO>(toolkits);
                }
                catch (PersistenceException e) {
                    PersistenceManager.handleDBExceptionForAnySession(null, e, session);
                    Persistor.instance().dropSessionWithoutLockRelease(session);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Persistor.instance().dropSessionWithoutLockRelease(session);
                throw throwable;
            }
            Persistor.instance().dropSessionWithoutLockRelease(session);
        }
        return new HashSet<IUsedToolkitPO>(this.m_usedToolkits);
    }

    public void refreshToolkitInfo(IProjectPO project) throws PMException, ProjectDeletedException {
        this.refreshToolkitInfo(project, null);
    }

    public void refreshToolkitInfo(final IProjectPO project, final IProgressMonitor monitor) throws PMException, ProjectDeletedException {
        EntityManager s = Persistor.instance().openSession();
        try {
            this.deleteToolkitsFromDB(s, project.getId(), true);
        }
        finally {
            Persistor.instance().dropSession(s);
        }
        this.m_usedToolkits.clear();
        AbstractNonPostOperatingTreeNodeOperation<INodePO> addToolkitOP = new AbstractNonPostOperatingTreeNodeOperation<INodePO>(){

            @Override
            public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                if (node instanceof ICapPO) {
                    if (monitor != null && monitor.isCanceled()) {
                        ctx.setContinued(false);
                        return true;
                    }
                    UsedToolkitBP.this.addToolkit((ICapPO)node, project);
                }
                return true;
            }
        };
        SpecTreeTraverser traverser = new SpecTreeTraverser(project, (ITreeNodeOperation<INodePO>)addToolkitOP);
        traverser.traverse();
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.insertIntoDB(this.m_usedToolkits);
    }

    public void deleteToolkitsFromDB(EntityManager s, Long parentProjectId, boolean commit) throws PMException, ProjectDeletedException {
        try {
            if (commit) {
                EntityTransaction tx = Persistor.instance().getTransaction(s);
                this.executeDeleteStatement(s, parentProjectId);
                Persistor.instance().commitTransaction(s, tx);
            } else {
                this.executeDeleteStatement(s, parentProjectId);
            }
        }
        catch (PersistenceException e) {
            String msg = String.valueOf(Messages.DeletionOfToolkitsFailed) + ".";
            log.error(msg, (Throwable)e);
            throw new PMException(msg, MessageIDs.E_DB_SAVE);
        }
    }

    private synchronized void executeDeleteStatement(EntityManager s, Long parentProjectId) {
        Query q = s.createQuery("delete from UsedToolkitPO u where u.hbmParentProjectId = :parentProjId");
        q.setParameter("parentProjId", (Object)parentProjectId);
        q.executeUpdate();
    }

    public static UsedToolkitBP getInstance() {
        if (instance == null) {
            instance = new UsedToolkitBP();
        }
        return instance;
    }

    public Set<IUsedToolkitPO> getUsedToolkits() {
        return new HashSet<IUsedToolkitPO>(this.m_usedToolkits);
    }

    public String getToolkitLevel(INodePO node) {
        String level = "abstract";
        node.setToolkitLevel("abstract");
        if (node instanceof ICapPO) {
            ICapPO cap = (ICapPO)node;
            String compType = cap.getComponentType();
            Component comp = ComponentBuilder.getInstance().getCompSystem().findComponent(compType);
            level = comp.getToolkitDesriptor().getLevel();
            node.setToolkitLevel(level);
            return level;
        }
        Iterator<INodePO> iter = node.getNodeListIterator();
        if (node instanceof IProjectPO) {
            iter = TestSuiteBP.getListOfTestSuites().iterator();
        }
        String mainLevel = "abstract";
        while (iter.hasNext()) {
            level = this.getToolkitLevel(iter.next());
            if (!ToolkitUtils.isToolkitMoreConcrete((String)level, (String)mainLevel)) continue;
            mainLevel = level;
        }
        node.setToolkitLevel(mainLevel);
        return mainLevel;
    }

    public void updateToolkitLevel(INodePO node, String oldLevel) {
        INodePO parent;
        String oldTkLevel = oldLevel;
        String newLevel = this.getToolkitLevel(node);
        if (oldTkLevel.length() == 0) {
            oldTkLevel = newLevel;
        }
        if (newLevel.equals(oldTkLevel)) {
            return;
        }
        boolean moreConcrete = ToolkitUtils.isToolkitMoreConcrete((String)newLevel, (String)oldTkLevel);
        if (node instanceof ISpecTestCasePO) {
            ISpecTestCasePO specTC = (ISpecTestCasePO)node;
            List<IExecTestCasePO> execs = NodePM.getInternalExecTestCases(specTC.getGuid(), specTC.getParentProjectId());
            for (IExecTestCasePO exec : execs) {
                INodePO execParent = exec.getParentNode();
                String parentLevel = execParent.getToolkitLevel();
                if (ToolkitUtils.isToolkitMoreConcrete((String)parentLevel, (String)oldTkLevel) || !moreConcrete && this.existsCapWithLevel(oldTkLevel, execParent)) continue;
                String oldLev = execParent.getToolkitLevel();
                execParent.setToolkitLevel(newLevel);
                this.updateToolkitLevel(execParent, oldLev);
            }
        }
        if ((parent = node.getParentNode()) instanceof ICategoryPO) {
            parent = parent.getParentNode();
            while (parent instanceof ICategoryPO && parent != null) {
                parent = parent.getParentNode();
            }
        }
        if (parent == null) {
            parent = GeneralStorage.getInstance().getProject();
        }
        if (parent == null) {
            return;
        }
        String parentLevel = parent.getToolkitLevel();
        if (moreConcrete ? parentLevel.equals(newLevel) || ToolkitUtils.isToolkitMoreConcrete((String)parentLevel, (String)newLevel) : this.existsCapWithLevel(oldTkLevel, parent)) {
            return;
        }
        parent.setToolkitLevel(newLevel);
        if (parent.getParentNode() == null) {
            return;
        }
        this.updateToolkitLevel(parent.getParentNode(), parentLevel);
    }

    public List<ToolkitPluginError> checkUsedToolkitPluginVersions(Set<IUsedToolkitPO> usedToolkits) {
        ArrayList<ToolkitPluginError> errors = new ArrayList<ToolkitPluginError>(0);
        List toolkitPluginDescriptors = ComponentBuilder.getInstance().getCompSystem().getAllToolkitPluginDescriptors();
        for (IUsedToolkitPO usedTk : usedToolkits) {
            int usedTkMajVers = usedTk.getMajorVersion();
            int usedTkMinVers = usedTk.getMinorVersion();
            for (ToolkitPluginDescriptor plDescr : toolkitPluginDescriptors) {
                if (!usedTk.getToolkitId().equals(plDescr.getToolkitID())) continue;
                int pluginMajVers = plDescr.getMajorVersion();
                int pluginMinVers = plDescr.getMinorVersion();
                if (usedTkMajVers != pluginMajVers) {
                    errors.add(new ToolkitPluginError(ToolkitPluginError.ERROR.MAJOR_VERSION_ERROR, usedTk.getToolkitId(), pluginMajVers, usedTkMajVers));
                }
                if (usedTkMinVers < pluginMinVers) {
                    errors.add(new ToolkitPluginError(ToolkitPluginError.ERROR.MINOR_VERSION_LOWER, usedTk.getToolkitId(), pluginMinVers, usedTkMinVers));
                }
                if (usedTkMinVers <= pluginMinVers) continue;
                errors.add(new ToolkitPluginError(ToolkitPluginError.ERROR.MINOR_VERSION_HIGHER, usedTk.getToolkitId(), pluginMinVers, usedTkMinVers));
            }
        }
        return errors;
    }

    private boolean existsCapWithLevel(final String level, INodePO root) {
        final class BooleanHolder {
            private boolean m_bool = false;

            BooleanHolder() {
            }

            public boolean getBool() {
                return this.m_bool;
            }

            public void setBool(boolean bool) {
                this.m_bool = bool;
            }
        }
        final BooleanHolder treeOpResult = new BooleanHolder();
        AbstractNonPostOperatingTreeNodeOperation<INodePO> levelSearchOp = new AbstractNonPostOperatingTreeNodeOperation<INodePO>(){
            {
            }

            @Override
            public boolean operate(ITreeTraverserContext<INodePO> ctx, INodePO parent, INodePO node, boolean alreadyVisited) {
                ICapPO cap;
                if (node instanceof ICapPO && level.equals((cap = (ICapPO)node).getToolkitLevel())) {
                    treeOpResult.setBool(true);
                    ctx.setContinued(false);
                }
                return true;
            }
        };
        SpecTreeTraverser traverser = new SpecTreeTraverser(root, (ITreeNodeOperation<INodePO>)levelSearchOp);
        traverser.traverse();
        return treeOpResult.getBool();
    }

    private List<ToolkitPluginDescriptor> getPathToRoot(ToolkitPluginDescriptor toolkit) {
        LinkedList<ToolkitPluginDescriptor> path = new LinkedList<ToolkitPluginDescriptor>();
        ToolkitPluginDescriptor currentToolkit = toolkit;
        while (currentToolkit != null) {
            path.add(0, currentToolkit);
            ToolkitPluginDescriptor included = ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(currentToolkit.getIncludes());
            ToolkitPluginDescriptor toolkitPluginDescriptor = currentToolkit = included != null ? included : ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(currentToolkit.getDepends());
        }
        return path;
    }

    public List<ToolkitPluginDescriptor> getAllowedProjectToolkits(IProjectPO project) {
        ArrayList<ToolkitPluginDescriptor> allowedToolkits = new ArrayList<ToolkitPluginDescriptor>();
        try {
            this.refreshToolkitInfo(project);
        }
        catch (PMException pMException) {
        }
        catch (ProjectDeletedException projectDeletedException) {}
        Set<ToolkitPluginDescriptor> allowedByAuts = this.getAllowedProjectToolkitsAut(project.getAutMainList());
        Set<ToolkitPluginDescriptor> allowedByReusedProjects = this.getAllowedProjectToolkitsReused(project.getUsedProjects());
        Set<ToolkitPluginDescriptor> allowedBySteps = this.getAllowedProjectToolkitsStep(this.getUsedToolkits());
        allowedToolkits.addAll(ComponentBuilder.getInstance().getCompSystem().getAllToolkitPluginDescriptors());
        allowedToolkits.retainAll(allowedByAuts);
        allowedToolkits.retainAll(allowedByReusedProjects);
        allowedToolkits.retainAll(allowedBySteps);
        return allowedToolkits;
    }

    private Set<ToolkitPluginDescriptor> getAllowedProjectToolkitsStep(Set<IUsedToolkitPO> usedToolkits) {
        HashSet<ToolkitPluginDescriptor> stepToolkits = new HashSet<ToolkitPluginDescriptor>();
        for (IUsedToolkitPO usedTk : usedToolkits) {
            stepToolkits.add(ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(usedTk.getToolkitId()));
        }
        return this.getMostConcreteAllowed(stepToolkits);
    }

    private List<ToolkitPluginDescriptor> getLongestPathToRoot(Set<ToolkitPluginDescriptor> toolkits) {
        List<ToolkitPluginDescriptor> longestPath = new ArrayList<ToolkitPluginDescriptor>();
        for (ToolkitPluginDescriptor toolkit : toolkits) {
            List<ToolkitPluginDescriptor> pathToRoot = this.getPathToRoot(toolkit);
            if (pathToRoot.size() <= longestPath.size()) continue;
            longestPath = pathToRoot;
        }
        return longestPath;
    }

    private Set<ToolkitPluginDescriptor> getAllowedProjectToolkitsReused(Set<IReusedProjectPO> reusedProjects) {
        HashSet<ToolkitPluginDescriptor> reusedToolkits = new HashSet<ToolkitPluginDescriptor>();
        for (IReusedProjectPO reused : reusedProjects) {
            try {
                IProjectPO reusedProject = ProjectPM.loadProjectFromMaster(reused);
                if (reusedProject == null) continue;
                reusedToolkits.add(ComponentBuilder.getInstance().getCompSystem().getToolkitPluginDescriptor(reusedProject.getToolkit()));
            }
            catch (JBException jBException) {}
        }
        return this.getMostConcreteAllowed(reusedToolkits);
    }

    private Set<ToolkitPluginDescriptor> getMostConcreteAllowed(Set<ToolkitPluginDescriptor> toolkits) {
        HashSet<ToolkitPluginDescriptor> allowedToolkits = new HashSet<ToolkitPluginDescriptor>();
        allowedToolkits.addAll(ComponentBuilder.getInstance().getCompSystem().getAllToolkitPluginDescriptors());
        List<ToolkitPluginDescriptor> longestPathToRoot = this.getLongestPathToRoot(toolkits);
        if (longestPathToRoot.size() > 0) {
            ToolkitPluginDescriptor mostConcreteToolkit = longestPathToRoot.get(longestPathToRoot.size() - 1);
            mostConcreteToolkit = this.getMostConcreteIndependentToolkit(mostConcreteToolkit);
            allowedToolkits.retainAll(this.getDescendants(mostConcreteToolkit));
        }
        return allowedToolkits;
    }

    private ToolkitPluginDescriptor getMostConcreteIndependentToolkit(ToolkitPluginDescriptor baseToolkit) {
        ToolkitPluginDescriptor currentToolkit = baseToolkit;
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        while (currentToolkit != null && compSystem.getToolkitPluginDescriptor(currentToolkit.getIncludes()) == null && compSystem.getToolkitPluginDescriptor(currentToolkit.getDepends()) != null) {
            currentToolkit = compSystem.getToolkitPluginDescriptor(currentToolkit.getDepends());
        }
        return currentToolkit;
    }

    private Set<ToolkitPluginDescriptor> getAllowedProjectToolkitsAut(Set<IAUTMainPO> projectAuts) {
        CompSystem compSys = ComponentBuilder.getInstance().getCompSystem();
        HashSet<ToolkitPluginDescriptor> allowedToolkits = new HashSet<ToolkitPluginDescriptor>();
        HashSet<ToolkitPluginDescriptor> autToolkits = new HashSet<ToolkitPluginDescriptor>();
        if (projectAuts.isEmpty()) {
            allowedToolkits.addAll(compSys.getAllToolkitPluginDescriptors());
        }
        for (IAUTMainPO autMain : projectAuts) {
            String autToolkit = autMain.getToolkit();
            autToolkits.add(compSys.getToolkitPluginDescriptor(autToolkit));
        }
        LinkedList<List<ToolkitPluginDescriptor>> pathsToRoot = new LinkedList<List<ToolkitPluginDescriptor>>();
        for (ToolkitPluginDescriptor toolkit : autToolkits) {
            List<ToolkitPluginDescriptor> path = this.getPathToRoot(toolkit);
            pathsToRoot.add(path);
        }
        if (!pathsToRoot.isEmpty()) {
            List refPath = (List)pathsToRoot.get(0);
            int i = 0;
            while (i < refPath.size()) {
                ToolkitPluginDescriptor toolkit = (ToolkitPluginDescriptor)refPath.get(i);
                boolean isCommon = true;
                int j = 1;
                while (j < pathsToRoot.size() && isCommon) {
                    List otherPath = (List)pathsToRoot.get(j);
                    isCommon = otherPath.size() > i && ((ToolkitPluginDescriptor)otherPath.get(i)).equals(toolkit);
                    ++j;
                }
                if (isCommon) {
                    allowedToolkits.add(toolkit);
                }
                ++i;
            }
        }
        return allowedToolkits;
    }

    private Set<ToolkitPluginDescriptor> getDescendants(ToolkitPluginDescriptor toolkit) {
        HashSet<ToolkitPluginDescriptor> descendants = new HashSet<ToolkitPluginDescriptor>();
        descendants.add(toolkit);
        List allToolkits = ComponentBuilder.getInstance().getCompSystem().getAllToolkitPluginDescriptors();
        for (ToolkitPluginDescriptor toolkitDesc : allToolkits) {
            if (!ToolkitUtils.doesToolkitInclude((String)toolkitDesc.getToolkitID(), (String)toolkit.getToolkitID())) continue;
            descendants.add(toolkitDesc);
        }
        return descendants;
    }

    public static class ToolkitPluginError {
        private ERROR m_error = null;
        private String m_toolkitId = null;
        private int m_pluginToolkitVersion = 0;
        private int m_usedToolkitVerison = 0;

        public ToolkitPluginError(ERROR error, String toolkitId, int pluginToolkitVersion, int usedToolkitVerison) {
            this.m_error = error;
            this.m_toolkitId = toolkitId;
            this.m_pluginToolkitVersion = pluginToolkitVersion;
            this.m_usedToolkitVerison = usedToolkitVerison;
        }

        public ERROR getError() {
            return this.m_error;
        }

        public int getPluginToolkitVersion() {
            return this.m_pluginToolkitVersion;
        }

        public int getUsedToolkitVerison() {
            return this.m_usedToolkitVerison;
        }

        public String getToolkitId() {
            return this.m_toolkitId;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum ERROR {
            MAJOR_VERSION_ERROR,
            MINOR_VERSION_LOWER,
            MINOR_VERSION_HIGHER;

        }
    }
}

