/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.commands;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections.list.UnmodifiableList;
import org.eclipse.jubula.client.core.IRecordListener;
import org.eclipse.jubula.client.core.MessageFactory;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.TestExecution;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.commands.AUTModeChangedCommand;
import org.eclipse.jubula.client.core.communication.AUTConnection;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.communication.ICommand;
import org.eclipse.jubula.communication.message.CAPRecordedMessage;
import org.eclipse.jubula.communication.message.CAPTestMessage;
import org.eclipse.jubula.communication.message.Message;
import org.eclipse.jubula.communication.message.MessageCap;
import org.eclipse.jubula.communication.message.MessageParam;
import org.eclipse.jubula.communication.message.ShowObservInfoMessage;
import org.eclipse.jubula.communication.message.ShowRecordedActionMessage;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.exception.CommunicationException;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.xml.businessmodell.CompSystem;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAPRecordedCommand
implements ICommand {
    public static final char COMMENT_SYMBOL = '\'';
    private static final Logger LOG = LoggerFactory.getLogger(CAPRecordedCommand.class);
    private static ISpecTestCasePO recSpecTestCase;
    private static IWritableComponentNameMapper compNamesMapper;
    private static IRecordListener recordListener;
    private static Locale recordLocale;
    private CAPRecordedMessage m_capRecordedMessage;
    private String m_recAction = null;
    private String m_extraMsg = null;
    private String m_wrongToolkit = Messages.CurrenActionNotAvailabelForSelectedToolkit;

    public String getRecAction() {
        return this.m_recAction;
    }

    public void setRecAction(String recAction) {
        this.m_recAction = recAction;
    }

    public Message getMessage() {
        return this.m_capRecordedMessage;
    }

    public void setMessage(Message message) {
        this.m_capRecordedMessage = (CAPRecordedMessage)message;
    }

    public Message execute() {
        MessageCap messageCap = this.m_capRecordedMessage.getMessageCap();
        String compType = this.getComponentType(messageCap);
        boolean belongsToToolkit = this.belongsToToolkit(compType);
        if (belongsToToolkit) {
            block5: {
                this.setCapIntoSpecModel(messageCap, compType);
                if (!messageCap.isWebObservOld()) break block5;
                CAPTestMessage capTestMessage = MessageFactory.getCAPTestMessage(messageCap);
                capTestMessage.setMessageCap(messageCap);
                capTestMessage.setRequestAnswer(false);
                AUTConnection.getInstance().send((Message)capTestMessage);
                return null;
            }
            try {
                String recAction = this.m_recAction;
                String extraMsg = this.m_extraMsg;
                return new ShowRecordedActionMessage(true, recAction, extraMsg);
            }
            catch (IllegalArgumentException e) {
                LOG.error(Messages.ExecutedFailed, (Throwable)e);
            }
            catch (CommunicationException e) {
                LOG.error(Messages.ExecutedFailed, (Throwable)e);
            }
            return new ShowRecordedActionMessage(false);
        }
        return new ShowObservInfoMessage(this.m_wrongToolkit);
    }

    private void setCapIntoSpecModel(MessageCap messageCap, String compType) {
        ICapPO cap = this.buildCapPO(messageCap, compType);
        if (recordListener != null) {
            recordListener.capRecorded(cap, messageCap.getCi());
        }
    }

    private ICapPO buildCapPO(MessageCap messageCap, String componentType) {
        boolean isAppAction = this.isApplication(componentType);
        String componentName = isAppAction ? messageCap.getCi().generateLogicalName() : this.getOrCreateLogicalName(messageCap);
        String actionName = messageCap.getAction().getName();
        String capName = null;
        capName = CompSystemI18n.getString((String)actionName);
        if (isAppAction || messageCap.isWebObservOld()) {
            capName = CompSystemI18n.getString((String)actionName);
        } else {
            capName = CompSystemI18n.getString((String)actionName);
            String normName = this.removeMnemonics(messageCap.getCi().getComponentName());
            String altName = this.removeMnemonics(messageCap.getCi().getAlternativeDisplayName());
            capName = altName == null ? capName.concat(" on " + this.minimizeCapName(normName)) : capName.concat(" on " + altName);
        }
        this.m_recAction = capName;
        this.m_extraMsg = messageCap.getExtraMessage();
        ICapPO recCap = NodeMaker.createCapPO(capName, componentName, componentType, actionName);
        recCap.setComponentName(null);
        try {
            ComponentNamesBP.getInstance().setCompName(recCap, componentName, ComponentNamesBP.CompNameCreationContext.STEP, compNamesMapper);
        }
        catch (IncompatibleTypeException e) {
            LOG.error(String.valueOf(Messages.ErrorOccurredWhileObservingTestStep) + ".", (Throwable)((Object)e));
            return null;
        }
        catch (PMException e) {
            LOG.error(String.valueOf(Messages.ErrorOccurredWhileObservingTestStep) + ".", (Throwable)((Object)e));
            return null;
        }
        recSpecTestCase.addNode(recCap);
        List params = messageCap.getMessageParams();
        this.addTestData(recCap, params);
        return recCap;
    }

    private String getComponentType(MessageCap messageCap) {
        String componentType = messageCap.getCi().getSupportedClassName();
        CompSystem compSystem = ComponentBuilder.getInstance().getCompSystem();
        Component component = null;
        if (this.isApplication(componentType)) {
            component = compSystem.findComponent(messageCap.getCi().getComponentClassName());
        } else {
            if (componentType.equals("org.eclipse.swt.widgets.Menu")) {
                componentType = "com.bredexsw.guidancer.autswtserver.implclasses.MenuDefaultMapping";
            }
            if (componentType.equals("javax.swing.JMenuBar")) {
                componentType = "com.bredexsw.guidancer.autserver.swing.implclasses.JMenuBarDefaultMapping";
            }
            component = this.getComponentToUse(messageCap, compSystem, componentType);
        }
        while (!(component == null || component.isVisible() && component.isObservable() || component.getRealized().isEmpty())) {
            List realizedComponents = component.getRealized();
            component = (Component)realizedComponents.get(0);
        }
        componentType = this.getAbstrCompType(component, messageCap);
        return componentType;
    }

    private boolean belongsToToolkit(String compType) {
        CompSystem cs = ComponentBuilder.getInstance().getCompSystem();
        String toolkit = GeneralStorage.getInstance().getProject().getToolkit();
        String[] toolkitTypes = cs.getComponentTypes(toolkit);
        int i = 0;
        while (i < toolkitTypes.length) {
            String kitType = toolkitTypes[i];
            if (kitType.equals(compType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void addTestData(ICapPO recCap, List params) {
        ITDManager tdManager = recCap.getDataManager();
        GeneralStorage genStorage = GeneralStorage.getInstance();
        int paramNumber = 0;
        Iterator msgParamIt = params.iterator();
        Iterator paramIt = recCap.getMetaAction().getParams().iterator();
        while (msgParamIt.hasNext() && paramIt.hasNext()) {
            MessageParam msgParam = (MessageParam)msgParamIt.next();
            String value = msgParam.getValue();
            if (value != null && !value.equals("")) {
                ITestDataPO testData = PoMaker.createTestDataPO();
                testData.setValue(recordLocale, value, genStorage.getProject());
                tdManager.updateCell(testData, 0, paramNumber);
            }
            boolean bool = value != null && !value.equals("");
            CompletenessGuard.setCompletenessTestData(recCap, recordLocale, bool);
            ++paramNumber;
        }
    }

    private boolean isApplication(String componentType) {
        return componentType.equals("com.bredexsw.guidancer.autserver.swing.implclasses.GraphicApplication") || componentType.equals("com.bredexsw.guidancer.server.implclasses.GraphicApplication") || componentType.equals("com.bredexsw.guidancer.autswtserver.implclasses.GraphicApplication") || componentType.equals("com.bredexsw.guidancer.autieserver.implclasses.GraphicApplication") || componentType.equals("guidancer.concrete.GraphicApplication");
    }

    private String getAbstrCompType(Component comp, MessageCap mc) {
        String compTyp = null;
        String[] argArray = this.createArgTypeArray(UnmodifiableList.decorate((List)mc.getMessageParams()));
        String actionName = comp.findActionByMethodSignature(mc.getMethod(), argArray).getName();
        compTyp = actionName.equals("CompSystem.Click") || actionName.equals("CompSystem.VerifyEnabled") || actionName.equals("CompSystem.VerifyExists") || actionName.equals("CompSystem.VerifyFocus") || actionName.equals("CompSystem.VerifyProperty") || actionName.equals("CompSystem.PopupSelectByTextPath") ? "guidancer.abstract.Widget" : (actionName.equals("CompSystem.InputTextDirect") || actionName.equals("CompSystem.InputText") || actionName.equals("CompSystem.VerifyEditable") ? "guidancer.abstract.TextInputSupport" : (actionName.equals("CompSystem.VerifyText") ? "guidancer.abstract.TextVerifiable" : (actionName.equals("CompSystem.VerifySelected") ? "guidancer.abstract.ButtonComp" : comp.getType())));
        return compTyp;
    }

    private String getOrCreateLogicalName(MessageCap messageCap) {
        boolean checkTechNameExists;
        String compName = null;
        IAUTMainPO connectedAut = TestExecution.getInstance().getConnectedAut();
        if (connectedAut != null && (checkTechNameExists = connectedAut.getObjMap().existTechnicalName(messageCap.getCi()))) {
            for (IObjectMappingAssoziationPO oma : connectedAut.getObjMap().getMappings()) {
                if (oma.getLogicalNames().isEmpty() || oma.getTechnicalName() == null || !oma.getTechnicalName().equals(messageCap.getCi()) || oma.getLogicalNames().get(0) == null) continue;
                for (String compNameGuid : oma.getLogicalNames()) {
                    IComponentNamePO compNamePo = compNamesMapper.getCompNameCache().getCompNamePo(compNameGuid);
                    if (compNamePo == null || !compNamePo.getParentProjectId().equals(GeneralStorage.getInstance().getProject().getId())) continue;
                    compName = compNamePo.getName();
                }
            }
        }
        if (compName == null && (compName = messageCap.getLogicalName()) == null) {
            compName = messageCap.getCi().generateLogicalName();
        }
        return compName;
    }

    private Component getComponentToUse(MessageCap messageCap, CompSystem compSystem, String componentType) {
        List supportedComponents = compSystem.findComponents(componentType);
        HashSet<Component> compsWithAction = new HashSet<Component>();
        for (Component c : supportedComponents) {
            LinkedList actionList = new LinkedList(c.getActions());
            if (!actionList.contains(messageCap.getAction())) continue;
            compsWithAction.add(c);
        }
        Component theComponentToUse = null;
        for (Component c : compsWithAction) {
            HashSet realizedIntersection = new HashSet(c.getAllRealized());
            realizedIntersection.retainAll(compsWithAction);
            if (!realizedIntersection.isEmpty()) continue;
            theComponentToUse = c;
            break;
        }
        return theComponentToUse;
    }

    private String minimizeCapName(String capName) {
        String minCapName = capName;
        String[] nameParts = null;
        nameParts = minCapName.split("\\(", 2);
        if (nameParts[0].lastIndexOf(".") > -1 && nameParts[0].length() > nameParts[0].lastIndexOf(".") + 1) {
            nameParts[0] = nameParts[0].substring(nameParts[0].lastIndexOf(".") + 1);
        }
        minCapName = nameParts[0];
        if (nameParts.length > 1) {
            minCapName = String.valueOf(minCapName) + "(" + nameParts[1];
        }
        return minCapName;
    }

    public String removeMnemonics(String name) {
        String fixedName = name;
        if (fixedName != null) {
            fixedName = fixedName.replaceAll("&", "");
        }
        return fixedName;
    }

    private String[] createArgTypeArray(List argList) {
        String[] argTypeArray = new String[argList.size()];
        int i = 0;
        while (i < argTypeArray.length) {
            MessageParam param = (MessageParam)argList.get(i);
            argTypeArray[i] = param.getType();
            ++i;
        }
        return argTypeArray;
    }

    public void timeout() {
        LOG.error(String.valueOf(this.getClass().getName()) + Messages.TimeoutCalled);
    }

    public static void setRecSpecTestCase(ISpecTestCasePO r) {
        recSpecTestCase = r;
    }

    public static ISpecTestCasePO getRecSpecTestCase() {
        return recSpecTestCase;
    }

    public static void setCompNamesMapper(IWritableComponentNameMapper compMapper) {
        compNamesMapper = compMapper;
    }

    public static void setRecordListener(IRecordListener rc) {
        recordListener = rc;
    }

    public static IRecordListener getRecordListener() {
        return recordListener;
    }

    public static void setRecordLocale(Locale locale) {
        recordLocale = locale;
    }

    public static boolean isObserving() {
        if (TestExecution.getInstance().getConnectedAut() != null) {
            switch (AUTModeChangedCommand.getAutMode()) {
                case 3: 
                case 4: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

