/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.eclipse.jubula.client.core.businessprocess.ITestResultEventListener;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.TestResultParameter;
import org.eclipse.jubula.tools.objects.event.TestErrorEvent;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestResultNode {
    public static final int NOT_YET_TESTED = 0;
    public static final int SUCCESS = 1;
    public static final int ERROR = 2;
    public static final int NO_VERIFY = 3;
    public static final int NOT_TESTED = 4;
    public static final int ERROR_IN_CHILD = 5;
    public static final int TESTING = 6;
    public static final int RETRYING = 7;
    public static final int SUCCESS_RETRY = 8;
    public static final int ABORT = 9;
    private static final Logger LOG = LoggerFactory.getLogger(TestResultNode.class);
    private int m_childIndex = -1;
    private int m_status = 0;
    private Date m_timestamp = null;
    private byte[] m_screenshot = null;
    private TestErrorEvent m_event;
    private INodePO m_node;
    private String m_componentName;
    private String m_componentType;
    private List<TestResultNode> m_resultNodeList = new ArrayList<TestResultNode>();
    private TestResultNode m_parent;
    private List<TestResultParameter> m_parameters = new LinkedList<TestResultParameter>();
    private String m_actionName;
    private List<ITestResultEventListener> m_listener = new ArrayList<ITestResultEventListener>();
    private boolean m_hasBackingNode;
    private double m_omHeuristicEquivalence = -1.0;
    private int m_noOfSimilarComponents = -1;

    public TestResultNode(INodePO node, TestResultNode parent) {
        this(true, node, parent);
    }

    public TestResultNode(boolean hasBackingNode, INodePO node, TestResultNode parent) {
        this.m_node = node;
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.addChild(this);
        }
        this.m_status = 0;
        this.m_event = null;
        this.m_hasBackingNode = hasBackingNode;
    }

    public TestResultNode(INodePO node, TestResultNode parent, int pos) {
        this.m_node = node;
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.addChildAtPosition(pos, this);
        }
        this.m_status = 0;
        this.m_event = null;
        this.m_hasBackingNode = true;
    }

    public void addChild(TestResultNode resultNode) {
        this.m_resultNodeList.add(resultNode);
        resultNode.m_parent = this;
    }

    public void addChildAtPosition(int pos, TestResultNode resultNode) {
        this.m_resultNodeList.add(pos, resultNode);
        resultNode.m_parent = this;
    }

    public INodePO getNode() {
        return this.m_node;
    }

    public TestResultNode getParent() {
        return this.m_parent;
    }

    public List<TestResultNode> getResultNodeList() {
        return this.m_resultNodeList;
    }

    public String getName() {
        if (this.m_node != null) {
            return this.m_node.getName();
        }
        return "<" + Messages.TestResultNodeGUINoNode + ">";
    }

    public void addTestResultChangedListener(ITestResultEventListener listener) {
        if (!this.m_listener.contains(listener)) {
            this.m_listener.add(listener);
        }
    }

    public void removeTestResultChangedListener(ITestResultEventListener listener) {
        this.m_listener.remove(listener);
    }

    private void fireTestResultChanged(TestResultNode res) {
        Iterator<ITestResultEventListener> iter = this.m_listener.iterator();
        while (iter.hasNext()) {
            ITestResultEventListener obj;
            ITestResultEventListener item = obj = iter.next();
            item.testResultChanged(res);
        }
    }

    public void updateResultNode(int pos, TestResultNode node) {
        for (ITestResultEventListener item : this.m_listener) {
            item.testResultNodeUpdated(this, pos, node);
        }
    }

    public int getStatus() {
        return this.m_status;
    }

    public TestErrorEvent getEvent() {
        return this.m_event;
    }

    public void setResult(int status, TestErrorEvent event) {
        boolean changed;
        boolean bl = changed = this.m_status != status || this.m_event != null && !this.m_event.equals(event) || this.m_event == null && event != null;
        if (changed) {
            this.m_status = status;
            this.m_event = event;
            if (this.m_status == 6 && this.m_timestamp == null) {
                this.m_timestamp = new Date();
            }
        }
        if (this.isError(status) && this.getParent() != null) {
            this.getParent().setResult(5, null);
        }
        if (changed) {
            this.fireTestResultChanged(this);
        }
    }

    private boolean isError(int status) {
        return status == 2 || status == 5 || status == 3 || status == 4 || status == 9;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getName()).append(this.getStatus()).toString();
    }

    public int getNextChildIndex() {
        ++this.m_childIndex;
        return this.m_childIndex;
    }

    public String getStatusString() {
        switch (this.m_status) {
            case 2: {
                return Messages.TestResultNodeStepfailed;
            }
            case 5: {
                return Messages.TestResultNodeErrorInChildren;
            }
            case 0: {
                return Messages.TestResultNodeNotYetTested;
            }
            case 1: {
                return Messages.TestResultNodeSuccessfullyTested;
            }
            case 6: {
                return Messages.TestResultNodeTesting;
            }
            case 7: {
                return Messages.TestResultNodeRetrying;
            }
            case 8: {
                return Messages.TestResultNodeSuccessRetry;
            }
            case 9: {
                return Messages.TestResultNodeAbort;
            }
        }
        return Messages.TestResultNodeUnknown;
    }

    public List<TestResultParameter> getParameters() {
        return Collections.unmodifiableList(this.m_parameters);
    }

    public void addParameter(TestResultParameter parameter) {
        this.m_parameters.add(parameter);
    }

    public void setComponentName(String componentName) {
        this.m_componentName = componentName;
    }

    public String getComponentName() {
        return this.m_componentName;
    }

    public void setComponentType(String componentType) {
        this.m_componentType = componentType;
    }

    public String getComponentType() {
        return this.m_componentType;
    }

    public void setActionName(String actionName) {
        this.m_actionName = actionName;
    }

    public String getActionName() {
        return this.m_actionName;
    }

    public Date getTimeStamp() {
        return this.m_timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.m_timestamp = timestamp;
    }

    public void setScreenshot(byte[] screenshot) {
        this.m_screenshot = screenshot;
    }

    public byte[] getScreenshot() {
        return this.m_screenshot;
    }

    public boolean hasBackingNode() {
        return this.m_hasBackingNode;
    }

    public void setOmHeuristicEquivalence(double omHeuristicEquivalence) {
        this.m_omHeuristicEquivalence = omHeuristicEquivalence;
    }

    public double getOmHeuristicEquivalence() {
        return this.m_omHeuristicEquivalence;
    }

    public void setNoOfSimilarComponents(int noOfSimilarComponents) {
        this.m_noOfSimilarComponents = noOfSimilarComponents;
    }

    public int getNoOfSimilarComponents() {
        return this.m_noOfSimilarComponents;
    }

    private TestResultNode getNextSibling() {
        TestResultNode parent = this.getParent();
        if (parent != null) {
            List<TestResultNode> siblingList = parent.getResultNodeList();
            int nodeIndex = siblingList.indexOf(this);
            if (nodeIndex == -1) {
                LOG.error(NLS.bind((String)Messages.ParentChildInconsistency, (Object)this.getName()));
            } else {
                int nextSiblingIndex = nodeIndex + 1;
                if (siblingList.size() > nextSiblingIndex) {
                    return siblingList.get(nextSiblingIndex);
                }
            }
        }
        return null;
    }

    private TestResultNode getNextExecutedNode() {
        TestResultNode nextSibling = this.getNextSibling();
        TestResultNode currentNode = this;
        while ((nextSibling == null || nextSibling.getTimeStamp() == null) && currentNode.getParent() != null) {
            currentNode = currentNode.getParent();
            nextSibling = currentNode.getNextSibling();
        }
        if (nextSibling != null && nextSibling.getTimeStamp() == null) {
            return null;
        }
        return nextSibling;
    }

    public long getDuration(Date testEndTime) {
        Date start = this.getTimeStamp();
        if (start != null) {
            TestResultNode nextExecutedNode = this.getNextExecutedNode();
            if (nextExecutedNode != null) {
                Date end = nextExecutedNode.getTimeStamp();
                return end.getTime() - start.getTime();
            }
            if (testEndTime != null) {
                return testEndTime.getTime() - start.getTime();
            }
        }
        return -1L;
    }
}

