/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.jubula.client.core.model.INodePO;

public class ExecObject {
    private INodePO m_execNode = null;
    private int m_numberDs = -1;
    private int m_index = -1;
    private int m_retryCount = 0;
    private Map<String, String> m_parameters = new HashMap<String, String>();

    public ExecObject(INodePO node, int index, int number, int retryCount) {
        this(node, index, number);
        this.m_retryCount = retryCount;
    }

    public ExecObject(INodePO node, int index, int number) {
        this.m_execNode = node;
        this.m_index = index;
        this.m_numberDs = number;
    }

    public ExecObject(INodePO node, int index) {
        this(node, index, -1);
    }

    public INodePO getExecNode() {
        return this.m_execNode;
    }

    public int getNumberDs() {
        return this.m_numberDs;
    }

    public void incrementIndex() {
        ++this.m_index;
    }

    public void decrementIndex() {
        --this.m_index;
    }

    public void incrementDataSetNumber() {
        ++this.m_numberDs;
    }

    public void decrementDataSetNumber() {
        --this.m_numberDs;
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        boolean result = false;
        if (obj != null && obj instanceof ExecObject) {
            ExecObject execObj = (ExecObject)obj;
            result = this.m_index == execObj.getIndex() && this.m_numberDs == execObj.getNumberDs() && this.m_execNode.equals(execObj.getExecNode()) && this.m_retryCount == execObj.getRetryCount();
        }
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.m_execNode.hashCode()).append(this.m_index).append(this.m_numberDs).append(this.m_retryCount).toHashCode();
    }

    public int getRetryCount() {
        return this.m_retryCount;
    }

    public void addParameter(String identifier, String value) {
        this.m_parameters.put(identifier, value);
    }

    public String getParameterValue(String parameterIdentifier) {
        return this.m_parameters.get(parameterIdentifier);
    }
}

