/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.Languages;
import org.eclipse.jubula.client.ui.rcp.actions.AbstractAction;
import org.eclipse.jubula.client.ui.rcp.actions.LanguageAction;
import org.eclipse.jubula.client.ui.rcp.businessprocess.AbstractActionBP;
import org.eclipse.jubula.client.ui.rcp.businessprocess.WorkingLanguageBP;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

public class ChooseLanguageAction
extends AbstractAction
implements IWorkbenchWindowPulldownDelegate {
    public void runWithEvent(IAction action, Event event) {
        Locale defaultLanguage;
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null && (defaultLanguage = project.getDefaultLanguage()) != null) {
            Locale lang = defaultLanguage;
            if (!WorkingLanguageBP.getInstance().getWorkingLanguage().equals(lang)) {
                WorkingLanguageBP.getInstance().setCurrentLanguage(lang);
                DataEventDispatcher.getInstance().fireLanguageChanged(lang);
            }
        }
    }

    public Menu getMenu(Control parent) {
        List languages = null;
        MenuManager menuManager = new MenuManager();
        Menu fMenu = menuManager.createContextMenu(parent);
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            languages = project.getLangHelper().getLanguageList();
            ArrayList<String> dispList = new ArrayList<String>();
            for (Locale locale : languages) {
                dispList.add(locale.getDisplayName());
            }
            Object[] dispNames = dispList.toArray(new String[dispList.size()]);
            Arrays.sort(dispNames);
            Object[] objectArray = dispNames;
            int n = dispNames.length;
            int n2 = 0;
            while (n2 < n) {
                Object lang = objectArray[n2];
                LanguageAction action = new LanguageAction((String)lang, 2);
                action.setLanguage(Languages.getInstance().getLocale((String)lang));
                action.setChecked(false);
                menuManager.add((IAction)action);
                if (((String)lang).equals(WorkingLanguageBP.getInstance().getWorkingLanguage().getDisplayName())) {
                    action.setChecked(true);
                }
                ++n2;
            }
        }
        return fMenu;
    }

    protected AbstractActionBP getActionBP() {
        return WorkingLanguageBP.getInstance();
    }
}

