/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.sourceprovider;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.sourceprovider.AbstractJBSourceProvider;
import org.eclipse.jubula.tools.exception.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservationModeSourceProvider
extends AbstractJBSourceProvider
implements DataEventDispatcher.IAutStateListener,
DataEventDispatcher.IRecordModeStateListener,
DataEventDispatcher.IOMStateListener {
    public static final String IS_OBSERVATION_RUNNING = "org.eclipse.jubula.client.ui.rcp.variable.isObservationRunning";
    private boolean m_isRecordModeRunning = false;

    public ObservationModeSourceProvider() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.addRecordModeStateListener((DataEventDispatcher.IRecordModeStateListener)this, true);
        dispatch.addAutStateListener((DataEventDispatcher.IAutStateListener)this, true);
        dispatch.addOMStateListener((DataEventDispatcher.IOMStateListener)this, true);
    }

    public void handleAutStateChanged(DataEventDispatcher.AutState state) {
        switch (state) {
            case running: {
                break;
            }
            case notRunning: {
                this.m_isRecordModeRunning = false;
                break;
            }
            default: {
                Assert.notReached((String)Messages.UnhandledAutState);
            }
        }
        this.fireModeChanged();
    }

    public void handleRecordModeStateChanged(DataEventDispatcher.RecordModeState state) {
        this.m_isRecordModeRunning = state == DataEventDispatcher.RecordModeState.running;
        this.fireModeChanged();
    }

    public void handleOMStateChanged(DataEventDispatcher.OMState state) {
        switch (state) {
            case running: {
                this.m_isRecordModeRunning = false;
                break;
            }
            case notRunning: {
                break;
            }
            default: {
                Assert.notReached((String)Messages.UnsupportedRecordModeState);
            }
        }
        this.fireModeChanged();
    }

    private void fireModeChanged() {
        this.gdFireSourceChanged(0, IS_OBSERVATION_RUNNING, this.isRunning());
    }

    public boolean isRunning() {
        return this.m_isRecordModeRunning;
    }

    public void dispose() {
        DataEventDispatcher dispatch = DataEventDispatcher.getInstance();
        dispatch.removeRecordModeStateListener((DataEventDispatcher.IRecordModeStateListener)this);
        dispatch.removeAutStateListener((DataEventDispatcher.IAutStateListener)this);
        dispatch.removeOMStateListener((DataEventDispatcher.IOMStateListener)this);
    }

    public Map<String, Object> getCurrentState() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put(IS_OBSERVATION_RUNNING, this.isRunning());
        return values;
    }

    public String[] getProvidedSourceNames() {
        return new String[]{IS_OBSERVATION_RUNNING};
    }
}

