/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.ui.controllers.propertysources.IPropertyController;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.propertydescriptors.JBPropertyDescriptor;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.CapGUIPropertySource;
import org.eclipse.jubula.client.ui.rcp.controllers.propertysources.IParameterPropertyController;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.provider.contextprovider.JBContextProvider;
import org.eclipse.jubula.client.ui.rcp.views.CompNamesView;
import org.eclipse.jubula.client.ui.rcp.views.TestCaseBrowser;
import org.eclipse.jubula.client.ui.rcp.views.TestResultTreeView;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.utils.generator.ActionInfo;
import org.eclipse.jubula.tools.utils.generator.CompSystemProcessor;
import org.eclipse.jubula.tools.utils.generator.ComponentInfo;
import org.eclipse.jubula.tools.utils.generator.ParamInfo;
import org.eclipse.jubula.tools.utils.generator.ToolkitInfo;
import org.eclipse.jubula.tools.xml.businessmodell.Action;
import org.eclipse.jubula.tools.xml.businessmodell.Component;
import org.eclipse.jubula.tools.xml.businessmodell.ToolkitPluginDescriptor;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JBPropertiesView
extends Page
implements DataEventDispatcher.IDataChangedListener,
DataEventDispatcher.IParamChangedListener,
ISelectionProvider,
DataEventDispatcher.IPartClosedListener,
DataEventDispatcher.ILanguageChangedListener,
IPropertySheetPage,
IAdaptable {
    private static final Logger LOG = LoggerFactory.getLogger(JBPropertiesView.class);
    private IPropertySource m_propSource;
    private TreeViewer m_treeViewer;
    private IStructuredSelection m_selection;
    private ISelectionChangedListener m_helpContextListener = new HelpContextListener();
    private List<ISelectionChangedListener> m_selectionListener = new ArrayList<ISelectionChangedListener>();
    private INodePO m_currentNode;
    private boolean m_isEditable;
    private IWorkbenchPart m_correspondingPart;
    private JBContextProvider m_contextProvider = new JBContextProvider();
    private GDHelpListener m_helpListener = new GDHelpListener();
    private IComponentNameMapper m_compMapper;
    private AbstractJBEditor m_currentEditor = Plugin.getDefault().getActiveGDEditor();
    private TreeViewerFocusCellManager m_focusCellManager;

    public JBPropertiesView(boolean isEditable, IComponentNameMapper compMapper) {
        this.m_compMapper = compMapper;
        this.m_isEditable = isEditable;
    }

    public void createPartControl(Composite parent) {
        this.buildTree(parent);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        Plugin.getHelpSystem().setHelp(this.m_treeViewer.getControl(), "org.eclipse.jubula.client.ua.help.guidancerPropertiesViewContextId");
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        dispatcher.addParamChangedListener((DataEventDispatcher.IParamChangedListener)this, true);
        dispatcher.addPartClosedListener((DataEventDispatcher.IPartClosedListener)this, true);
        dispatcher.addLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this, true);
        this.m_treeViewer.getControl().addHelpListener((HelpListener)this.m_helpListener);
    }

    private void buildTree(Composite parent) {
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        Tree tree = new Tree(parent, 100352);
        tree.setLayoutData((Object)layoutData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.m_treeViewer = new TreeViewer(tree);
        TreeViewerColumn expandCollapseColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        expandCollapseColumn.getColumn().setText("");
        expandCollapseColumn.getColumn().setWidth(20);
        expandCollapseColumn.getColumn().setResizable(false);
        expandCollapseColumn.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
            }
        });
        TreeViewerColumn propertyNameColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        propertyNameColumn.getColumn().setText(Messages.JubulaPropertiesViewProperty);
        propertyNameColumn.getColumn().setWidth(175);
        propertyNameColumn.setLabelProvider((CellLabelProvider)new PropertyNameLabelProvider());
        TreeViewerColumn propertyValueColumn = new TreeViewerColumn(this.m_treeViewer, 0);
        propertyValueColumn.getColumn().setText(Messages.JubulaPropertiesViewValue);
        propertyValueColumn.getColumn().setWidth(300);
        propertyValueColumn.setLabelProvider((CellLabelProvider)new PropertyValueLabelProvider());
        propertyValueColumn.setEditingSupport((EditingSupport)new PropertiesEditingSupport((ColumnViewer)this.m_treeViewer));
        this.m_treeViewer.addSelectionChangedListener(this.m_helpContextListener);
        this.m_treeViewer.setAutoExpandLevel(-1);
        this.m_treeViewer.setContentProvider((IContentProvider)new PropertiesContentProvider());
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.m_treeViewer);
        this.m_treeViewer.setComparer((IElementComparer)new PropertiesElementComparer());
        this.m_focusCellManager = new TreeViewerFocusCellManager(this.m_treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.m_treeViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.m_treeViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 2 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TreeViewerEditor.create((TreeViewer)this.m_treeViewer, (SWTFocusCellManager)this.m_focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)104);
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    public void dispose() {
        if (this.m_treeViewer != null) {
            this.m_treeViewer.removeSelectionChangedListener(this.m_helpContextListener);
        }
        DataEventDispatcher dispatcher = DataEventDispatcher.getInstance();
        dispatcher.removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        dispatcher.removeParamChangedListener((DataEventDispatcher.IParamChangedListener)this);
        dispatcher.removePartClosedListener((DataEventDispatcher.IPartClosedListener)this);
        dispatcher.removeLanguageChangedListener((DataEventDispatcher.ILanguageChangedListener)this);
        this.getSite().setSelectionProvider(null);
        this.setCurrentEditor(null);
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(final IPersistentObject po, final DataEventDispatcher.DataState dataState) {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                JBPropertiesView.this.handleDataChangedImpl(po, dataState);
            }
        });
    }

    private void handleDataChangedImpl(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        if (po == null) {
            return;
        }
        boolean parentMatch = false;
        if (this.m_currentNode != null) {
            INodePO parent = this.m_currentNode.getParentNode();
            boolean bl = parentMatch = parent != null && po.equals(parent);
        }
        if (parentMatch || po.equals(this.m_currentNode)) {
            switch (dataState) {
                case Added: 
                case StructureModified: {
                    if (!(po instanceof INodePO)) break;
                    this.m_treeViewer.refresh();
                    break;
                }
                case Deleted: {
                    this.clearView();
                    break;
                }
                case Renamed: {
                    this.m_treeViewer.refresh();
                }
            }
        }
    }

    private void clearView() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                JBPropertiesView.this.m_treeViewer.setComparer(null);
                JBPropertiesView.this.m_treeViewer.setInput(null);
                JBPropertiesView.this.setViewEnabled(false);
                JBPropertiesView.this.m_selection = (IStructuredSelection)new StructuredSelection();
            }
        });
    }

    public void handleParamChanged() {
        if (Plugin.getActivePart() instanceof PropertySheet && ((PropertySheet)Plugin.getActivePart()).getCurrentPage() != this) {
            return;
        }
        this.m_treeViewer.refresh();
        this.m_treeViewer.expandToLevel(this.m_treeViewer.getAutoExpandLevel());
    }

    private void reactOnChange(IWorkbenchPart part, IStructuredSelection selection) {
        this.m_correspondingPart = part;
        if (this.m_selection == null) {
            this.m_selection = new StructuredSelection();
        }
        Object firstElement = selection.getFirstElement();
        IStructuredSelection oldSelection = this.m_selection;
        this.m_selection = selection;
        if (firstElement == null) {
            this.m_treeViewer.setSelection(null);
            this.m_treeViewer.setInput(null);
            this.m_currentNode = null;
        } else if (!firstElement.equals(oldSelection.getFirstElement())) {
            if (this.m_selection.getFirstElement() instanceof INodePO) {
                INodePO guiNode;
                this.m_currentNode = guiNode = (INodePO)this.m_selection.getFirstElement();
                this.m_treeViewer.setInput((Object)guiNode);
                this.workaroundSpringySelection(this.m_focusCellManager);
            } else {
                this.m_treeViewer.setInput(this.m_selection.getFirstElement());
                this.workaroundSpringySelection(this.m_focusCellManager);
            }
        }
        this.setViewEnabled(!(part instanceof TestCaseBrowser) && !(part instanceof TestSuiteBrowser) && !(part instanceof JBPropertiesView) && !(part instanceof TestResultTreeView) && !(part instanceof CompNamesView));
    }

    private void workaroundSpringySelection(TreeViewerFocusCellManager focusCellManager) {
        try {
            if (focusCellManager.getFocusCell() == null) {
                Class<?> focusManagerClass = focusCellManager.getClass();
                Class<?> abstractFocusManagerClass = focusManagerClass.getSuperclass();
                Method getInitialFocusCellMethod = focusManagerClass.getDeclaredMethod("getInitialFocusCell", new Class[0]);
                Method setFocusCellMethod = abstractFocusManagerClass.getDeclaredMethod("setFocusCell", ViewerCell.class);
                getInitialFocusCellMethod.setAccessible(true);
                setFocusCellMethod.setAccessible(true);
                Object initialFocusCellObj = getInitialFocusCellMethod.invoke((Object)focusCellManager, new Object[0]);
                if (initialFocusCellObj instanceof ViewerCell) {
                    ViewerCell initialFocusCell = (ViewerCell)initialFocusCellObj;
                    setFocusCellMethod.invoke((Object)focusCellManager, initialFocusCell);
                }
            }
        }
        catch (Throwable t) {
            LOG.info(Messages.ErrorInWorkaroundForSpringySelection, t);
        }
    }

    void setViewEnabled(boolean enabled) {
        this.m_isEditable = enabled;
        Color bColor = null;
        Color fColor = null;
        if (!enabled) {
            bColor = LayoutUtil.LIGHT_GRAY_COLOR;
            fColor = LayoutUtil.GRAY_COLOR;
        }
        this.getControl().setBackground(bColor);
        this.getControl().setForeground(fColor);
    }

    private boolean checkEditorPart() {
        return Plugin.getActiveEditor() != null && Plugin.getActiveEditor().equals(this.m_correspondingPart);
    }

    private void setMaxChar(Text text, Object propD) {
        if (!this.m_isEditable) {
            return;
        }
        if (propD instanceof TextPropertyDescriptor) {
            LayoutUtil.setMaxChar((Text)text);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListener.add(listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.m_selectionListener.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void handlePartClosed(IWorkbenchPart part) {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        if (activePage == null) {
            return;
        }
        IWorkbenchPart activePart = activePage.getActivePart();
        if (activePart == null) {
            return;
        }
        if (part == this.m_correspondingPart || this.m_correspondingPart == null || part instanceof JBPropertiesView) {
            ISelection sel = activeWorkbenchWindow.getSelectionService().getSelection();
            if (sel == null || !(part instanceof DataEventDispatcher.IDataChangedListener) || part instanceof JBPropertiesView || activePart instanceof JBPropertiesView) {
                this.clearView();
                return;
            }
            if (sel instanceof IStructuredSelection) {
                this.reactOnChange(activePart, (IStructuredSelection)sel);
            }
        }
    }

    public void handleLanguageChanged(Locale locale) {
        this.m_treeViewer.refresh();
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IContextProvider.class)) {
            return this.m_contextProvider;
        }
        if (adapter.equals(IPropertySheetPage.class)) {
            return this;
        }
        if (adapter.equals(IComponentNameMapper.class) && this.m_compMapper != null) {
            return this.m_compMapper;
        }
        return null;
    }

    public void createControl(Composite parent) {
        this.createPartControl(parent);
    }

    public Control getControl() {
        return this.m_treeViewer.getControl();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part instanceof IJBPart && selection instanceof IStructuredSelection) {
            this.reactOnChange(part, (IStructuredSelection)selection);
        }
    }

    public void setCurrentEditor(AbstractJBEditor currentEditor) {
        this.m_currentEditor = currentEditor;
    }

    public AbstractJBEditor getCurrentEditor() {
        return this.m_currentEditor;
    }

    private final class GDHelpListener
    implements HelpListener {
        private GDHelpListener() {
        }

        public void helpRequested(HelpEvent e) {
            IContext context = JBPropertiesView.this.m_contextProvider.getContext(JBPropertiesView.this.m_treeViewer.getControl().getData("org.eclipse.ui.help"));
            Plugin.getHelpSystem().displayHelp(context);
        }
    }

    private final class HelpContextListener
    implements ISelectionChangedListener {
        private Object m_oldSelection = null;

        private HelpContextListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            String helpId = "org.eclipse.jubula.client.ua.help.";
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object selectedObj = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (!(selectedObj instanceof IPropertyDescriptor) || ObjectUtils.equals((Object)this.m_oldSelection, (Object)selectedObj)) {
                return;
            }
            this.m_oldSelection = selectedObj;
            Object descriptorId = ((IPropertyDescriptor)selectedObj).getId();
            if (descriptorId instanceof CapGUIPropertySource.ComponentTypeController || descriptorId instanceof CapGUIPropertySource.ComponentNameController) {
                helpId = String.valueOf(helpId) + this.getCompInfo().getHelpid();
            } else if (descriptorId instanceof CapGUIPropertySource.ActionTypeController) {
                helpId = String.valueOf(helpId) + this.getActionInfo().getHelpid();
            } else if (descriptorId instanceof CapGUIPropertySource.ParameterNameController) {
                helpId = String.valueOf(helpId) + this.getParamInfo(((CapGUIPropertySource.ParameterNameController)descriptorId).getName()).getHelpid();
            } else if (descriptorId instanceof CapGUIPropertySource.ParameterValueController) {
                helpId = String.valueOf(helpId) + this.getParamInfo(((CapGUIPropertySource.ParameterValueController)descriptorId).getParamDesc().getUniqueId()).getHelpid();
            } else if (descriptorId instanceof CapGUIPropertySource.ParameterTypeController) {
                helpId = String.valueOf(helpId) + this.getParamInfo(((CapGUIPropertySource.ParameterTypeController)descriptorId).getName()).getHelpid();
            }
            if ("org.eclipse.jubula.client.ua.help.".equals(helpId)) {
                helpId = "org.eclipse.jubula.client.ua.help.guidancerPropertiesViewContextId";
            }
            Plugin.getHelpSystem().setHelp(JBPropertiesView.this.m_treeViewer.getControl(), helpId);
            if (Plugin.getHelpSystem().isContextHelpDisplayed() || Plugin.getView("org.eclipse.help.ui.HelpView") != null) {
                Plugin.getHelpSystem().displayHelp(helpId);
            }
        }

        private ParamInfo getParamInfo(String paramName) {
            return new ParamInfo(this.getAction().findParam(paramName), this.getActionInfo().getHelpid());
        }

        private ActionInfo getActionInfo() {
            CompSystemProcessor processor = new CompSystemProcessor(ComponentBuilder.getInstance().getCompSystem());
            ComponentInfo definingComp = processor.getDefiningComp(this.getCompInfo(), this.getAction());
            return new ActionInfo(this.getAction(), definingComp);
        }

        private Action getAction() {
            return this.getComp().findAction(((ICapPO)JBPropertiesView.this.m_currentNode).getActionName());
        }

        private ComponentInfo getCompInfo() {
            Component comp = this.getComp();
            ToolkitInfo tkInfo = CompSystemProcessor.getToolkitInfo((ToolkitPluginDescriptor)comp.getToolkitDesriptor());
            return new ComponentInfo(comp, tkInfo);
        }

        private Component getComp() {
            return ComponentBuilder.getInstance().getCompSystem().findComponent(((ICapPO)JBPropertiesView.this.m_currentNode).getComponentType());
        }
    }

    private final class PropertiesContentProvider
    implements ITreeContentProvider {
        private PropertiesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof String) {
                ArrayList<IPropertyDescriptor> children = new ArrayList<IPropertyDescriptor>();
                IPropertyDescriptor[] iPropertyDescriptorArray = JBPropertiesView.this.m_propSource.getPropertyDescriptors();
                int n = iPropertyDescriptorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IPropertyDescriptor propDesc = iPropertyDescriptorArray[n2];
                    if (parentElement.equals(propDesc.getCategory())) {
                        children.add(propDesc);
                    }
                    ++n2;
                }
                return children.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof IPropertyDescriptor) {
                return ((IPropertyDescriptor)element).getCategory();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof String;
        }

        public Object[] getElements(Object inputElement) {
            IPropertyDescriptor[] descriptors = this.getPropertyDescriptors(inputElement);
            LinkedHashSet<String> categories = new LinkedHashSet<String>();
            LinkedHashSet<IPropertyDescriptor> topLevelDescriptors = new LinkedHashSet<IPropertyDescriptor>();
            IPropertyDescriptor[] iPropertyDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertyDescriptor descriptor = iPropertyDescriptorArray[n2];
                String category = descriptor.getCategory();
                if (category == null) {
                    topLevelDescriptors.add(descriptor);
                } else {
                    categories.add(category);
                }
                ++n2;
            }
            ArrayList<Object> children = new ArrayList<Object>();
            children.addAll(topLevelDescriptors);
            children.addAll(categories);
            return children.toArray();
        }

        private IPropertySource getPropertySource(Object element) {
            if (element != null) {
                Object propertySourceObj = null;
                if (element instanceof IAdaptable) {
                    IAdaptable adaptable = (IAdaptable)element;
                    propertySourceObj = adaptable.getAdapter(IPropertySource.class);
                } else {
                    propertySourceObj = Platform.getAdapterManager().getAdapter(element, IPropertySource.class);
                }
                if (propertySourceObj instanceof IPropertySource) {
                    return (IPropertySource)propertySourceObj;
                }
            }
            return null;
        }

        private IPropertyDescriptor[] getPropertyDescriptors(Object element) {
            if (element instanceof INodePO) {
                IPropertySource propertySource;
                INodePO guiNodeInput = (INodePO)element;
                if (this.isValid(guiNodeInput) && (propertySource = this.getPropertySource(element)) != null) {
                    return propertySource.getPropertyDescriptors();
                }
            } else {
                IPropertySource propertySource = this.getPropertySource(element);
                if (propertySource != null) {
                    return propertySource.getPropertyDescriptors();
                }
            }
            return new IPropertyDescriptor[0];
        }

        private boolean isValid(INodePO node) {
            return node != null && node.isValid();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            JBPropertiesView.this.m_propSource = this.getPropertySource(newInput);
        }
    }

    private final class PropertiesEditingSupport
    extends EditingSupport {
        public PropertiesEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            if (JBPropertiesView.this.m_correspondingPart instanceof IEditorPart) {
                if (element instanceof IPropertyDescriptor) {
                    Object propId = ((IPropertyDescriptor)element).getId();
                    if (JBPropertiesView.this.m_propSource instanceof AbstractGuiNodePropertySource && propId instanceof IParameterPropertyController) {
                        return ((AbstractGuiNodePropertySource)JBPropertiesView.this.m_propSource).isParameterEntryEnabled((IParameterPropertyController)propId);
                    }
                }
                return true;
            }
            return false;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null) {
                Control editorControl;
                CellEditor editor = ((IPropertyDescriptor)element).createPropertyEditor((Composite)JBPropertiesView.this.m_treeViewer.getTree());
                if (editor != null && (editorControl = editor.getControl()) instanceof Text) {
                    JBPropertiesView.this.setMaxChar((Text)editorControl, element);
                }
                return editor;
            }
            return null;
        }

        protected Object getValue(Object element) {
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null) {
                return JBPropertiesView.this.m_propSource.getPropertyValue(((IPropertyDescriptor)element).getId());
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null) {
                IPropertyDescriptor propDesc = (IPropertyDescriptor)element;
                Object oldValue = JBPropertiesView.this.m_propSource.getPropertyValue(propDesc.getId());
                if (!(oldValue != null && oldValue.equals(value) || JBPropertiesView.this.m_currentEditor.getEditorHelper().requestEditableState() != JBEditorHelper.EditableState.OK)) {
                    JBPropertiesView.this.m_propSource.setPropertyValue(propDesc.getId(), value);
                    if (JBPropertiesView.this.getCurrentEditor() != null) {
                        JBPropertiesView.this.getCurrentEditor().getEditorHelper().setDirty(true);
                    }
                }
            }
        }
    }

    private final class PropertiesElementComparer
    implements IElementComparer {
        private PropertiesElementComparer() {
        }

        public int hashCode(Object element) {
            if (element instanceof IPropertyDescriptor && !(element instanceof JBPropertyDescriptor)) {
                IPropertyDescriptor pd = (IPropertyDescriptor)element;
                HashCodeBuilder hb = new HashCodeBuilder();
                hb.append((Object)pd.getCategory());
                hb.append((Object)pd.getDisplayName());
                Object id = pd.getId();
                if (id instanceof IPropertyController) {
                    IPropertyController pdpc = (IPropertyController)id;
                    hb.append(pdpc.getProperty());
                }
                return hb.toHashCode();
            }
            return ObjectUtils.hashCode((Object)element);
        }

        public boolean equals(Object a, Object b) {
            if (a instanceof IPropertyDescriptor && b instanceof IPropertyDescriptor && !(a instanceof JBPropertyDescriptor) && !(b instanceof JBPropertyDescriptor)) {
                IPropertyDescriptor pd1 = (IPropertyDescriptor)a;
                IPropertyDescriptor pd2 = (IPropertyDescriptor)b;
                EqualsBuilder eb = new EqualsBuilder();
                eb.append((Object)pd1.getCategory(), (Object)pd2.getCategory());
                eb.append((Object)pd1.getDisplayName(), (Object)pd2.getDisplayName());
                Object id1 = pd1.getId();
                Object id2 = pd2.getId();
                if (id1 instanceof IPropertyController && id2 instanceof IPropertyController) {
                    IPropertyController pd1pc = (IPropertyController)id1;
                    IPropertyController pd2pc = (IPropertyController)id2;
                    eb.append(pd1pc.getProperty(), pd2pc.getProperty());
                }
                return eb.isEquals();
            }
            return ObjectUtils.equals((Object)a, (Object)b);
        }
    }

    private final class PropertyNameLabelProvider
    extends ColumnLabelProvider {
        private PropertyNameLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPropertyDescriptor) {
                return ((IPropertyDescriptor)element).getDisplayName();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null) {
                IPropertyDescriptor propDesc = (IPropertyDescriptor)element;
                ILabelProvider labelProvider = propDesc.getLabelProvider();
                return labelProvider.getImage(propDesc.getId());
            }
            return super.getImage(element);
        }

        public Color getForeground(Object element) {
            return super.getForeground(element);
        }

        public Color getBackground(Object element) {
            ILabelProvider labelProvider;
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null && (labelProvider = ((IPropertyDescriptor)element).getLabelProvider()) instanceof IColorProvider) {
                return ((IColorProvider)labelProvider).getBackground((Object)JBPropertiesView.this.m_propSource);
            }
            return super.getBackground(element);
        }
    }

    private final class PropertyValueLabelProvider
    extends ColumnLabelProvider {
        private PropertyValueLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null) {
                ILabelProvider labelProvider = ((IPropertyDescriptor)element).getLabelProvider();
                return labelProvider.getText(JBPropertiesView.this.m_propSource.getPropertyValue(((IPropertyDescriptor)element).getId()));
            }
            return null;
        }

        public Color getForeground(Object element) {
            ILabelProvider labelProvider;
            AbstractGuiNodePropertySource guiNodePropSource;
            if (JBPropertiesView.this.m_propSource instanceof AbstractGuiNodePropertySource && (guiNodePropSource = (AbstractGuiNodePropertySource)JBPropertiesView.this.m_propSource).isReadOnly()) {
                return LayoutUtil.GRAY_COLOR;
            }
            if (!JBPropertiesView.this.checkEditorPart()) {
                return LayoutUtil.GRAY_COLOR;
            }
            if (element instanceof IPropertyDescriptor && JBPropertiesView.this.m_propSource != null && (labelProvider = ((IPropertyDescriptor)element).getLabelProvider()) instanceof IColorProvider) {
                return ((IColorProvider)labelProvider).getForeground(((IPropertyDescriptor)element).getId());
            }
            return super.getForeground(element);
        }

        public String getToolTipText(Object element) {
            String displayedText = this.getText(element);
            if (displayedText != null && displayedText.length() > 0) {
                return displayedText;
            }
            return null;
        }
    }
}

