/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.views;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DecorationContext;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jubula.client.core.ClientTestFactory;
import org.eclipse.jubula.client.core.businessprocess.ITestExecutionEventListener;
import org.eclipse.jubula.client.core.businessprocess.ITestResultEventListener;
import org.eclipse.jubula.client.core.businessprocess.TestExecutionEvent;
import org.eclipse.jubula.client.core.businessprocess.TestResultBP;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.TestResult;
import org.eclipse.jubula.client.core.model.TestResultNode;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.ui.provider.contentprovider.TestResultTreeViewContentProvider;
import org.eclipse.jubula.client.ui.provider.labelprovider.TestResultTreeViewLabelProvider;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.constants.RCPCommandIDs;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.CommandHelper;
import org.eclipse.jubula.client.ui.views.IJBPart;
import org.eclipse.jubula.client.ui.views.ITreeViewerContainer;
import org.eclipse.jubula.client.ui.views.NonSortedPropertySheetPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class TestResultTreeView
extends ViewPart
implements ITreeViewerContainer,
IJBPart,
DataEventDispatcher.IDataChangedListener,
ITestResultEventListener,
ITestExecutionEventListener,
IAdaptable,
DataEventDispatcher.IProjectLoadedListener {
    private static final int NUM_COLUMNS_1 = 1;
    private static final int VERTICAL_SPACING = 3;
    private static final int MARGIN_WIDTH = 2;
    private static final int MARGIN_HEIGHT = 2;
    private TreeViewer m_treeViewer;
    private Composite m_parentComposite;

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IPropertySheetPage.class)) {
            return new NonSortedPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public void createPartControl(Composite parent) {
        this.m_parentComposite = parent;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        Composite composite = new Composite(parent, 0);
        GridLayout compLayout = new GridLayout(1, false);
        compLayout.marginWidth = 0;
        compLayout.marginHeight = 0;
        composite.setLayout((Layout)compLayout);
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        this.setTreeViewer(new TreeViewer(composite));
        this.getTreeViewer().setContentProvider((IContentProvider)new TestResultTreeViewContentProvider());
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TestResultTreeViewLabelProvider(), Plugin.getDefault().getWorkbench().getDecoratorManager().getLabelDecorator()));
        ClientTestFactory.getClientTest().addTestExecutionEventListener((ITestExecutionEventListener)this);
        this.getTreeViewer().setUseHashlookup(true);
        this.getTreeViewer().setInput((Object)this.getInput());
        this.getTreeViewer().expandToLevel(0);
        this.addTreeListener();
        GridData layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData = new GridData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        Plugin.getHelpSystem().setHelp(this.getTreeViewer().getControl(), "org.eclipse.jubula.client.ua.help.testResultViewContextId");
        this.getTreeViewer().getControl().setLayoutData((Object)layoutData);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getTreeViewer());
        this.createContextMenu();
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        ded.addProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this, true);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TestResultTreeView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)this.getTreeViewer());
    }

    public void dispose() {
        ClientTestFactory.getClientTest().removeTestExecutionEventListener((ITestExecutionEventListener)this);
        DataEventDispatcher.getInstance().removeProjectLoadedListener((DataEventDispatcher.IProjectLoadedListener)this);
        DataEventDispatcher.getInstance().removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        this.getSite().setSelectionProvider(null);
        super.dispose();
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add(CommandHelper.createContributionItem((String)RCPCommandIDs.FIND, null, (String)Messages.FindContextMenu, (int)8));
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.OpenSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ShowSpecification");
        CommandHelper.createContributionPushItem((IMenuManager)mgr, (String)"org.eclipse.jubula.client.ui.commands.ExpandTreeItem");
        mgr.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.getTreeViewer().getControl().setFocus();
        Plugin.showStatusLine((IWorkbenchPart)this);
    }

    public Composite getParentComposite() {
        return this.m_parentComposite;
    }

    public void clear() {
        Plugin.getDisplay().syncExec(new Runnable(){

            public void run() {
                TestResultTreeView.this.getTreeViewer().setInput(null);
                TestResultTreeView.this.getTreeViewer().refresh();
            }
        });
    }

    public void checkContent() {
        if (this.getTreeViewer().getInput() != null && !((TestResultNode)this.getTreeViewer().getInput()).equals(TestResultBP.getInstance().getResultTestModel())) {
            this.getTreeViewer().setInput((Object)this.getInput());
            this.getTreeViewer().refresh();
        }
    }

    public void stateChanged(TestExecutionEvent event) {
        if (event.getState() == 6) {
            this.putDecorationContextProperty("org.eclipse.jubula.client.ui.editors.TestResultViewer.testSuiteEndTime", null);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (!TestResultTreeView.this.getTreeViewer().getControl().isDisposed()) {
                        TestResult input;
                        TestResult oldInput = (TestResult)TestResultTreeView.this.getTreeViewer().getInput();
                        if (oldInput != null) {
                            TestResultTreeView.this.removeListenerFrom(oldInput.getRootResultNode());
                        }
                        TestResultTreeView.this.getTreeViewer().getTree().setRedraw(false);
                        TestResultTreeView.this.getTreeViewer().setInput((Object)TestResultTreeView.this.getInput());
                        TestResult newInput = (TestResult)TestResultTreeView.this.getTreeViewer().getInput();
                        if (newInput == null) {
                            return;
                        }
                        TestResultTreeView.this.addListenerTo(newInput.getRootResultNode());
                        TestResultTreeView.this.getTreeViewer().expandToLevel(1);
                        if (Plugin.getDefault().getPreferenceStore().getBoolean("TRACKRESULTS_PREF_KEY") && (input = (TestResult)TestResultTreeView.this.getTreeViewer().getInput()) != null) {
                            StructuredSelection selection = new StructuredSelection((Object)input.getRootResultNode());
                            TestResultTreeView.this.getTreeViewer().setSelection((ISelection)selection);
                        }
                        TestResultTreeView.this.getTreeViewer().getTree().setRedraw(true);
                    }
                }
            });
        }
    }

    protected TestResult getInput() {
        return TestResultBP.getInstance().getResultTestModel();
    }

    public void testResultChanged(final TestResultNode resultNode) {
        if (!this.getTreeViewer().getControl().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    TestResultTreeView.this.refreshNode(resultNode);
                    if (resultNode != null && (Plugin.getDefault().getPreferenceStore().getBoolean("TRACKRESULTS_PREF_KEY") || Persistor.isPoSubclass((IPersistentObject)resultNode.getNode(), ITestSuitePO.class))) {
                        TestResultTreeView.this.getTreeViewer().reveal((Object)resultNode);
                    }
                }
            });
        }
    }

    protected void refreshNode(TestResultNode findNode) {
        if (Plugin.getDefault().getPreferenceStore().getBoolean("TRACKRESULTS_PREF_KEY")) {
            this.getTreeViewer().expandToLevel((Object)findNode, 1);
        }
        this.getTreeViewer().refresh((Object)findNode);
    }

    public void testResultNodeUpdated(final TestResultNode parent, int index, final TestResultNode newNode) {
        this.addListenerTo(newNode);
        if (!this.getTreeViewer().getControl().isDisposed()) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    if (parent != null) {
                        TestResultTreeView.this.refreshNode(parent);
                    }
                    TestResultTreeView.this.refreshNode(newNode);
                }
            });
        }
    }

    public void endTestExecution() {
        TestResult input = this.getInput();
        if (input != null) {
            this.putDecorationContextProperty("org.eclipse.jubula.client.ui.editors.TestResultViewer.testSuiteEndTime", input.getEndTime());
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!TestResultTreeView.this.getTreeViewer().getControl().isDisposed()) {
                    if (TestResultTreeView.this.getTreeViewer().getInput() != null) {
                        StructuredSelection selection = new StructuredSelection((Object)((TestResult)TestResultTreeView.this.getTreeViewer().getInput()).getRootResultNode());
                        TestResultTreeView.this.getTreeViewer().setSelection(null);
                        TestResultTreeView.this.getTreeViewer().setSelection((ISelection)selection);
                    }
                    TestResultTreeView.this.getTreeViewer().refresh();
                }
            }
        });
    }

    void addListenerTo(TestResultNode resultNode) {
        List resultNodeList = resultNode.getResultNodeList();
        for (TestResultNode resNode : resultNodeList) {
            resNode.addTestResultChangedListener((ITestResultEventListener)this);
            this.addListenerTo(resNode);
        }
    }

    public void removeListenerFrom(TestResultNode resultNode) {
        List resultNodeList = resultNode.getResultNodeList();
        for (TestResultNode resTest : resultNodeList) {
            resTest.removeTestResultChangedListener((ITestResultEventListener)this);
            this.removeListenerFrom(resTest);
        }
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(final IPersistentObject po, final DataEventDispatcher.DataState dataState) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                switch (dataState) {
                    case Added: {
                        if (!(po instanceof IProjectPO)) break;
                        TestResultTreeView.this.clear();
                        break;
                    }
                    case Deleted: {
                        IProjectPO project;
                        if (!(po instanceof IProjectPO) || (project = GeneralStorage.getInstance().getProject()) == null || !project.equals((Object)po)) break;
                        TestResultTreeView.this.clear();
                        break;
                    }
                    case Renamed: {
                        break;
                    }
                    case StructureModified: {
                        break;
                    }
                }
            }
        });
    }

    private void addTreeListener() {
        this.getTreeViewer().addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                TestResultTreeView.this.handleDClick();
            }
        });
    }

    private void handleDClick() {
        CommandHelper.executeCommand((String)"org.eclipse.jubula.client.ui.commands.ShowSpecification", (IWorkbenchPartSite)this.getSite());
    }

    public void handleProjectLoaded() {
        this.clear();
    }

    private void setTreeViewer(TreeViewer treeViewer) {
        this.m_treeViewer = treeViewer;
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    private void putDecorationContextProperty(String property, Object value) {
        IDecorationContext context;
        IBaseLabelProvider labelProvider;
        TreeViewer viewer = this.getTreeViewer();
        if (viewer != null && (labelProvider = viewer.getLabelProvider()) instanceof DecoratingLabelProvider && (context = ((DecoratingLabelProvider)labelProvider).getDecorationContext()) instanceof DecorationContext) {
            ((DecorationContext)context).putProperty(property, value);
        }
    }
}

