/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.refactor.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCasesValidator {
    private Long m_projectId = GeneralStorage.getInstance().getProject().getId();
    private boolean m_isReferencedCtdsOk = false;
    private List<IExecTestCasePO> m_execsWithDifferentCTDS = new ArrayList<IExecTestCasePO>();
    private List<ITestCasePO> m_testCasesWithSpecNotDefinedInCurrentProject = new ArrayList<ITestCasePO>();
    private List<ITestCasePO> m_validTestCases = new ArrayList<ITestCasePO>();

    public TestCasesValidator(Collection<ITestCasePO> testCases) {
        IParameterInterfacePO dataCube = null;
        for (ITestCasePO testCase : testCases) {
            IParameterInterfacePO currentDataCube = testCase.getReferencedDataCube();
            if (dataCube == null && currentDataCube != null ? (dataCube = currentDataCube).getParameterListSize() == 0 : currentDataCube == null || !dataCube.equals(currentDataCube)) {
                return;
            }
            boolean isValid = false;
            if (testCase instanceof IExecTestCasePO) {
                IExecTestCasePO exec = (IExecTestCasePO)testCase;
                isValid = this.checkSpecDefinedInCurrentProject(exec) && this.checkHasOnlyOneCTDS(exec);
            } else {
                ISpecTestCasePO spec = (ISpecTestCasePO)testCase;
                isValid = this.checkSpecDefinedInCurrentProject(spec);
            }
            if (!isValid) continue;
            this.m_validTestCases.add(testCase);
        }
        this.m_isReferencedCtdsOk = true;
    }

    public boolean isReferencedDataCubeOk() {
        return this.m_isReferencedCtdsOk;
    }

    private boolean checkSpecDefinedInCurrentProject(IExecTestCasePO exec) {
        if (this.m_projectId.equals(exec.getSpecTestCase().getParentProjectId())) {
            return true;
        }
        this.m_testCasesWithSpecNotDefinedInCurrentProject.add((ITestCasePO)exec);
        return false;
    }

    private boolean checkSpecDefinedInCurrentProject(ISpecTestCasePO spec) {
        if (this.m_projectId.equals(spec.getParentProjectId())) {
            return true;
        }
        this.m_testCasesWithSpecNotDefinedInCurrentProject.add((ITestCasePO)spec);
        return false;
    }

    public List<ITestCasePO> getTCsWithSpecNotDefinedInCurrentProject() {
        return this.m_testCasesWithSpecNotDefinedInCurrentProject;
    }

    private boolean checkHasOnlyOneCTDS(IExecTestCasePO exec) {
        if (exec.getSpecTestCase().getReferencedDataCube() == null || exec.getReferencedDataCube() == exec.getSpecTestCase().getReferencedDataCube()) {
            return true;
        }
        this.m_execsWithDifferentCTDS.add(exec);
        return false;
    }

    public List<IExecTestCasePO> getExecsWithDifferentCTDS() {
        return this.m_execsWithDifferentCTDS;
    }

    public boolean areAllTestCasesOk() {
        return this.m_testCasesWithSpecNotDefinedInCurrentProject.isEmpty() && this.m_execsWithDifferentCTDS.isEmpty();
    }

    public List<ITestCasePO> getInvalidTestCases() {
        ArrayList<ITestCasePO> testCases = new ArrayList<ITestCasePO>();
        testCases.addAll(this.m_testCasesWithSpecNotDefinedInCurrentProject);
        testCases.addAll(this.m_execsWithDifferentCTDS);
        return testCases;
    }

    public List<ITestCasePO> getValidTestCases() {
        return this.m_validTestCases;
    }
}

