/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.tester.adapter;

import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swing.tester.adapter.JComponentAdapter;
import org.eclipse.jubula.rc.swing.tester.util.TesterUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JTableAdapter
extends JComponentAdapter
implements ITableComponent {
    private static AutServerLogger log;
    private JTable m_table;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.tester.adapter.JTableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public JTableAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_table = (JTable)objectToAdapt;
    }

    public void setComponent(Object element) {
        this.m_table = (JTable)element;
    }

    public int getColumnCount() {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", new IRunnable(){

            public Object run() {
                return new Integer(JTableAdapter.this.m_table.getColumnCount());
            }
        });
        return returnvalue;
    }

    public int getRowCount() {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowCount", new IRunnable(){

            public Object run() {
                return new Integer(JTableAdapter.this.m_table.getRowCount());
            }
        });
        return returnvalue;
    }

    public String getCellText(final int row, final int column) {
        Object o = this.getEventThreadQueuer().invokeAndWait("getCellText", new IRunnable(){

            public Object run() {
                Object value = JTableAdapter.this.m_table.getValueAt(row, column);
                boolean selected = JTableAdapter.this.m_table.isCellSelected(row, column);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + column));
                    log.debug((Object)("Value: " + value));
                }
                TableCellRenderer renderer = JTableAdapter.this.m_table.getCellRenderer(row, column);
                Component c = renderer.getTableCellRendererComponent(JTableAdapter.this.m_table, value, selected, true, row, column);
                return TesterUtil.getRenderedText(c);
            }
        });
        String current = String.valueOf(o);
        return current;
    }

    public String getColumnHeaderText(final int column) {
        String returnvalue = (String)this.getEventThreadQueuer().invokeAndWait("getColumnName", new IRunnable(){

            public Object run() {
                return JTableAdapter.this.m_table.getColumnName(column);
            }
        });
        return returnvalue;
    }

    public int getColumnFromString(final String col, final String operator) {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

            public Object run() {
                int column = -2;
                try {
                    int usrIdxCol = Integer.parseInt(col);
                    if (usrIdxCol == 0) {
                        ++usrIdxCol;
                    }
                    column = IndexConverter.toImplementationIndex((int)usrIdxCol);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        if (JTableAdapter.this.m_table.getTableHeader() == null || !JTableAdapter.this.m_table.getTableHeader().isShowing()) {
                            throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                        }
                        int i = 0;
                        while (i < JTableAdapter.this.m_table.getColumnCount()) {
                            String header = JTableAdapter.this.m_table.getColumnName(i);
                            if (MatchUtil.getInstance().match(header, col, operator)) {
                                column = i;
                            }
                            ++i;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
                return new Integer(column);
            }
        });
        return returnvalue;
    }

    public String getRowText(int row) {
        return null;
    }

    public int getRowFromString(final String row, final String operator) {
        Integer returnvalue = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

            /*
             * Unable to fully structure code
             */
            public Object run() {
                block5: {
                    rowInt = -2;
                    try {
                        rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
                        if (!(rowInt != -1 || JTableAdapter.access$0(JTableAdapter.this).getTableHeader() != null && JTableAdapter.access$0(JTableAdapter.this).getTableHeader().isShowing())) {
                            throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                        }
                        break block5;
                    }
                    catch (NumberFormatException v0) {
                        i = 0;
                        ** while (i < JTableAdapter.access$0((JTableAdapter)JTableAdapter.this).getRowCount())
                    }
lbl-1000:
                    // 1 sources

                    {
                        cellTxt = JTableAdapter.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                        continue;
                    }
                }
                return new Integer(rowInt);
            }
        });
        return returnvalue;
    }

    public Rectangle getBounds() {
        Rectangle returnvalue = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTableAdapter.this.m_table.getBounds();
            }
        });
        return returnvalue;
    }

    public Rectangle getHeaderBounds(final int col) {
        Rectangle returnvalue = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTableAdapter.this.m_table.getTableHeader().getHeaderRect(col);
            }
        });
        return returnvalue;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell returnvalue = (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                int row = JTableAdapter.this.m_table.getSelectedRow();
                int col = JTableAdapter.this.m_table.getSelectedColumn();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Selected row, col: " + row + ", " + col));
                }
                try {
                    JTableAdapter.this.checkRowColBounds(row, col);
                }
                catch (StepExecutionException e) {
                    if (e.getEvent() != null && "TestErrorEvent.InvalidIndex".equals(e.getEvent().getProps().get("guidancerErrorDescription"))) {
                        throw new StepExecutionException("No selection", EventFactory.createActionError((String)"TestErrorEvent.NoSelection"));
                    }
                    throw e;
                }
                return new Cell(row, col);
            }
        });
        return returnvalue;
    }

    public boolean isHeaderVisible() {
        Boolean returnvalue = (Boolean)this.getEventThreadQueuer().invokeAndWait("isHeaderVisible", new IRunnable(){

            public Object run() {
                if (JTableAdapter.this.m_table.getTableHeader() != null) {
                    return JTableAdapter.this.m_table.getTableHeader().isVisible() ? Boolean.TRUE : Boolean.FALSE;
                }
                return Boolean.FALSE;
            }
        });
        return returnvalue;
    }

    public boolean isCellEditable(int row, int col) {
        Boolean editable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isCellEditable", new IRunnable(){

            public Object run() {
                Cell cell = JTableAdapter.this.getSelectedCell();
                return JTableAdapter.this.m_table.isCellEditable(cell.getRow(), cell.getCol()) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return editable;
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    private void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.m_table.getRowCount());
        this.checkBounds(column, this.m_table.getColumnCount());
    }

    public boolean hasCellSelection() {
        try {
            this.getSelectedCell();
        }
        catch (StepExecutionException stepExecutionException) {
            return false;
        }
        return true;
    }

    public Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getCellRect", new IRunnable(){

            public Object run() {
                return JTableAdapter.this.m_table.getCellRect(row, col, true);
            }
        });
        this.getRobot().scrollToVisible((Object)this.m_table, (Object)bounds);
        return bounds;
    }

    public String getText() {
        Cell selectedCell = this.getSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public Object getTableHeader() {
        return this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return JTableAdapter.this.m_table.getTableHeader();
            }
        });
    }
}

