/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import java.awt.Rectangle;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.implclasses.table.Cell;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITableComponent;
import org.eclipse.jubula.rc.common.util.IndexConverter;
import org.eclipse.jubula.rc.common.util.MatchUtil;
import org.eclipse.jubula.rc.swt.listener.TableSelectionTracker;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.TableTester;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.rc.swt.utils.SwtUtils;
import org.eclipse.jubula.tools.objects.event.EventFactory;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class TableAdapter
extends ControlAdapter
implements ITableComponent {
    private static AutServerLogger log;
    private Table m_table;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.TableAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public TableAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_table = (Table)objectToAdapt;
    }

    public int getColumnCount() {
        Integer colCount = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnCount", new IRunnable(){

            public Object run() {
                return new Integer(TableAdapter.this.m_table.getColumnCount());
            }
        });
        return colCount;
    }

    public int getRowCount() {
        Integer itemCount = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowCount", new IRunnable(){

            public Object run() {
                return new Integer(TableAdapter.this.m_table.getItemCount());
            }
        });
        return itemCount;
    }

    public String getCellText(final int row, final int column) {
        String cellText = (String)this.getEventThreadQueuer().invokeAndWait("getCellText", new IRunnable(){

            public Object run() {
                TableItem item = TableAdapter.this.m_table.getItem(row);
                String value = CAPUtil.getWidgetText((Widget)item, "TEST_TESTABLE_TEXT_" + column, item.getText(column));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Getting cell text:");
                    log.debug((Object)("Row, col: " + row + ", " + column));
                    log.debug((Object)("Value: " + value));
                }
                return value;
            }
        });
        return cellText;
    }

    public String getColumnHeaderText(final int colIdx) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getColumnName", new IRunnable(){

            public Object run() {
                TableColumn column = TableAdapter.this.m_table.getColumn(colIdx);
                return CAPUtil.getWidgetText((Widget)column, column.getText());
            }
        });
        return current;
    }

    public int getColumnFromString(final String col, final String operator) {
        int column = -2;
        try {
            int usrIdxCol = Integer.parseInt(col);
            if (usrIdxCol == 0) {
                ++usrIdxCol;
            }
            column = IndexConverter.toImplementationIndex((int)usrIdxCol);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() {
                        return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
                    }
                });
                if (!isVisible.booleanValue()) {
                    throw new StepExecutionException("No Header", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
                }
                Integer implCol = (Integer)this.getEventThreadQueuer().invokeAndWait("getColumnFromString", new IRunnable(){

                    public Object run() throws StepExecutionException {
                        int i = 0;
                        while (i < TableAdapter.this.m_table.getColumnCount()) {
                            String colHeader = TableAdapter.this.getColumnHeaderText(i);
                            if (MatchUtil.getInstance().match(colHeader, col, operator)) {
                                return new Integer(i);
                            }
                            ++i;
                        }
                        return new Integer(-2);
                    }
                });
                column = implCol;
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return column;
    }

    public String getRowText(final int rowIdx) {
        String current = (String)this.getEventThreadQueuer().invokeAndWait("getRowText", new IRunnable(){

            public Object run() {
                TableItem row = TableAdapter.this.m_table.getItem(rowIdx);
                return CAPUtil.getWidgetText((Widget)row, row.getText());
            }
        });
        return current;
    }

    public int getRowFromString(final String row, final String operator) {
        int rowInt = -2;
        try {
            Boolean isVisible;
            rowInt = IndexConverter.toImplementationIndex((int)Integer.parseInt(row));
            if (rowInt == -1 && !(isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() {
                    return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
                }
            })).booleanValue()) {
                throw new StepExecutionException("Header not visible", EventFactory.createActionError((String)"TestErrorEvent.NoHeader"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            Integer implRow = (Integer)this.getEventThreadQueuer().invokeAndWait("getRowFromString", new IRunnable(){

                public Object run() throws StepExecutionException {
                    int i = 0;
                    while (i < TableAdapter.this.m_table.getItemCount()) {
                        String cellTxt = TableAdapter.this.getCellText(i, 0);
                        if (MatchUtil.getInstance().match(cellTxt, row, operator)) {
                            return new Integer(i);
                        }
                        ++i;
                    }
                    return new Integer(-2);
                }
            });
            rowInt = implRow;
        }
        return rowInt;
    }

    public Rectangle getBounds() {
        Rectangle bounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableAdapter.this.m_table.getBounds();
            }
        });
        return bounds;
    }

    public Rectangle getHeaderBounds(final int col) {
        Rectangle headerBounds = (Rectangle)this.getEventThreadQueuer().invokeAndWait("getHeaderBounds", new IRunnable(){

            public Object run() throws StepExecutionException {
                org.eclipse.swt.graphics.Rectangle rect = TableAdapter.this.m_table.getItem(0).getBounds(col);
                rect.y = ((TableAdapter)TableAdapter.this).m_table.getClientArea().y;
                return new Rectangle(rect.x, rect.y, rect.width, rect.height);
            }
        });
        return headerBounds;
    }

    public Cell getSelectedCell() throws StepExecutionException {
        Cell cell = (Cell)this.getEventThreadQueuer().invokeAndWait("getSelectedSell", new IRunnable(){

            public Object run() throws StepExecutionException {
                return TableSelectionTracker.getInstance().getSelectedCell(TableAdapter.this.m_table);
            }
        });
        return cell;
    }

    public boolean isHeaderVisible() {
        Boolean isVisible = (Boolean)this.getEventThreadQueuer().invokeAndWait("isHeaderVisible", new IRunnable(){

            public Object run() {
                return new Boolean(TableAdapter.this.m_table.getHeaderVisible());
            }
        });
        return isVisible;
    }

    public boolean isCellEditable(int row, int col) {
        final Control cellEditor = (Control)this.activateEditor(new Cell(row, col));
        boolean isEditable = (Boolean)this.getEventThreadQueuer().invokeAndWait("isCellEditable", new IRunnable(){

            public Object run() {
                return TableAdapter.this.isEditable(cellEditor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEditable;
    }

    public boolean hasCellSelection() {
        TableItem[] selItems = (TableItem[])this.getEventThreadQueuer().invokeAndWait("hasCellSelection", new IRunnable(){

            public Object run() {
                return TableAdapter.this.m_table.getSelection();
            }
        });
        return selItems.length > 0;
    }

    public Rectangle scrollCellToVisible(final int row, final int col) throws StepExecutionException {
        final Table table = this.m_table;
        this.getEventThreadQueuer().invokeAndWait("scrollCellToVisible", new IRunnable(){

            public Object run() {
                if (table.getColumnCount() > 0 || col > 0) {
                    table.showColumn(table.getColumn(col));
                }
                table.showItem(table.getItem(row));
                return null;
            }
        });
        this.checkRowColBounds(row, col);
        final Rectangle cellBoundsRelativeToParent = TableTester.getCellBounds(this.getEventThreadQueuer(), this.m_table, row, col);
        this.getEventThreadQueuer().invokeAndWait("getCellBoundsRelativeToParent", new IRunnable(){

            public Object run() {
                Point cellOriginRelativeToParent = table.getDisplay().map((Control)table, (Control)table.getParent(), new Point(cellBoundsRelativeToParent.x, cellBoundsRelativeToParent.y));
                cellBoundsRelativeToParent.x = cellOriginRelativeToParent.x;
                cellBoundsRelativeToParent.y = cellOriginRelativeToParent.y;
                return null;
            }
        });
        Control parent = (Control)this.getEventThreadQueuer().invokeAndWait("getParent", new IRunnable(){

            public Object run() {
                table.getParent();
                return null;
            }
        });
        this.getRobot().scrollToVisible((Object)parent, (Object)cellBoundsRelativeToParent);
        return this.getVisibleBounds(TableTester.getCellBounds(this.getEventThreadQueuer(), this.m_table, row, col));
    }

    private void checkBounds(int value, int count) {
        if (value < 0 || value >= count) {
            throw new StepExecutionException("Invalid row/column: " + value, EventFactory.createActionError((String)"TestErrorEvent.InvalidIndexOrHeader"));
        }
    }

    protected void checkRowColBounds(int row, int column) throws StepExecutionException {
        this.checkBounds(row, this.getRowCount());
        int colCount = this.getColumnCount();
        if (colCount > 0 || column > 0) {
            this.checkBounds(column, colCount);
        }
    }

    private Rectangle getVisibleBounds(Rectangle cellBounds) {
        org.eclipse.swt.graphics.Rectangle r = (org.eclipse.swt.graphics.Rectangle)this.getEventThreadQueuer().invokeAndWait("getVisibleCellBounds: " + cellBounds, new IRunnable(){

            public Object run() {
                return TableAdapter.this.m_table.getClientArea();
            }
        });
        Rectangle visibleTableBounds = new Rectangle(r.x, r.y, r.width, r.height);
        Rectangle visibleCellBounds = visibleTableBounds.intersection(cellBounds);
        return visibleCellBounds;
    }

    private boolean isEditable(Control cellEditor) {
        if (cellEditor == null || cellEditor instanceof TableCursor || cellEditor == this.m_table) {
            return false;
        }
        return (cellEditor.getStyle() & 8) == 0;
    }

    private boolean invokeIsEditable(final Control cellEditor) {
        boolean isEditable = (Boolean)this.getEventThreadQueuer().invokeAndWait("getSelectedCell", new IRunnable(){

            public Object run() {
                return TableAdapter.this.isEditable(cellEditor) ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return isEditable;
    }

    public Object activateEditor(Cell cell) {
        Rectangle rect = this.scrollCellToVisible(cell.getRow(), cell.getCol());
        Control editor = this.getTableCellEditor(cell, rect);
        if (!this.invokeIsEditable(editor)) {
            org.eclipse.swt.graphics.Rectangle cellBounds = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
            ClickOptions co = ClickOptions.create().setClickCount(2);
            Table clickTarget = editor == null || editor instanceof TableCursor ? this.m_table : editor;
            this.getRobot().click((Object)clickTarget, (Object)cellBounds, co);
            editor = this.getTableCellEditor(cell, rect);
        }
        return editor;
    }

    private Control getTableCellEditor(Cell cell, Rectangle rect) {
        org.eclipse.swt.graphics.Rectangle swtRect = new org.eclipse.swt.graphics.Rectangle(rect.x, rect.y, rect.width, rect.height);
        this.getRobot().click((Object)this.m_table, (Object)swtRect, ClickOptions.create().setClickCount(1));
        return SwtUtils.getCursorControl();
    }

    public String getText() {
        Cell selectedCell = this.getSelectedCell();
        return this.getCellText(selectedCell.getRow(), selectedCell.getCol());
    }

    public Object getTableHeader() {
        return this.m_table;
    }
}

