/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swt.tester.adapter;

import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.tester.adapter.interfaces.ITextInputComponent;
import org.eclipse.jubula.rc.swt.tester.CAPUtil;
import org.eclipse.jubula.rc.swt.tester.adapter.ControlAdapter;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class TextComponentAdapter
extends ControlAdapter
implements ITextInputComponent {
    private static AutServerLogger log;
    private Text m_textComponent;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swt.tester.adapter.TextComponentAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public TextComponentAdapter(Object objectToAdapt) {
        super(objectToAdapt);
        this.m_textComponent = (Text)objectToAdapt;
    }

    public String getText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getText", new IRunnable(){

            public Object run() {
                return CAPUtil.getWidgetText((Widget)TextComponentAdapter.this.m_textComponent, TextComponentAdapter.this.m_textComponent.getText());
            }
        });
        return actual;
    }

    public void setSelection(final int start) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                TextComponentAdapter.this.m_textComponent.setSelection(start);
                return null;
            }
        });
    }

    public void setSelection(final int start, final int end) {
        this.getEventThreadQueuer().invokeAndWait("setSelection", new IRunnable(){

            public Object run() {
                TextComponentAdapter.this.m_textComponent.setSelection(start, end);
                return null;
            }
        });
    }

    public String getSelectionText() {
        String actual = (String)this.getEventThreadQueuer().invokeAndWait("getSelectionText", new IRunnable(){

            public Object run() {
                return TextComponentAdapter.this.m_textComponent.getSelectionText();
            }
        });
        return actual;
    }

    public void selectAll() {
        String selectionText;
        String totalText = this.getText();
        if (!EnvironmentUtils.isMacOS()) {
            try {
                this.getRobot().keyStroke(String.valueOf(this.getRobot().getSystemModifierSpec()) + " A");
            }
            catch (StepExecutionException see) {
                log.warn((Object)see);
            }
        }
        if (!totalText.equals(this.getSelectionText())) {
            this.getEventThreadQueuer().invokeAndWait("text.selectAll", new IRunnable(){

                public Object run() {
                    TextComponentAdapter.this.m_textComponent.selectAll();
                    return null;
                }
            });
        }
        if (!totalText.equals(selectionText = this.getSelectionText())) {
            log.warn((Object)("SelectAll failed!\nTotal text: '" + totalText + "'\n" + "Selected text: '" + selectionText + "'"));
        }
    }

    public boolean isEditable() {
        return (Boolean)this.getEventThreadQueuer().invokeAndWait("isEditable", new IRunnable(){

            public Object run() {
                return TextComponentAdapter.this.m_textComponent.getEditable() && TextComponentAdapter.this.m_textComponent.getEnabled() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }
}

