/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils.generator;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.tools.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.utils.generator.Info;
import org.eclipse.jubula.tools.xml.businessmodell.Param;

public class ParamInfo
extends Info
implements Comparable {
    private Param m_param;
    private String m_helpid;
    private String m_i18nType;
    private String m_shortName;

    public ParamInfo(Param param, String actionHelpid) {
        super(CompSystemI18n.getString(param.getName()));
        this.m_param = param;
        this.m_i18nType = CompSystemI18n.getString(param.getType());
        String[] tokens = StringUtils.split((String)this.m_param.getName(), (char)'.');
        this.m_shortName = tokens[tokens.length - 1];
        this.m_helpid = String.valueOf(actionHelpid) + "_" + this.m_shortName;
    }

    public Param getParam() {
        return this.m_param;
    }

    public String getHelpid() {
        return this.m_helpid;
    }

    public int compareTo(Object o) {
        ParamInfo rhs = (ParamInfo)o;
        return this.getI18nName().compareTo(rhs.getI18nName());
    }

    public String getI18nType() {
        return this.m_i18nType;
    }

    public String getShortName() {
        return this.m_shortName;
    }
}

