/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.sourcelookup.ISourceContainerType;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainer;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.koneki.ldt.core.LuaUtils;

public class LuaModuleURIBuildpathSourceContainer
extends AbstractSourceContainer {
    public Object[] findSourceElements(String name) throws CoreException {
        if (name == null || !name.startsWith("module:///")) {
            return new Object[0];
        }
        String moduleName = name.substring(10);
        ILaunchConfiguration configuration = this.getDirector().getLaunchConfiguration();
        String projectName = configuration.getAttribute("project", null);
        if (projectName == null) {
            return new Object[0];
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IScriptProject prj = DLTKCore.create((IProject)project);
        IModuleSource moduleSource = LuaUtils.getModuleSource((String)moduleName, (IScriptProject)prj);
        if (moduleSource != null) {
            IModelElement modelElement = moduleSource.getModelElement();
            if (modelElement instanceof IStorage) {
                return new Object[]{modelElement};
            }
            if (modelElement != null && modelElement.getResource() instanceof IStorage) {
                return new Object[]{modelElement.getResource()};
            }
        }
        return new Object[0];
    }

    public String getName() {
        return "Lua Module URI in Buildpath Source Container";
    }

    public ISourceContainerType getType() {
        return null;
    }
}

