/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.debug.core.internal.interpreter.jnlua;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.launching.ExecutionArguments;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public abstract class JNLuaInterpreterCommandLineRenderer {
    public static final String JNLUA_BUNDLE_ID = "com.naef.jnlua";

    public String[] renderCommandLine(InterpreterConfig config, IInterpreterInstall install) {
        ExecutionArguments ex;
        String[] interpreterOwnArgs;
        ArrayList<String> items = new ArrayList<String>();
        items.add(this.getJavaBinPath());
        List<String> classPath = this.getClassPath();
        if (!classPath.isEmpty()) {
            items.add("-cp");
            StringBuilder libpath = new StringBuilder();
            for (String libraryPathElement : classPath) {
                libpath.append(libraryPathElement);
                libpath.append(File.pathSeparatorChar);
            }
            libpath.deleteCharAt(libpath.length() - 1);
            items.add(libpath.toString());
        }
        List<String> libraryPath = this.getLibraryPath();
        if (!classPath.isEmpty()) {
            StringBuilder libpath = new StringBuilder();
            libpath.append("-Djava.library.path=");
            for (String libraryPathElement : libraryPath) {
                libpath.append(libraryPathElement);
                libpath.append(File.pathSeparatorChar);
            }
            libpath.deleteCharAt(libpath.length() - 1);
            items.add(libpath.toString());
        }
        items.add(this.getClassToRun());
        String args = install.getInterpreterArgs();
        if (args != null && !args.isEmpty() && (interpreterOwnArgs = (ex = new ExecutionArguments(args, "")).getInterpreterArgumentsArray()) != null) {
            items.addAll(Arrays.asList(interpreterOwnArgs));
        }
        items.addAll(config.getInterpreterArgs());
        items.add(config.getScriptFilePath().toOSString());
        items.addAll(config.getScriptArgs());
        return items.toArray(new String[items.size()]);
    }

    protected abstract String getClassToRun();

    protected List<String> getLibraryPath() {
        Bundle[] fragments;
        ArrayList<String> libraryPaths = new ArrayList<String>();
        Bundle jNLuaBundle = this.getJNLuaBundle();
        Bundle[] bundleArray = fragments = Platform.getFragments((Bundle)jNLuaBundle);
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle fragment = bundleArray[n2];
            String nativeCode = (String)fragment.getHeaders().get("Bundle-NativeCode");
            if (nativeCode != null) {
                String[] split;
                String[] stringArray = split = nativeCode.split("\\s*;\\s*");
                int n3 = split.length;
                int n4 = 0;
                while (n4 < n3) {
                    String library = stringArray[n4];
                    try {
                        URL entry = fragment.getEntry(library);
                        URL libraryURL = FileLocator.toFileURL((URL)entry);
                        String libraryPath = new Path(libraryURL.getFile()).removeLastSegments(1).toOSString();
                        libraryPaths.add(libraryPath);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Unable to set java.library.path.", e);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return libraryPaths;
    }

    private Bundle getJNLuaBundle() {
        Bundle[] bundles = Platform.getBundles((String)JNLUA_BUNDLE_ID, (String)this.getJNLuaBundleVersion());
        if (bundles == null || bundles.length == 0) {
            throw new RuntimeException(MessageFormat.format("Unable to resolve {0} bundle in version {1}.", JNLUA_BUNDLE_ID, this.getJNLuaBundleVersion()));
        }
        Version expectedVersion = new Version(this.getJNLuaBundleVersion());
        Bundle[] bundleArray = bundles;
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle aBundle = bundleArray[n2];
            Version bundleVersion = aBundle.getVersion();
            if (bundleVersion.getMajor() == expectedVersion.getMajor() && bundleVersion.getMinor() == expectedVersion.getMinor() && bundleVersion.getMicro() == expectedVersion.getMicro()) {
                return aBundle;
            }
            ++n2;
        }
        throw new RuntimeException(MessageFormat.format("Unable to resolve {0} bundle for the version {1}.", JNLUA_BUNDLE_ID, this.getJNLuaBundleVersion()));
    }

    protected abstract String getJNLuaBundleVersion();

    protected String getJavaBinPath() {
        String javaHome = System.getProperty("java.home");
        String javaBin = String.valueOf(javaHome) + File.separator + "bin" + File.separator + "java";
        return javaBin;
    }

    protected List<String> getClassPath() {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getJNLuaClassPath());
        classpath.add(this.getLauncherClassPath());
        return classpath;
    }

    protected String getLauncherClassPath() {
        URL resolvedEntry;
        Bundle launcherBundle = this.getLauncherClassBundle();
        URL entry = launcherBundle.getResource("/");
        try {
            resolvedEntry = FileLocator.toFileURL((URL)entry);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to resolve Launcher classpath.", e);
        }
        return resolvedEntry.getFile();
    }

    protected abstract Bundle getLauncherClassBundle();

    protected String getJNLuaClassPath() {
        URL resolvedEntry;
        Bundle jNLuaBundle = this.getJNLuaBundle();
        URL entry = jNLuaBundle.getResource("/");
        try {
            resolvedEntry = FileLocator.toFileURL((URL)entry);
        }
        catch (IOException e) {
            throw new RuntimeException(MessageFormat.format("Unable to resolve class path for {0} bundle.", JNLUA_BUNDLE_ID), e);
        }
        return resolvedEntry.getFile();
    }
}

