/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.koneki.ldt.ui.internal.search;

import java.util.ArrayList;
import org.eclipse.dltk.ast.parser.IModuleDeclaration;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.search.IOccurrencesFinder;
import org.eclipse.dltk.ui.search.ModelElementOccurrencesFinder;
import org.eclipse.koneki.ldt.core.internal.ast.models.LuaASTUtils;
import org.eclipse.koneki.ldt.core.internal.ast.models.api.Item;
import org.eclipse.koneki.ldt.core.internal.ast.models.common.LuaSourceRoot;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.Identifier;
import org.eclipse.koneki.ldt.core.internal.ast.models.file.LuaExpression;

public class LuaModelElementOccurrencesFinder
extends ModelElementOccurrencesFinder {
    private Item definition;

    public String initialize(ISourceModule module, IModuleDeclaration root, int offset, int length) {
        this.definition = null;
        if (root instanceof LuaSourceRoot && ((LuaSourceRoot)root).hasError()) {
            return null;
        }
        LuaExpression luaExpression = LuaASTUtils.getLuaExpressionAt((LuaSourceRoot)((LuaSourceRoot)root), (int)offset, (int)(offset + length));
        if (luaExpression instanceof Identifier) {
            this.definition = ((Identifier)luaExpression).getDefinition();
        }
        return null;
    }

    public IOccurrencesFinder.OccurrenceLocation[] getOccurrences() {
        if (this.definition == null) {
            return new IOccurrencesFinder.OccurrenceLocation[0];
        }
        ArrayList<IOccurrencesFinder.OccurrenceLocation> list = new ArrayList<IOccurrencesFinder.OccurrenceLocation>();
        for (Identifier identifier : this.definition.getOccurrences()) {
            list.add(new IOccurrencesFinder.OccurrenceLocation(identifier.sourceStart(), identifier.matchLength(), this.definition.getName()));
        }
        return list.toArray(new IOccurrencesFinder.OccurrenceLocation[list.size()]);
    }
}

