/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.WARProductUtil;
import org.eclipse.libra.warproducts.core.validation.Validation;
import org.eclipse.libra.warproducts.core.validation.ValidationError;
import org.eclipse.libra.warproducts.core.validation.Validator;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.JARFileFilter;
import org.eclipse.pde.internal.ui.elements.DefaultTableProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LibrarySection
extends TableSection
implements IPluginModelListener {
    private static final int BUTTON_ADD_REQUIRED = 2;
    private static final int BUTTON_REMOVE = 1;
    private static final int BUTTON_ADD = 0;
    private TableViewer libraryTable;

    public LibrarySection(PDEFormPage formPage, Composite parent) {
        super(formPage, parent, 128, LibrarySection.getButtonLabels());
    }

    private static String[] getButtonLabels() {
        String[] labels = new String[]{Messages.Product_PluginSection_add, Messages.PluginSection_remove, Messages.LibrarySectionAddRequired};
        return labels;
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout((boolean)false, (int)1));
        GridData sectionData = new GridData(1808);
        sectionData.verticalSpan = 2;
        section.setLayoutData((Object)sectionData);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.createViewerPartControl(container, 2, 2, toolkit);
        container.setLayoutData((Object)new GridData(1808));
        EditableTablePart tablePart = this.getTablePart();
        this.libraryTable = tablePart.getTableViewer();
        this.libraryTable.setContentProvider((IContentProvider)new LibraryContentProvider());
        this.libraryTable.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.addComparator();
        GridData data = (GridData)tablePart.getControl().getLayoutData();
        data.minimumWidth = 200;
        this.libraryTable.setInput((Object)this.getProduct());
        tablePart.setButtonEnabled(0, this.isEditable());
        tablePart.setButtonEnabled(1, this.isEditable());
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        section.setText(Messages.LibrarySectionLibraries);
        section.setDescription(Messages.LibrarySectionListLibraries);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    private void addComparator() {
        this.libraryTable.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                IPath p1 = (IPath)e1;
                IPath p2 = (IPath)e2;
                return super.compare(viewer, (Object)p1.toOSString(), (Object)p2.toOSString());
            }
        });
    }

    private IWARProduct getProduct() {
        return (IWARProduct)this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void modelsChanged(PluginModelDelta delta) {
        final Control control = this.libraryTable.getControl();
        if (!control.isDisposed()) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (!control.isDisposed()) {
                        LibrarySection.this.libraryTable.refresh();
                        LibrarySection.this.updateRemoveButtons();
                    }
                }
            });
        }
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        } else {
            Object[] objects = e.getChangedObjects();
            if (e.getChangeType() == 1) {
                this.handleInsert(objects);
            } else if (e.getChangeType() == 2) {
                this.handleRemove(objects);
            } else if (e.getChangeType() == 3) {
                this.libraryTable.refresh();
            }
            this.updateRemoveButtons();
        }
    }

    private void handleInsert(Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IPath) {
                this.libraryTable.add(objects[i]);
            }
            ++i;
        }
    }

    private void handleRemove(Object[] objects) {
        Table table = this.libraryTable.getTable();
        int index = table.getSelectionIndex();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof IPath) {
                this.libraryTable.remove(objects[i]);
            }
            ++i;
        }
        int count = table.getItemCount();
        if (count != 0) {
            if (index < count) {
                table.setSelection(index);
            } else {
                table.setSelection(count - 1);
            }
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        if (!this.libraryTable.getTable().isDisposed()) {
            this.libraryTable.setInput((Object)this.getProduct());
            this.refresh();
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.updateRemoveButtons();
    }

    private void updateRemoveButtons() {
        EditableTablePart tablePart = this.getTablePart();
        ISelection selection = this.getViewerSelection();
        boolean enabled = this.isEditable() && !selection.isEmpty() && selection instanceof IStructuredSelection;
        tablePart.setButtonEnabled(1, enabled);
    }

    public void refresh() {
        this.libraryTable.refresh();
        this.updateRemoveButtons();
        super.refresh();
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleAddLibrary();
        } else if (index == 1) {
            this.handleRemoveLibrary();
        } else if (index == 2) {
            this.handleAddRequiredLibraries();
        }
    }

    private void handleRemoveLibrary() {
        IStructuredSelection selection = (IStructuredSelection)this.libraryTable.getSelection();
        if (selection.size() > 0) {
            Object[] objects = selection.toArray();
            IPath[] pathes = new IPath[objects.length];
            System.arraycopy(objects, 0, pathes, 0, objects.length);
            this.getProduct().removeLibraries(pathes);
        }
    }

    private void handleAddLibrary() {
        Shell shell = this.getPage().getSite().getShell();
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();
        WorkbenchContentProvider contentProvider = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        dialog.setTitle(Messages.BuildEditor_ClasspathSection_jarsTitle);
        dialog.setMessage(Messages.LibrarySectionSelectJar);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        dialog.addFilter((ViewerFilter)new JARFileFilter());
        dialog.setInput((Object)workspace);
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.create();
        IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)dialog.getShell(), "org.eclipse.pde.doc.user.add_library");
        ArrayList newLibs = new ArrayList();
        if (dialog.open() == 0) {
            this.updateProduct(dialog, newLibs);
        }
        this.libraryTable.setSelection((ISelection)new StructuredSelection(newLibs.toArray()));
        this.libraryTable.getTable().setFocus();
    }

    private void updateProduct(ElementTreeSelectionDialog dialog, List newLibs) {
        Object[] elements = dialog.getResult();
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                IPath fullPath = file.getFullPath();
                newLibs.add(fullPath);
                this.getProduct().addLibrary(fullPath, false);
            }
            ++i;
        }
    }

    private void handleAddRequiredLibraries() {
        IWARProduct product = this.getProduct();
        Validator validator = new Validator(product);
        Validation validation = validator.validate();
        if (!validation.isValid()) {
            this.tryToAddServletBridge(product, validation);
        }
    }

    private void tryToAddServletBridge(IWARProduct product, Validation validation) {
        ValidationError[] errors = validation.getErrors();
        int i = 0;
        while (i < errors.length) {
            ValidationError error = errors[i];
            if (error.getType() == 0) {
                boolean containsError;
                String message = error.getMessage();
                boolean bl = containsError = message.indexOf(Messages.LibrarySectionServletBridge) != -1;
                if (containsError) {
                    WARProductUtil.addServletBridgeFromTarget((IWARProduct)product);
                }
            }
            ++i;
        }
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public boolean selectReveal(Object object) {
        boolean result = false;
        IPath[] libraries = this.getProduct().getLibraries();
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i] == object) {
                result = true;
            }
            ++i;
        }
        if (result) {
            this.libraryTable.setSelection((ISelection)new StructuredSelection(object), true);
        }
        return result;
    }

    class LibraryContentProvider
    extends DefaultTableProvider {
        LibraryContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return LibrarySection.this.getProduct().getLibraries();
        }
    }

    class LibraryLabelProvider
    extends LabelProvider {
        LibraryLabelProvider() {
        }

        public String getText(Object element) {
            String result = "";
            if (element instanceof IPath) {
                IPath path = (IPath)element;
                result = path.segment(path.segmentCount() - 1);
            } else {
                result = super.getText(element);
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element instanceof IPath) {
                PDEPlugin pdePlugin = PDEPlugin.getDefault();
                PDELabelProvider pdeLabelProvider = pdePlugin.getLabelProvider();
                result = pdeLabelProvider.get(PDEPluginImages.DESC_JAR_LIB_OBJ);
            } else {
                result = super.getImage(element);
            }
            return result;
        }
    }
}

