/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.embedder;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.m2e.core.embedder.MavenRuntime;
import org.eclipse.m2e.core.internal.embedder.MavenEmbeddedRuntime;
import org.eclipse.m2e.core.internal.embedder.MavenExternalRuntime;
import org.osgi.service.prefs.Preferences;

public class MavenRuntimeManager {
    public static final String DEFAULT = "DEFAULT";
    public static final String EMBEDDED = "EMBEDDED";
    public static final String WORKSPACE = "WORKSPACE";
    private final IEclipsePreferences[] preferencesLookup = new IEclipsePreferences[2];
    private final IPreferencesService preferenceStore;
    private Map<String, MavenRuntime> runtimes = new LinkedHashMap<String, MavenRuntime>();
    private MavenRuntime embeddedRuntime;
    private MavenRuntime defaultRuntime;

    public MavenRuntimeManager() {
        this.preferenceStore = Platform.getPreferencesService();
        this.preferencesLookup[0] = new InstanceScope().getNode("org.eclipse.m2e.core");
        this.preferencesLookup[1] = new DefaultScope().getNode("org.eclipse.m2e.core");
        this.initRuntimes();
    }

    public void setEmbeddedRuntime(MavenRuntime embeddedRuntime) {
        this.embeddedRuntime = embeddedRuntime;
        this.runtimes.put(embeddedRuntime.getLocation(), embeddedRuntime);
    }

    public void addWorkspaceRuntime(MavenRuntime workspaceRuntime) {
        this.runtimes.put(workspaceRuntime.getLocation(), workspaceRuntime);
    }

    @Deprecated
    public void setWorkspaceRuntime(MavenRuntime workspaceRuntime) {
        this.addWorkspaceRuntime(workspaceRuntime);
    }

    public MavenRuntime getDefaultRuntime() {
        if (this.defaultRuntime == null || !this.defaultRuntime.isAvailable()) {
            return this.embeddedRuntime;
        }
        return this.defaultRuntime;
    }

    public MavenRuntime getRuntime(String location) {
        if (location == null || location.length() == 0 || DEFAULT.equals(location)) {
            return this.getDefaultRuntime();
        }
        return this.runtimes.get(location);
    }

    public List<MavenRuntime> getMavenRuntimes() {
        ArrayList<MavenRuntime> mavenRuntimes = new ArrayList<MavenRuntime>();
        for (MavenRuntime mavenRuntime : this.runtimes.values()) {
            if (!mavenRuntime.isAvailable()) continue;
            mavenRuntimes.add(mavenRuntime);
        }
        return mavenRuntimes;
    }

    public void reset() {
        this.preferencesLookup[0].remove("eclipse.m2.runtimes");
        this.preferencesLookup[0].remove("eclipse.m2.defaultRuntime");
        this.initRuntimes();
    }

    public void setDefaultRuntime(MavenRuntime runtime) {
        this.defaultRuntime = runtime;
        if (runtime == null) {
            this.preferencesLookup[0].remove("eclipse.m2.defaultRuntime");
        } else {
            this.preferencesLookup[0].put("eclipse.m2.defaultRuntime", runtime.getLocation());
        }
    }

    public void setRuntimes(List<MavenRuntime> runtimes) {
        this.runtimes.clear();
        String separator = "";
        StringBuffer sb = new StringBuffer();
        for (MavenRuntime runtime : runtimes) {
            if (!runtime.isEditable()) continue;
            this.runtimes.put(runtime.getLocation(), runtime);
            sb.append(separator).append(runtime.getLocation());
            separator = "|";
        }
        this.preferencesLookup[0].put("eclipse.m2.runtimes", sb.toString());
    }

    private void initRuntimes() {
        this.defaultRuntime = null;
        String selected = this.preferenceStore.get("eclipse.m2.defaultRuntime", null, (Preferences[])this.preferencesLookup);
        String runtimesPreference = this.preferenceStore.get("eclipse.m2.runtimes", null, (Preferences[])this.preferencesLookup);
        if (runtimesPreference != null && runtimesPreference.length() > 0) {
            String[] locations = runtimesPreference.split("\\|");
            int i = 0;
            while (i < locations.length) {
                MavenRuntime runtime = MavenRuntimeManager.createExternalRuntime(locations[i]);
                this.runtimes.put(runtime.getLocation(), runtime);
                if (runtime.getLocation().equals(selected)) {
                    this.defaultRuntime = runtime;
                }
                ++i;
            }
        }
    }

    public static MavenRuntime createExternalRuntime(String location) {
        return new MavenExternalRuntime(location);
    }

    public String getGlobalSettingsFile() {
        if (this.defaultRuntime == null || this.defaultRuntime instanceof MavenEmbeddedRuntime) {
            String globalSettings = this.preferenceStore.get("eclipse.m2.globalSettingsFile", null, (Preferences[])this.preferencesLookup);
            return globalSettings.trim().length() == 0 ? null : globalSettings;
        }
        return this.defaultRuntime == null ? null : this.defaultRuntime.getSettings();
    }
}

