/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.LinkedHashSet;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.eclipse.m2e.wtp.ProjectUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.ValidationFramework;

public class UtilityProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.getProject();
        if (!project.isAccessible()) {
            return;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject != null && facetedProject.hasProjectFacet(WTPProjectsUtil.UTILITY_FACET)) {
            MavenProject mavenProject = request.getMavenProject();
            LinkedHashSet<IFacetedProject.Action> actions = new LinkedHashSet<IFacetedProject.Action>();
            WTPProjectsUtil.installJavaFacet(actions, project, facetedProject);
            if (!actions.isEmpty()) {
                facetedProject.modify(actions, monitor);
            }
            WTPProjectsUtil.removeWTPClasspathContainer(project);
            WTPProjectsUtil.removeTestFolderLinks(project, mavenProject, monitor, "/");
            WTPProjectsUtil.setNonDependencyAttributeToContainer(project, monitor);
            IFolder buildFolder = project.getFolder(ProjectUtils.getBuildFolder(mavenProject, project));
            ValidationFramework.getDefault().disableValidation((IResource)buildFolder);
        }
    }
}

