/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.urimap;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtilPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapFactory;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MModelURIMapPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.MappingContainer;
import org.eclipse.m2m.internal.qvt.oml.emf.util.urimap.URIMapping;

public class MetamodelURIMappingHelper {
    public static final String MAPPING_CONTAINER = ".settings";
    public static final String MMODEL_URI_MAPPING_FILENAME = "org.eclipse.m2m.qvt.oml.mmodel.urimap";

    private MetamodelURIMappingHelper() {
    }

    public static IFile getMappingFileHandle(IProject project) {
        return project.getFolder(MAPPING_CONTAINER).getFile(MMODEL_URI_MAPPING_FILENAME);
    }

    public static IStatus saveMappings(IProject project, MappingContainer mappings, boolean merge) {
        if (mappings == null || project == null) {
            throw new IllegalArgumentException();
        }
        try {
            try {
                Resource resource = null;
                if (MetamodelURIMappingHelper.hasMappingResource(project) && merge) {
                    MappingContainer result = MetamodelURIMappingHelper.loadMappings(project);
                    resource = result.eResource();
                    HashMap<String, URIMapping> currentMap = new HashMap<String, URIMapping>();
                    for (URIMapping nextMapping : result.getMapping()) {
                        if (nextMapping.getSourceURI() == null) continue;
                        currentMap.put(nextMapping.getSourceURI(), nextMapping);
                    }
                    for (URIMapping newMapping : mappings.getMapping()) {
                        URIMapping oldMapping = (URIMapping)currentMap.get(newMapping.getSourceURI());
                        if (oldMapping != null) {
                            oldMapping.setTargetURI(newMapping.getTargetURI());
                            continue;
                        }
                        result.getMapping().add((Object)((URIMapping)EcoreUtil.copy((EObject)newMapping)));
                    }
                } else {
                    resource = MetamodelURIMappingHelper.createMappingResource(project);
                    resource.getContents().add((Object)mappings);
                }
                resource.save(null);
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.m2m.qvt.oml.emf.util", "Failed to save metamodel URI mappings", (Throwable)e);
                try {
                    project.refreshLocal(2, null);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return status;
            }
        }
        finally {
            try {
                project.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
        return Status.OK_STATUS;
    }

    public static Resource createMappingResource(IProject project) {
        MModelURIMapPackage.eINSTANCE.getNsURI();
        IFile file = MetamodelURIMappingHelper.getMappingFileHandle(project);
        URI mapFileUri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource res = rs.getResource(mapFileUri, false);
        if (res == null) {
            res = rs.createResource(mapFileUri);
        }
        return res;
    }

    public static MappingContainer loadMappings(IProject project) throws IOException {
        Resource res = MetamodelURIMappingHelper.createMappingResource(project);
        res.load(null);
        return MetamodelURIMappingHelper.getMappings(res);
    }

    public static boolean hasMappingResource(IProject project) {
        return MetamodelURIMappingHelper.getMappingFileHandle(project).exists();
    }

    public static MappingContainer getMappings(Resource resource) {
        for (EObject root : resource.getContents()) {
            if (!(root instanceof MappingContainer)) continue;
            return (MappingContainer)root;
        }
        return null;
    }

    public static MappingContainer createNewMappings(Resource resource) {
        if (MetamodelURIMappingHelper.getMappings(resource) != null) {
            throw new IllegalArgumentException("Resource already has mappings");
        }
        MappingContainer container = MModelURIMapFactory.eINSTANCE.createMappingContainer();
        resource.getContents().add((Object)container);
        return container;
    }

    public static EPackage.Registry mappingsToEPackageRegistry(IProject project, ResourceSet resourceSet) {
        MappingContainer container;
        EPackageRegistryImpl result;
        block7: {
            if (!MetamodelURIMappingHelper.hasMappingResource(project)) {
                return null;
            }
            result = null;
            container = MetamodelURIMappingHelper.loadMappings(project);
            if (container != null && !container.getMapping().isEmpty()) break block7;
            return null;
        }
        try {
            result = new EPackageRegistryImpl(EPackage.Registry.INSTANCE);
            for (URIMapping next : container.getMapping()) {
                EPackage metamodel;
                String nsURI = next.getSourceURI();
                String locationURIStr = next.getTargetURI();
                URI locationURI = null;
                try {
                    locationURI = URI.createURI((String)locationURIStr);
                }
                catch (IllegalArgumentException e) {
                    EmfUtilPlugin.log(e);
                }
                if (nsURI == null || locationURI == null || (metamodel = MetamodelURIMappingHelper.loadEPackage(locationURI, resourceSet)) == null) continue;
                result.put((Object)nsURI, (Object)metamodel);
            }
        }
        catch (IOException e) {
            EmfUtilPlugin.log(e);
        }
        return result;
    }

    private static EPackage loadEPackage(URI uri, ResourceSet rs) {
        try {
            if (uri.fragment() != null) {
                EObject eObject = rs.getEObject(uri, true);
                return eObject instanceof EPackage ? (EPackage)eObject : null;
            }
            Resource resource = rs.getResource(uri.trimFragment(), true);
            return (EPackage)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)EcorePackage.eINSTANCE.getEPackage());
        }
        catch (Exception e) {
            EmfUtilPlugin.log(e);
            return null;
        }
    }
}

