/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.oql.compiler;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.parser.internal.oql.compiler.EvaluationContext;
import org.eclipse.mat.parser.internal.oql.compiler.Expression;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ArrayIndexExpression
extends Expression {
    List<Expression> parameters;

    public ArrayIndexExpression(List<Expression> parameters) {
        this.parameters = parameters;
    }

    @Override
    public Object compute(EvaluationContext ctx) throws SnapshotException, IProgressListener.OperationCanceledException {
        Object subject = ctx.getSubject();
        if (subject == null) {
            return null;
        }
        Object[] arguments = new Object[this.parameters.size()];
        int ii = 0;
        while (ii < arguments.length) {
            arguments[ii] = this.parameters.get(ii).compute(ctx);
            ++ii;
        }
        Object indexObj = arguments[0];
        if (!(indexObj instanceof Integer || indexObj instanceof Short || indexObj instanceof Byte)) {
            throw new IllegalArgumentException(String.valueOf(this.toString()) + ": " + (indexObj != null ? indexObj.getClass() : null));
        }
        int index = ((Number)arguments[0]).intValue();
        if (subject.getClass().isArray()) {
            int len = Array.getLength(subject);
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return Array.get(subject, index);
        }
        if (subject instanceof List) {
            List l = (List)subject;
            int len = l.size();
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            return ((List)subject).get(index);
        }
        if (subject instanceof IPrimitiveArray) {
            IPrimitiveArray array = (IPrimitiveArray)subject;
            int len = array.getLength();
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            if (index >= array.getLength()) {
                return null;
            }
            return array.getValueAt(index);
        }
        if (subject instanceof IObjectArray) {
            IObjectArray array = (IObjectArray)subject;
            int len = array.getLength();
            if (index >= len) {
                return null;
            }
            if (index < 0) {
                return null;
            }
            if (index >= array.getLength()) {
                return null;
            }
            long addr = array.getReferenceArray(index, 1)[0];
            if (addr == 0L) {
                return null;
            }
            ISnapshot snapshot = array.getSnapshot();
            int objectId = snapshot.mapAddressToId(addr);
            return snapshot.getObject(objectId);
        }
        throw new IllegalArgumentException(subject + this.toString() + ": " + subject.getClass());
    }

    @Override
    public boolean isContextDependent(EvaluationContext ctx) {
        for (Expression element : this.parameters) {
            boolean isContextDependent = element.isContextDependent(ctx);
            if (!isContextDependent) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("[");
        Iterator<Expression> iter = this.parameters.iterator();
        while (iter.hasNext()) {
            Expression element = iter.next();
            buf.append(element);
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }
}

