/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core;

import com.google.gerrit.common.data.AccountInfo;
import com.google.gerrit.common.data.GerritConfig;
import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountGeneralPreferences;
import com.google.gerrit.reviewdb.Project;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritConfiguration;
import org.eclipse.mylyn.internal.gerrit.core.client.compat.ProjectDetailX;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.osgi.util.NLS;

public class GerritUtil {
    public static String getUserLabel(AccountInfo user) {
        if (user == null) {
            return "Anonymous";
        }
        if (user.getFullName() != null) {
            return user.getFullName();
        }
        if (user.getPreferredEmail() != null) {
            String email = user.getPreferredEmail();
            int i = email.indexOf("@");
            return i > 0 ? email.substring(0, i) : email;
        }
        return "<Unknown>";
    }

    public static boolean isPermissionOnlyProject(ProjectDetailX projectDetail, GerritConfig config) {
        if (projectDetail.isPermissionOnly) {
            return true;
        }
        return projectDetail.project.getName().equals(config.getWildProject().get());
    }

    public static String shortenText(String t, int minChars, int maxChars) {
        Assert.isTrue((minChars >= 0 ? 1 : 0) != 0);
        Assert.isTrue((maxChars >= 0 ? 1 : 0) != 0);
        Assert.isTrue((minChars <= maxChars ? 1 : 0) != 0);
        if (t.length() < maxChars) {
            return t;
        }
        int i = maxChars - 1;
        while (i >= minChars) {
            if (Character.isWhitespace(t.charAt(i))) {
                return NLS.bind((String)"{0}...", (Object)t.substring(0, i));
            }
            --i;
        }
        return NLS.bind((String)"{0}...", (Object)t.substring(0, minChars));
    }

    public static String getSshCloneUri(TaskRepository repository, GerritConfiguration config, Project project) throws URISyntaxException {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.SSH) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            String user;
            String sshAddress = config.getGerritConfig().getSshdAddress();
            Account account = config.getAccount();
            StringBuilder sb = new StringBuilder();
            sb.append("ssh://");
            if (account != null && (user = account.getUserName()) != null && !user.equals("")) {
                sb.append(user);
                sb.append("@");
            }
            if (sshAddress.startsWith("*:") || "".equals(sshAddress)) {
                sb.append(new URI(repository.getRepositoryUrl()).getHost());
            }
            if (sshAddress.startsWith("*:")) {
                sb.append(sshAddress.substring(1));
            } else {
                sb.append(sshAddress);
            }
            sb.append("/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getHttpCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.HTTP) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            String user;
            Account account = config.getAccount();
            StringBuilder sb = new StringBuilder();
            String httpAddress = config.getGerritConfig().getGitHttpUrl() != null ? config.getGerritConfig().getGitHttpUrl() : repository.getUrl();
            int schemeEndIndex = httpAddress.indexOf("://") + 3;
            sb.append(httpAddress.substring(0, schemeEndIndex));
            if (!httpAddress.contains("@") && account != null && (user = account.getUserName()) != null && !user.equals("")) {
                sb.append(user);
                sb.append('@');
            }
            sb.append(httpAddress.substring(schemeEndIndex));
            if (!httpAddress.substring(schemeEndIndex).endsWith("/")) {
                sb.append("/");
            }
            sb.append("p/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getAnonHttpCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        if (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.ANON_HTTP) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS)) {
            StringBuilder sb = new StringBuilder();
            String httpAddress = config.getGerritConfig().getGitHttpUrl() != null ? config.getGerritConfig().getGitHttpUrl() : repository.getUrl();
            sb.append(httpAddress);
            if (!httpAddress.endsWith("/")) {
                sb.append("/");
            }
            sb.append("p/");
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static String getAnonGitCloneUri(TaskRepository repository, GerritConfiguration config, Project project) {
        Set supportedDownloadSchemes = config.getGerritConfig().getDownloadSchemes();
        String gitAddress = config.getGerritConfig().getGitDaemonUrl();
        if (gitAddress != null && (supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.ANON_GIT) || supportedDownloadSchemes.contains(AccountGeneralPreferences.DownloadScheme.DEFAULT_DOWNLOADS))) {
            StringBuilder sb = new StringBuilder();
            sb.append(gitAddress);
            if (!gitAddress.endsWith("/")) {
                sb.append("/");
            }
            sb.append(project.getName());
            return sb.toString();
        }
        return null;
    }

    public static HashMap<AccountGeneralPreferences.DownloadScheme, String> getCloneUris(GerritConfiguration config, TaskRepository repository, Project project) throws URISyntaxException {
        boolean isAuthenticated = config.getAccount() != null;
        HashMap<AccountGeneralPreferences.DownloadScheme, String> uriMap = new HashMap<AccountGeneralPreferences.DownloadScheme, String>();
        if (isAuthenticated) {
            uriMap.put(AccountGeneralPreferences.DownloadScheme.SSH, GerritUtil.getSshCloneUri(repository, config, project));
            uriMap.put(AccountGeneralPreferences.DownloadScheme.HTTP, GerritUtil.getHttpCloneUri(repository, config, project));
        }
        uriMap.put(AccountGeneralPreferences.DownloadScheme.ANON_HTTP, GerritUtil.getAnonHttpCloneUri(repository, config, project));
        uriMap.put(AccountGeneralPreferences.DownloadScheme.ANON_GIT, GerritUtil.getAnonGitCloneUri(repository, config, project));
        return uriMap;
    }
}

