/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.debug.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.net4j.internal.debug.RemoteTraceManager;
import org.eclipse.net4j.internal.debug.messages.Messages;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.om.trace.RemoteTraceServer;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class RemoteTraceView
extends ViewPart {
    private static RemoteTraceView instance;
    private TableViewer viewer;
    private Action clearAction;
    private Action doubleClickAction;

    public void dispose() {
        instance = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.getTable().setHeaderVisible(true);
        this.createColmuns(this.viewer);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        instance = this;
    }

    protected void createColmuns(TableViewer viewer) {
        String[] columnNames = new String[]{Messages.getString("RemoteTraceView.0"), Messages.getString("RemoteTraceView.1"), Messages.getString("RemoteTraceView.2"), Messages.getString("RemoteTraceView.3"), Messages.getString("RemoteTraceView.4"), Messages.getString("RemoteTraceView.5"), Messages.getString("RemoteTraceView.6"), Messages.getString("RemoteTraceView.7")};
        int[] columnWidths = new int[]{60, 170, 80, 160, 120, 120, 400, 200};
        TableColumn[] columns = new TableColumn[columnNames.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(viewer.getTable(), 16384, i);
            column.setText(columnNames[i]);
            column.setWidth(columnWidths[i]);
            column.setMoveable(true);
            column.setResizable(true);
            ++i;
        }
    }

    public static void notifyNewTrace() {
        if (instance != null) {
            instance.refreshViewer();
        }
    }

    public void refreshViewer() {
        UIUtil.refreshViewer((Viewer)this.viewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RemoteTraceView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.clearAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.clearAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.clearAction);
    }

    private void makeActions() {
        this.clearAction = new Action(){

            public void run() {
                RemoteTraceManager.INSTANCE.clearEvents();
                RemoteTraceView.this.refreshViewer();
            }
        };
        this.clearAction.setText(Messages.getString("RemoteTraceView.9"));
        this.clearAction.setToolTipText(Messages.getString("RemoteTraceView.10"));
        this.clearAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = RemoteTraceView.this.viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                RemoteTraceView.this.showMessage(String.valueOf(Messages.getString("RemoteTraceView.11")) + obj.toString());
            }
        };
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RemoteTraceView.this.doubleClickAction.run();
            }
        });
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)Messages.getString("RemoteTraceView.12"), (String)message);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    class NameSorter
    extends ViewerSorter {
        NameSorter() {
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return RemoteTraceManager.INSTANCE.getEvents();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private Image info;
        private Image error;
        private Image text;

        public ViewLabelProvider() {
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            this.info = sharedImages.getImage("IMG_OBJS_INFO_TSK");
            this.error = sharedImages.getImage("IMG_OBJS_ERROR_TSK");
            this.text = sharedImages.getImage("IMG_OBJ_FILE");
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof RemoteTraceServer.Event) {
                RemoteTraceServer.Event event = (RemoteTraceServer.Event)obj;
                String text = event.getText(index);
                switch (index) {
                    case 5: {
                        return ReflectUtil.getSimpleClassName((String)text);
                    }
                    case 6: {
                        int at = text.indexOf(64);
                        if (at == -1) {
                            return text;
                        }
                        String context = ReflectUtil.getSimpleClassName((String)event.getText(5));
                        String id = text.substring(at + 1);
                        String className = text.substring(0, at);
                        if (ObjectUtil.equals((Object)context, (Object)className)) {
                            return id;
                        }
                        return String.valueOf(id) + " (" + className + ")";
                    }
                    case 7: {
                        return this.getFirstLine(text);
                    }
                }
                return text;
            }
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof RemoteTraceServer.Event) {
                RemoteTraceServer.Event event = (RemoteTraceServer.Event)obj;
                switch (index) {
                    case 0: {
                        return event.hasError() ? this.error : this.info;
                    }
                    case 7: {
                        return this.hasNL(event.getMessage()) ? this.text : null;
                    }
                    case 8: {
                        return event.hasError() ? this.error : null;
                    }
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        private boolean hasNL(String str) {
            return str.indexOf(10) != -1;
        }

        private String getFirstLine(String str) {
            int nl = str.indexOf(10);
            if (nl != -1) {
                str = str.substring(0, nl);
            }
            return str.replaceAll("\r", "");
        }
    }
}

