/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.debug.adaptor.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.objectteams.otdt.core.IOTType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.debug.adaptor.launching.OTLaunchConfigurationTab;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.objectteams.otdt.ui.dialogs.ISearchFilter;
import org.eclipse.objectteams.otdt.ui.dialogs.TeamSelectionDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TeamConfig
extends Composite {
    private Button _downButton;
    private Button _upButton;
    private Button _removeButton;
    private Button _addButton;
    private OTLaunchConfigurationTab _otLaunchConfigTab;
    private TableViewer _teamList;
    private Button _activeCheckButton;

    public TeamConfig(Composite parent, int style, OTLaunchConfigurationTab otlcTab) {
        super(parent, style);
        this._otLaunchConfigTab = otlcTab;
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        grid.marginWidth = 3;
        this.setLayout((Layout)grid);
        this._activeCheckButton = new Button((Composite)this, 32);
        this._activeCheckButton.setText(OTDTUIPlugin.getResourceString((String)"TeamConfig.activate_checkbox_description"));
        GridData data = new GridData(258);
        this._activeCheckButton.setLayoutData((Object)data);
        this._activeCheckButton.setFont(this.getFont());
        this._activeCheckButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean active = TeamConfig.this.isTeamConfigActive();
                TeamConfig.this._teamList.getControl().setEnabled(active);
                TeamConfig.this._otLaunchConfigTab.setModified();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite mainCompo = new Composite((Composite)this, 0);
        mainCompo.setLayout((Layout)new FormLayout());
        data = new GridData(1808);
        mainCompo.setLayoutData((Object)data);
        this._teamList = new TableViewer(mainCompo, 2816);
        AppearanceAwareLabelProvider labelProvider = new AppearanceAwareLabelProvider();
        labelProvider.setTextFlags(0x100000L);
        this._teamList.setLabelProvider((IBaseLabelProvider)labelProvider);
        this._teamList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    List list = (List)inputElement;
                    return list.toArray(new IType[list.size()]);
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this._teamList.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TeamConfig.this.checkEnablement();
            }
        });
        FormData formData = new FormData();
        formData.right = new FormAttachment(100, -162);
        formData.bottom = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 2);
        Control teamListControl = this._teamList.getControl();
        teamListControl.setLayoutData((Object)formData);
        Composite composite_1 = new Composite(mainCompo, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        composite_1.setLayout((Layout)gridLayout);
        FormData formData_1 = new FormData();
        formData_1.left = new FormAttachment(teamListControl, 5, 131072);
        formData_1.bottom = new FormAttachment(teamListControl, 0, 1024);
        formData_1.right = new FormAttachment(100, -5);
        formData_1.top = new FormAttachment(teamListControl, 0, 128);
        composite_1.setLayoutData((Object)formData_1);
        this._addButton = new Button(composite_1, 0);
        GridData gridData = new GridData(770);
        this._addButton.setLayoutData((Object)gridData);
        this._addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeamConfig.this.askAddTeam();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._addButton.setText(OTDTUIPlugin.getResourceString((String)"TeamConfig.add_team_button_label"));
        this._removeButton = new Button(composite_1, 0);
        GridData gridData_1 = new GridData(770);
        this._removeButton.setLayoutData((Object)gridData_1);
        this._removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeamConfig.this.removeSelected();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._removeButton.setText(OTDTUIPlugin.getResourceString((String)"TeamConfig.remove_team_button_label"));
        this._upButton = new Button(composite_1, 0);
        GridData gridData_2 = new GridData(770);
        gridData_2.horizontalSpan = 2;
        this._upButton.setLayoutData((Object)gridData_2);
        this._upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeamConfig.this.moveSelectedUp();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._upButton.setText(OTDTUIPlugin.getResourceString((String)"TeamConfig.team_up_button_label"));
        this._downButton = new Button(composite_1, 0);
        GridData gridData_3 = new GridData(770);
        this._downButton.setLayoutData((Object)gridData_3);
        this._downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TeamConfig.this.moveSelectedDown();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this._downButton.setText(OTDTUIPlugin.getResourceString((String)"TeamConfig.team_down_button_label"));
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
        super.checkSubclass();
    }

    private void addTeam(IType chosenTeam) {
        if (chosenTeam != null) {
            IType teamType = chosenTeam;
            if (!(chosenTeam instanceof IOTType)) {
                teamType = OTModelManager.getOTElement((IType)chosenTeam);
            }
            if (teamType != null) {
                this._otLaunchConfigTab.getTeamsModel().add(teamType);
                this._otLaunchConfigTab.setModified();
                this.checkEnablement();
                this._teamList.refresh();
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)OTDTUIPlugin.getResourceString((String)"TeamConfig.error_adding_team_title"), (String)NLS.bind((String)OTDTUIPlugin.getResourceString((String)"TeamConfig.error_adding_team_message"), (Object[])new Object[]{chosenTeam.getFullyQualifiedName()}));
            }
        }
    }

    public void clearTeamList() {
        this._otLaunchConfigTab.getTeamsModel().clear();
        this.checkEnablement();
        this._teamList.refresh();
    }

    public boolean isTeamConfigActive() {
        return this._activeCheckButton.getSelection();
    }

    public void setActive(boolean active) {
        this._activeCheckButton.setSelection(active);
        this._teamList.getControl().setEnabled(active);
    }

    private IType chooseTeamFromClasspath(IProject project) {
        if (project == null || !project.exists()) {
            return null;
        }
        IJavaProject java_project = JavaCore.create((IProject)project);
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{java_project});
        TeamSelectionDialog dialog = new TeamSelectionDialog(this.getShell(), this._otLaunchConfigTab.getRunnableContext(), scope);
        dialog.setTitle(OTDTUIPlugin.getResourceString((String)"TeamConfig.choose_team_dialog_title"));
        dialog.setMessage(OTDTUIPlugin.getResourceString((String)"TeamConfig.choose_team_dialog_description"));
        dialog.setFilter("*");
        dialog.addSearchFilter(new ISearchFilter(){

            public IOTType[] filterTypes(IOTType[] types) {
                List<IType> teamsModel = TeamConfig.this._otLaunchConfigTab.getTeamsModel();
                ArrayList<IOTType> result = new ArrayList<IOTType>(types.length);
                int i = 0;
                while (i < types.length) {
                    IOTType type = types[i];
                    if (!Flags.isAbstract((int)type.getFlags()) && !teamsModel.contains(type)) {
                        result.add(type);
                    }
                    ++i;
                }
                return result.toArray(new IOTType[result.size()]);
            }
        });
        if (dialog.open() == 0) {
            IType selectedType = (IType)dialog.getFirstResult();
            return selectedType;
        }
        return null;
    }

    private void removeSelected() {
        IStructuredSelection selection = (IStructuredSelection)this._teamList.getSelection();
        for (IType selectedType : selection) {
            this._otLaunchConfigTab.getTeamsModel().remove(selectedType);
        }
        this._otLaunchConfigTab.setModified();
        this.checkEnablement();
        this._teamList.refresh();
    }

    private void askAddTeam() {
        IProject project = this._otLaunchConfigTab.getProject();
        if (project == null) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OTDTUIPlugin.getResourceString((String)"TeamConfig.project_not_set_title"), (String)OTDTUIPlugin.getResourceString((String)"TeamConfig.project_not_set_message"));
            return;
        }
        IType chosenTeam = this.chooseTeamFromClasspath(project);
        if (chosenTeam != null) {
            this.addTeam(chosenTeam);
        }
    }

    private void moveSelectedUp() {
        List<IType> teamModel = this._otLaunchConfigTab.getTeamsModel();
        int currentIndex = this.getTeamSelectionIndex();
        if (currentIndex > 0) {
            IType currentTeam = teamModel.get(currentIndex);
            IType aboveTeam = teamModel.get(currentIndex - 1);
            teamModel.set(currentIndex - 1, currentTeam);
            teamModel.set(currentIndex, aboveTeam);
            this._teamList.refresh();
            this._otLaunchConfigTab.setModified();
            this.checkMoveEnablement();
        }
    }

    private void moveSelectedDown() {
        List<IType> teamModel = this._otLaunchConfigTab.getTeamsModel();
        int currentIndex = this.getTeamSelectionIndex();
        if (currentIndex < this._otLaunchConfigTab.getTeamsModel().size() - 1) {
            IType currentTeam = teamModel.get(currentIndex);
            IType belowTeam = teamModel.get(currentIndex + 1);
            teamModel.set(currentIndex + 1, currentTeam);
            teamModel.set(currentIndex, belowTeam);
            this._teamList.refresh();
            this._otLaunchConfigTab.setModified();
            this.checkMoveEnablement();
        }
    }

    void checkEnablement() {
        this.checkMoveEnablement();
        this.checkActiveEnablement();
        if (this._teamList.getSelection().isEmpty()) {
            this._removeButton.setEnabled(false);
        } else {
            this._removeButton.setEnabled(true);
        }
    }

    private void checkActiveEnablement() {
        boolean enable = !this._otLaunchConfigTab.getTeamsModel().isEmpty();
        this._activeCheckButton.setEnabled(enable);
    }

    private void checkMoveEnablement() {
        boolean canMove;
        int index = this.getTeamSelectionIndex();
        if (index == -1) {
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(false);
            return;
        }
        int count = this._otLaunchConfigTab.getTeamsModel().size();
        boolean bl = canMove = count >= 2;
        if (index == 0) {
            this._upButton.setEnabled(false);
            this._downButton.setEnabled(canMove);
        } else if (index == count - 1) {
            this._downButton.setEnabled(false);
            this._upButton.setEnabled(canMove);
        } else {
            this._upButton.setEnabled(canMove);
            this._downButton.setEnabled(canMove);
        }
    }

    private int getTeamIndex(Object element) {
        return this._otLaunchConfigTab.getTeamsModel().indexOf(element);
    }

    private int getTeamSelectionIndex() {
        IStructuredSelection selection = (IStructuredSelection)this._teamList.getSelection();
        if (selection == null || selection.isEmpty()) {
            return -1;
        }
        return this.getTeamIndex(selection.getFirstElement());
    }

    public void setTeamInput(List<IType> teamModel) {
        this._teamList.setInput(teamModel);
    }
}

