/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.objectteams.otequinox.hook.IByteCodeAnalyzer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ASMByteCodeAnalyzer
implements IByteCodeAnalyzer {
    private static final int ACC_TEAM = 32768;
    private Map<String, ClassInformation> classInformationMap = new ConcurrentHashMap<String, ClassInformation>(512, 0.75f, 4);

    public String getSuperclass(InputStream classStream, String className) {
        try {
            return this.getClassInformation(null, classStream, className).getSuperClassName();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getSuperclass(byte[] classBytes, String className) {
        try {
            return this.getClassInformation(classBytes, null, className).getSuperClassName();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isTeam(byte[] classBytes, String className) throws IOException {
        return this.getClassInformation(classBytes, null, className).isTeam();
    }

    private ClassInformation getClassInformation(byte[] classBytes, InputStream classStream, String className) throws IOException {
        ClassInformation classInformation = this.classInformationMap.get(className);
        if (classInformation != null) {
            return classInformation;
        }
        classInformation = classBytes != null ? this.getClassInformationPrivate(classBytes) : this.getClassInformationPrivate(classStream);
        this.classInformationMap.put(className, classInformation);
        return classInformation;
    }

    private ClassInformation getClassInformationPrivate(InputStream classStream) throws IOException {
        return this.getClassInformationPrivate(new ClassReader(classStream));
    }

    private ClassInformation getClassInformationPrivate(byte[] classBytes) {
        return this.getClassInformationPrivate(new ClassReader(classBytes));
    }

    private ClassInformation getClassInformationPrivate(ClassReader reader) {
        MyVisitor visitor = new MyVisitor();
        reader.accept((ClassVisitor)visitor, 0);
        return new ClassInformation(visitor.isTeam(), visitor.getSuperClassName());
    }

    private static class ClassInformation {
        private boolean isTeam;
        private String superClassName;

        public ClassInformation(boolean isTeam, String superClassName) {
            this.isTeam = isTeam;
            this.superClassName = superClassName;
        }

        public boolean isTeam() {
            return this.isTeam;
        }

        public String getSuperClassName() {
            if (this.superClassName != null) {
                return this.superClassName.replace('/', '.');
            }
            return null;
        }
    }

    private static class MyVisitor
    extends EmptyVisitor {
        private boolean isTeam;
        private String superClassName;

        MyVisitor() {
        }

        public boolean isTeam() {
            return this.isTeam;
        }

        public String getSuperClassName() {
            return this.superClassName;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.superClassName = superName;
            this.isTeam = (access & 0x8000) != 0;
        }
    }
}

