/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.AspectBindingRequestAnswer;
import org.eclipse.objectteams.otequinox.IAspectRequestNegotiator;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.otequinox.hook.AspectPermission;
import org.eclipse.objectteams.otequinox.hook.HookConfigurator;
import org.eclipse.objectteams.otequinox.hook.ILogger;
import org.eclipse.objectteams.otequinox.internal.AspectBinding;
import org.eclipse.objectteams.otequinox.internal.MasterTeamLoader;
import org.eclipse.osgi.service.datalocation.Location;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectPermissionManager {
    private static final String FORCED_EXPORT_DEFAULT = "forced.export.default";
    private static final String ASPECT_BINDING_DEFAULT = "aspect.binding.default";
    private static final String NEGOTIATION_DEFAULTS_FILE = "negotiationDefaults.txt";
    private static final String GRANTED_FORCED_EXPORTS_FILE = "grantedForcedExports.txt";
    private static final String DENIED_FORCED_EXPORTS_FILE = "deniedForcedExports.txt";
    private Set<String> deniedAspects = new HashSet<String>();
    private AspectPermission defaultAspectBindingPermission = AspectPermission.GRANT;
    private AspectPermission defaultForcedExportPermission = AspectPermission.UNDEFINED;
    private List<IAspectRequestNegotiator> negotiators = new ArrayList<IAspectRequestNegotiator>();
    private HashMap<String, ArrayList<String[]>> deniedForcedExportsByAspect = new HashMap();
    private HashMap<String, ArrayList<String[]>> grantedForcedExportsByAspect = new HashMap();
    private HashMap<String, Set<String>> deniedTeamsByAspectBinding = new HashMap();
    private HashMap<String, Set<String>> grantedTeamsByAspectBinding = new HashMap();
    private IPath otequinoxState;
    private Bundle transformerBundle;
    private PackageAdmin packageAdmin;
    private ILogger log;
    private boolean isWaitingForLocation = true;
    List<Runnable> obligations = new ArrayList<Runnable>();

    public AspectPermissionManager(ILogger log, Bundle bundle, PackageAdmin packageAdmin) {
        this.log = log;
        this.transformerBundle = bundle;
        this.packageAdmin = packageAdmin;
    }

    public boolean isReady() {
        block6: {
            if (!this.isWaitingForLocation) {
                return true;
            }
            try {
                InternalPlatform platform = InternalPlatform.getDefault();
                Location instanceLocation = platform.getInstanceLocation();
                if (instanceLocation.isSet()) break block6;
                return false;
            }
            catch (NoClassDefFoundError ncdfe) {
                this.log.log(2, "Optional class InternalPlatform not found, cannot access workspace location");
                this.isWaitingForLocation = false;
                return true;
            }
        }
        this.isWaitingForLocation = false;
        this.fetchAspectBindingPermssionsFromWorkspace();
        if (!this.obligations.isEmpty()) {
            for (Runnable job : this.obligations) {
                job.run();
            }
        }
        return true;
    }

    private void fetchAspectBindingPermssionsFromWorkspace() {
        try {
            this.otequinoxState = InternalPlatform.getDefault().getStateLocation(this.transformerBundle, true);
        }
        catch (NoClassDefFoundError ncdfe) {
            this.log.log(2, "Optional class InternalPlatform not found, cannot access workspace location");
            return;
        }
        IPath configFilePath = this.otequinoxState.append(NEGOTIATION_DEFAULTS_FILE);
        File configFile = new File(configFilePath.toOSString());
        if (configFile.exists()) {
            Properties props = new Properties();
            try {
                boolean migrated = false;
                props.load(new FileInputStream(configFile));
                String value = (String)props.get(ASPECT_BINDING_DEFAULT);
                if (value != null) {
                    try {
                        this.defaultAspectBindingPermission = AspectPermission.valueOf((String)value);
                    }
                    catch (IllegalArgumentException iae) {
                        if ("DONT_CARE".equals(value)) {
                            this.defaultAspectBindingPermission = AspectPermission.UNDEFINED;
                            migrated = true;
                        }
                        this.defaultAspectBindingPermission = AspectPermission.DENY;
                        this.log(iae, "Cannot set default aspect permission from file negotiationDefaults.txt, assuming DENY.");
                    }
                }
                if ((value = (String)props.get(FORCED_EXPORT_DEFAULT)) != null) {
                    try {
                        this.defaultForcedExportPermission = AspectPermission.valueOf((String)value);
                    }
                    catch (IllegalArgumentException iae) {
                        if ("DONT_CARE".equals(value)) {
                            this.defaultForcedExportPermission = AspectPermission.UNDEFINED;
                            migrated = true;
                        }
                        this.defaultForcedExportPermission = AspectPermission.DENY;
                        this.log(iae, "Cannot set default forced exports permission from file negotiationDefaults.txt, assuming DENY.");
                    }
                }
                if (migrated) {
                    this.writeNegotiationDefaults(configFile);
                }
            }
            catch (IOException ioex) {
                this.log(ioex, "Failed to read configuration file " + configFilePath.toOSString());
            }
        } else {
            try {
                File stateDir = new File(this.otequinoxState.toOSString());
                if (!stateDir.exists()) {
                    stateDir.mkdirs();
                }
                configFile.createNewFile();
                this.writeNegotiationDefaults(configFile);
            }
            catch (IOException ioex) {
                this.log(ioex, "Failed to create configuration file " + configFilePath.toOSString());
            }
        }
        if ((configFile = new File((configFilePath = this.otequinoxState.append(DENIED_FORCED_EXPORTS_FILE)).toOSString())).exists()) {
            HookConfigurator.parseForcedExportsFile((File)configFile, (AspectPermission)AspectPermission.DENY);
        }
        if ((configFile = new File((configFilePath = this.otequinoxState.append(GRANTED_FORCED_EXPORTS_FILE)).toOSString())).exists()) {
            HookConfigurator.parseForcedExportsFile((File)configFile, (AspectPermission)AspectPermission.GRANT);
        }
    }

    private void writeNegotiationDefaults(File configFile) throws IOException {
        FileWriter writer = new FileWriter(configFile);
        writer.append("aspect.binding.default=" + this.defaultAspectBindingPermission.toString() + '\n');
        writer.append("forced.export.default=" + this.defaultForcedExportPermission.toString() + '\n');
        writer.flush();
        writer.close();
        this.log(1, "Created aspect binding defaults file " + configFile.getCanonicalPath());
    }

    public void loadAspectBindingNegotiators(BundleContext context) {
        IConfigurationElement[] aspectBindingNegotiatorsConfigs = RegistryFactory.getRegistry().getConfigurationElementsFor("org.eclipse.objectteams.otequinox", "aspectBindingNegotiators");
        int i = 0;
        while (i < aspectBindingNegotiatorsConfigs.length) {
            IConfigurationElement currentNegotiatorConfig = aspectBindingNegotiatorsConfigs[i];
            try {
                Object negotiator = currentNegotiatorConfig.createExecutableExtension("class");
                if (negotiator != null) {
                    this.negotiators.add((IAspectRequestNegotiator)negotiator);
                }
            }
            catch (CoreException e) {
                this.log(e, "Failed to instantiate extension " + currentNegotiatorConfig);
            }
            ++i;
        }
    }

    public boolean isDeniedAspectPlugin(String symbolicName) {
        return this.deniedAspects.contains(symbolicName);
    }

    public boolean checkForcedExports(String aspectId, String baseBundleId, IConfigurationElement[] forcedExports) {
        if (forcedExports == null || forcedExports.length == 0) {
            return true;
        }
        ArrayList<String[]> deniedForcedExports = this.getConfiguredForcedExports(aspectId, AspectPermission.DENY, this.deniedForcedExportsByAspect);
        ArrayList<String[]> grantedForcedExports = this.getConfiguredForcedExports(aspectId, AspectPermission.GRANT, this.grantedForcedExportsByAspect);
        IConfigurationElement[] iConfigurationElementArray = forcedExports;
        int n = forcedExports.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement forcedExport = iConfigurationElementArray[n2];
            String forcedExportsRequest = forcedExport.getValue();
            if (forcedExportsRequest != null) {
                String[] stringArray = forcedExportsRequest.split(",");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String singleForcedExportRequest = stringArray[n4];
                    singleForcedExportRequest = singleForcedExportRequest.trim();
                    boolean grantReported = false;
                    AspectPermission negotiatedPermission = this.defaultForcedExportPermission;
                    if (negotiatedPermission == AspectPermission.DENY) {
                        this.log(4, "Default denial of forced export regarding package " + singleForcedExportRequest + " from bundle " + baseBundleId + " as requested by bundle " + aspectId + "; bundle not activated");
                        this.deniedAspects.add(aspectId);
                        return false;
                    }
                    String[] listEntry = this.findRequestInList(baseBundleId, singleForcedExportRequest, deniedForcedExports);
                    if (listEntry != null) {
                        this.log(4, "Explicit denial of forced export regarding package " + singleForcedExportRequest + " from bundle " + baseBundleId + " as requested by bundle " + aspectId + "; bundle not activated");
                        this.deniedAspects.add(aspectId);
                        return false;
                    }
                    listEntry = this.findRequestInList(baseBundleId, singleForcedExportRequest, grantedForcedExports);
                    if (listEntry != null) {
                        this.log(1, "Forced export granted for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ")");
                        grantReported = true;
                        grantedForcedExports.remove(listEntry);
                        negotiatedPermission = AspectPermission.GRANT;
                    }
                    boolean shouldPersist = false;
                    for (IAspectRequestNegotiator negotiator : this.negotiators) {
                        AspectBindingRequestAnswer answer = negotiator.checkForcedExport(aspectId, baseBundleId, singleForcedExportRequest, negotiatedPermission);
                        if (answer == null || answer.permission.compareTo((Enum)negotiatedPermission) <= 0) continue;
                        shouldPersist = answer.persistent;
                        negotiatedPermission = answer.permission;
                        if (answer.allRequests) {
                            this.defaultForcedExportPermission = negotiatedPermission;
                        }
                        if (negotiatedPermission == AspectPermission.DENY) break;
                    }
                    if (shouldPersist && negotiatedPermission != AspectPermission.UNDEFINED) {
                        this.persistForcedExportsAnswer(aspectId, baseBundleId, singleForcedExportRequest, negotiatedPermission);
                    }
                    if (negotiatedPermission == AspectPermission.GRANT) {
                        if (!grantReported) {
                            this.log(1, "Negotiation granted forced export for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ')');
                        }
                    } else {
                        String verb = "did not grant";
                        if (negotiatedPermission == AspectPermission.DENY) {
                            verb = "denied";
                        }
                        this.log(4, "Negotiation " + verb + " forced export for " + aspectId + ": " + singleForcedExportRequest + " (from bundle " + baseBundleId + ")" + ". Aspect is not activated.");
                        this.deniedAspects.add(aspectId);
                        return false;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        if (!grantedForcedExports.isEmpty()) {
            this.reportUnmatchForcedExports(aspectId, grantedForcedExports);
        }
        return true;
    }

    private ArrayList<String[]> getConfiguredForcedExports(String aspectId, AspectPermission perm, HashMap<String, ArrayList<String[]>> map) {
        ArrayList forcedExports = map.get(aspectId);
        if (forcedExports == null) {
            forcedExports = HookConfigurator.getForcedExportsByAspect((String)aspectId, (AspectPermission)perm);
            map.put(aspectId, forcedExports);
        }
        return forcedExports;
    }

    private String[] findRequestInList(String baseBundleId, String basePackage, ArrayList<String[]> list) {
        if (list != null) {
            for (String[] singleExport : list) {
                if (!singleExport[0].equals(baseBundleId) || !singleExport[1].equals(basePackage)) continue;
                return singleExport;
            }
        }
        return null;
    }

    void reportUnmatchForcedExports(String aspectId, ArrayList<String[]> unmatchedForcedExports) {
        for (String[] export : unmatchedForcedExports) {
            String baseId = export[0];
            String pack = export[1];
            this.log(2, "Aspect " + aspectId + " does not declare forced export of package " + pack + " from bundle " + baseId + " as declared in config.ini (or system property)");
        }
    }

    private void persistForcedExportsAnswer(String aspectId, String baseBundleId, String basePackage, AspectPermission negotiatedPermission) {
        if (this.otequinoxState == null) {
            this.log(4, "Can't persist forcedExports permission, no workspace location accessable.");
            return;
        }
        try {
            String fileName = negotiatedPermission == AspectPermission.DENY ? DENIED_FORCED_EXPORTS_FILE : GRANTED_FORCED_EXPORTS_FILE;
            IPath forcedExportsPath = this.otequinoxState.append(fileName);
            File forcedExportsFile = new File(forcedExportsPath.toOSString());
            if (!forcedExportsFile.exists()) {
                forcedExportsFile.createNewFile();
            }
            FileWriter writer = new FileWriter(forcedExportsFile, true);
            writer.append('\n');
            writer.append(baseBundleId);
            writer.append("\n[\n\t");
            writer.append(basePackage);
            writer.append(";x-friends:=\"");
            writer.append(aspectId);
            writer.append("\"\n]\n");
            writer.flush();
            writer.close();
        }
        catch (IOException ioe) {
            this.log(ioe, "Failed to persist negotiation result");
        }
    }

    boolean checkTeamBinding(String aspectBundleId, String baseBundleId, String teamClass) {
        boolean shouldReportGrant = false;
        AspectPermission negotiatedPermission = this.defaultAspectBindingPermission;
        if (negotiatedPermission == AspectPermission.DENY) {
            this.log(4, "Default denial of aspect binding regarding base bundle " + baseBundleId + " as requested by bundle " + aspectBundleId + "; bundle not activated");
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        String key = String.valueOf(aspectBundleId) + "->" + baseBundleId;
        Set<String> deniedTeams = this.deniedTeamsByAspectBinding.get(key);
        if (deniedTeams != null && !deniedTeams.isEmpty() && deniedTeams.contains(teamClass)) {
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        Set<String> grantedTeams = this.grantedTeamsByAspectBinding.get(key);
        if (grantedTeams != null && grantedTeams.contains(teamClass)) {
            negotiatedPermission = AspectPermission.GRANT;
            shouldReportGrant = true;
        }
        boolean shouldPersist = false;
        for (IAspectRequestNegotiator negotiator : this.negotiators) {
            AspectBindingRequestAnswer answer = negotiator.checkAspectBinding(aspectBundleId, baseBundleId, teamClass, negotiatedPermission);
            if (answer == null || answer.permission.compareTo((Enum)negotiatedPermission) <= 0) continue;
            shouldPersist = answer.persistent;
            negotiatedPermission = answer.permission;
            boolean bl = shouldReportGrant = negotiatedPermission == AspectPermission.GRANT;
            if (answer.allRequests) {
                this.defaultAspectBindingPermission = negotiatedPermission;
            }
            if (negotiatedPermission == AspectPermission.DENY) break;
        }
        if (shouldPersist && negotiatedPermission != AspectPermission.UNDEFINED) {
            this.persistTeamBindingAnswer(aspectBundleId, baseBundleId, teamClass, negotiatedPermission);
        }
        if (negotiatedPermission == AspectPermission.GRANT) {
            if (shouldReportGrant) {
                this.log(1, "Negotiation granted aspect binding for " + aspectBundleId + " to base bundle " + baseBundleId + " by means of team " + teamClass + '.');
            }
        } else {
            String verb = "did not grant";
            if (negotiatedPermission == AspectPermission.DENY) {
                verb = "denied";
            }
            this.log(4, "Negotiation " + verb + " aspect binding for " + aspectBundleId + " to base bundle " + baseBundleId + " by means of team " + teamClass + ". Aspect is not activated.");
            this.deniedAspects.add(aspectBundleId);
            return false;
        }
        return true;
    }

    private void persistTeamBindingAnswer(String aspectBundleId, String baseBundleId, String teamClass, AspectPermission negotiatedPermission) {
    }

    void log(Throwable ex, String msg) {
        msg = "OT/Equinox: " + msg;
        this.log.log("org.eclipse.objectteams.otequinox", ex, msg);
    }

    void log(int status, String msg) {
        if (status >= TransformerPlugin.WARN_LEVEL) {
            this.log.log("org.eclipse.objectteams.otequinox", status, "OT/Equinox: " + msg);
        }
    }

    public void addBaseBundleObligations(final List<Object> teamInstances, final ArrayList<MasterTeamLoader.TeamClassRecord> teamClasses, final Bundle baseBundle) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                ArrayList<MasterTeamLoader.TeamClassRecord> teamsToRevert = new ArrayList<MasterTeamLoader.TeamClassRecord>();
                for (MasterTeamLoader.TeamClassRecord teamClass : teamClasses) {
                    if (AspectPermissionManager.this.checkTeamBinding(teamClass.aspectBundle.getSymbolicName(), baseBundle.getSymbolicName(), teamClass.teamName)) continue;
                    teamsToRevert.add(teamClass);
                }
                if (!teamsToRevert.isEmpty()) {
                    this.revert(teamsToRevert);
                }
            }

            void revert(List<MasterTeamLoader.TeamClassRecord> teamsToRevert) {
                try {
                    HashSet<Bundle> bundlesToStop = new HashSet<Bundle>();
                    Class[] deactivationArgumentTypes = new Class[]{Thread.class};
                    Object[] deactivationArguments = new Object[]{MasterTeamLoader.TeamClassRecord.get_ALL_THREADS()};
                    int i = 0;
                    int c = 0;
                    while (c < teamsToRevert.size()) {
                        MasterTeamLoader.TeamClassRecord teamClass = (MasterTeamLoader.TeamClassRecord)teamClasses.get(c);
                        if (teamClass.activation != ActivationKind.NONE) {
                            Object teamInstance = teamInstances.get(i++);
                            Method deactivationMethod = teamClass.clazz.getMethod("deactivate", deactivationArgumentTypes);
                            deactivationMethod.invoke(teamInstance, deactivationArguments);
                        }
                        bundlesToStop.add(teamClass.aspectBundle);
                        ++c;
                    }
                    for (Bundle bundle : bundlesToStop) {
                        AspectPermissionManager.this.log(4, "Stopping aspect bundle " + bundle.getSymbolicName() + " with denied aspect binding(s)");
                        bundle.stop();
                    }
                }
                catch (Exception e) {
                    AspectPermissionManager.this.log(e, "Failed to revert aspect bundle with denied aspect bindings.");
                }
            }
        });
    }

    public void addForcedExportsObligations(final List<AspectBinding> aspects, final Bundle baseBundle) {
        this.schedule(new Runnable(){

            public void run() {
                for (AspectBinding aspectBinding : aspects) {
                    if (AspectPermissionManager.this.checkForcedExports(aspectBinding.aspectPlugin, baseBundle.getSymbolicName(), aspectBinding.forcedExports)) continue;
                    AspectPermissionManager.this.stopIllegalBundle(aspectBinding.aspectPlugin);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(Runnable job) {
        if (this.isReady()) {
            job.run();
        } else {
            List<Runnable> list = this.obligations;
            synchronized (list) {
                this.obligations.add(job);
            }
        }
    }

    void stopIllegalBundle(String symbolicName) {
        String msgCore = "stop bundle " + symbolicName + " whose requests for forced exports have been denied";
        if (this.packageAdmin == null) {
            this.log(4, "Needing to " + msgCore + " but package admin is not available");
        } else {
            Bundle[] bundles = this.packageAdmin.getBundles(symbolicName, null);
            if (bundles == null) {
                this.log(4, "Needing to " + msgCore + " but bundle cannot be retrieved");
            } else {
                try {
                    bundles[0].stop();
                }
                catch (BundleException e) {
                    this.log(e, "Failed to " + msgCore);
                }
            }
        }
    }
}

