/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otequinox.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.objectteams.otequinox.ActivationKind;
import org.eclipse.objectteams.otequinox.TransformerPlugin;
import org.eclipse.objectteams.otequinox.hook.ClassScanner;
import org.eclipse.objectteams.otequinox.internal.AspectBinding;
import org.eclipse.objectteams.otequinox.internal.AspectPermissionManager;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MasterTeamLoader {
    Bundle baseBundle;
    private List<TeamClassRecord> teamClasses = new ArrayList<TeamClassRecord>();
    private HashMap<Bundle, List<String>> baseBundleToAspectName = new HashMap();

    public MasterTeamLoader(Bundle baseBundle) {
        this.baseBundle = baseBundle;
    }

    public boolean loadTeams(Bundle baseBundle, ClassScanner classScanner, ArrayList<AspectBinding> bindings) {
        for (AspectBinding binding : bindings) {
            String aspectBundleName = binding.aspectPlugin;
            this.log(0, ">>> TransformerPlugin loading aspect plugin " + aspectBundleName + " <<<");
            Bundle aspectBundle = OSGIUtils.getDefault().getBundle(aspectBundleName);
            if (aspectBundle == null) {
                Exception t = new Exception("Aspect bundle " + aspectBundleName + " does not exist.");
                t.fillInStackTrace();
                this.log(t, "Failed to load teams for an aspect plugin.");
            }
            int i = 0;
            while (i < binding.teamClasses.length) {
                try {
                    TeamClassRecord teamClassRecord = new TeamClassRecord(aspectBundle, binding.teamClasses[i], binding.activations[i]);
                    this.teamClasses.add(teamClassRecord);
                    teamClassRecord.readOTAttributes(classScanner);
                    if (binding.subTeamClasses[i] != null) {
                        for (String subTeamName : binding.subTeamClasses[i]) {
                            teamClassRecord.readOTAttributes(classScanner, subTeamName);
                        }
                    }
                }
                catch (Throwable t) {
                    this.log(t, "Exception occurred while loading team class");
                }
                ++i;
            }
            List<String> aspectNames = this.baseBundleToAspectName.get(baseBundle);
            if (aspectNames == null) {
                aspectNames = new ArrayList<String>();
                this.baseBundleToAspectName.put(baseBundle, aspectNames);
            }
            aspectNames.add(aspectBundleName);
        }
        return !this.teamClasses.isEmpty();
    }

    public List<Object> instantiateLoadedTeams(Bundle baseBundle, String triggerClassname, AspectPermissionManager permissionManager) {
        ArrayList<Object> teamInstances = new ArrayList<Object>(this.teamClasses.size());
        boolean permissionManagerReady = permissionManager.isReady();
        if (permissionManagerReady) {
            boolean hasDenial = false;
            for (TeamClassRecord teamClass : this.teamClasses) {
                if (permissionManager.checkTeamBinding(teamClass.aspectBundle.getSymbolicName(), baseBundle.getSymbolicName(), teamClass.teamName)) continue;
                hasDenial = true;
                try {
                    teamClass.aspectBundle.stop();
                    this.log(4, "Stopped bundle " + teamClass.aspectBundle.getSymbolicName() + " which requests unconfirmed aspect binding(s).");
                }
                catch (BundleException e) {
                    this.log(e, "Failed to stop bundle " + teamClass.aspectBundle.getSymbolicName() + " which requests unconfirmed aspect binding(s).");
                }
            }
            if (hasDenial) {
                return teamInstances;
            }
        }
        for (TeamClassRecord teamClass : this.teamClasses) {
            if (teamClass.activation == ActivationKind.NONE) continue;
            try {
                if (teamClass.isAlreadyHandled()) {
                    ActivationKind actualActivation = teamClass.getActualActivation();
                    if (actualActivation == teamClass.activation || actualActivation == ActivationKind.NONE || teamClass.activation == ActivationKind.NONE) continue;
                    this.log(2, "Conflicting activation requests in aspect bindings for team class " + teamClass.teamName);
                    continue;
                }
                Object newTeam = teamClass.newInstance();
                teamInstances.add(newTeam);
                Class[] activationArgumentTypes = new Class[]{};
                Object[] activationArguments = null;
                switch (teamClass.activation) {
                    case ALL_THREADS: {
                        activationArgumentTypes = new Class[]{Thread.class};
                        activationArguments = new Object[]{TeamClassRecord.get_ALL_THREADS()};
                    }
                    case THREAD: {
                        Method activationMethod = teamClass.clazz.getMethod("activate", activationArgumentTypes);
                        activationMethod.invoke(newTeam, activationArguments);
                        this.log(0, ">>> instantiated team: " + teamClass.clazz + ", activation: " + (Object)((Object)teamClass.activation) + " <<<");
                        teamClass.markAsActivated();
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        if (!permissionManagerReady) {
            permissionManager.addBaseBundleObligations(teamInstances, new ArrayList<TeamClassRecord>(this.teamClasses), baseBundle);
        }
        return teamInstances;
    }

    void log(int status, String msg) {
        TransformerPlugin.getDefault().log(status, msg);
    }

    void log(Throwable t, String msg) {
        TransformerPlugin.getDefault().log(t, msg);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TeamClassRecord {
        static Set<Class<?>> allInstantiatedTeams = new HashSet();
        static Map<Class<?>, ActivationKind> allActivations = new HashMap();
        Bundle aspectBundle;
        String teamName;
        Class<?> clazz;
        ActivationKind activation;
        static Thread ALL_THREADS = null;

        TeamClassRecord(Class<?> clazz, ActivationKind activation) {
            this.clazz = clazz;
            this.activation = activation;
        }

        public TeamClassRecord(Bundle aspectBundle, String teamName, ActivationKind activation) throws Exception {
            this.activation = activation;
            this.aspectBundle = aspectBundle;
            this.teamName = teamName;
        }

        static synchronized Thread get_ALL_THREADS() throws Exception {
            if (ALL_THREADS == null) {
                Class<?> ooTeam = Class.forName("org.objectteams.Team");
                Field constantField = ooTeam.getDeclaredField("ALL_THREADS");
                ALL_THREADS = (Thread)constantField.get(null);
            }
            return ALL_THREADS;
        }

        void readOTAttributes(ClassScanner scanner) throws Exception, IOException {
            this.readOTAttributes(scanner, this.teamName);
        }

        void readOTAttributes(ClassScanner scanner, String teamName) throws Exception, IOException {
            block4: {
                TransformerPlugin.getDefault().log(0, "reading attributes of team " + teamName);
                ClassLoader loader = (ClassLoader)((BundleHost)this.aspectBundle).getLoaderProxy().getBundleLoader().createClassLoader();
                for (String candidateName : this.possibleTeamNames(teamName)) {
                    try {
                        scanner.readOTAttributes(this.aspectBundle, candidateName, loader);
                        break block4;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                }
                throw new ClassNotFoundException(teamName);
            }
            Collection baseClassNames = scanner.getCollectedBaseClassNames(teamName);
            if (baseClassNames != null && !baseClassNames.isEmpty()) {
                TransformerPlugin.getDefault().storeAdaptedBaseClassNames(this.aspectBundle.getSymbolicName(), teamName, baseClassNames);
            }
        }

        public boolean isAlreadyHandled() throws ClassNotFoundException {
            if (this.clazz == null) {
                this.loadClass();
            }
            return allInstantiatedTeams.contains(this.clazz);
        }

        public Object newInstance() throws Exception {
            if (this.clazz == null) {
                this.loadClass();
            }
            allInstantiatedTeams.add(this.clazz);
            Object newInstance = this.clazz.newInstance();
            return newInstance;
        }

        private void loadClass() throws ClassNotFoundException {
            for (String candidateName : this.possibleTeamNames(this.teamName)) {
                try {
                    this.clazz = this.aspectBundle.loadClass(candidateName);
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            throw new ClassNotFoundException(this.teamName);
        }

        private List<String> possibleTeamNames(String currentName) {
            int pos;
            ArrayList<String> result = new ArrayList<String>();
            result.add(currentName);
            int sep = 46;
            if (currentName.indexOf(36) > -1) {
                sep = 36;
            }
            int from = currentName.length() - 1;
            while ((pos = currentName.lastIndexOf(sep, from)) != -1) {
                String prefix = currentName.substring(0, pos);
                String postfix = currentName.substring(pos + 1);
                if (sep == 36) {
                    if (!postfix.startsWith("__OT__")) {
                        currentName = String.valueOf(prefix) + "$__OT__" + postfix;
                        result.add(0, currentName);
                    }
                } else {
                    int prevDot = prefix.lastIndexOf(46);
                    if (prevDot <= -1 || !Character.isUpperCase(prefix.charAt(prevDot + 1))) break;
                    currentName = String.valueOf(prefix) + "$__OT__" + postfix;
                    result.add(0, currentName);
                }
                from = pos - 1;
            }
            return result;
        }

        public void markAsActivated() {
            allActivations.put(this.clazz, this.activation);
        }

        public ActivationKind getActualActivation() {
            ActivationKind kind = allActivations.get(this.clazz);
            if (kind == null) {
                return ActivationKind.NONE;
            }
            return kind;
        }
    }
}

