/**
 * <copyright>
 *
 * Copyright (c) 2009, 2011 E.D.Willink and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: TypesItemProviderAdapterFactory.java,v 1.3 2010/04/08 06:27:40 ewillink Exp $
 */
package org.eclipse.ocl.types.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.ocl.types.util.TypesAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TypesItemProviderAdapterFactory
		extends TypesAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.AnyType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AnyTypeItemProvider anyTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.AnyType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAnyTypeAdapter() {
		if (anyTypeItemProvider == null) {
			anyTypeItemProvider = new AnyTypeItemProvider(this);
		}

		return anyTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.BagType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BagTypeItemProvider bagTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.BagType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBagTypeAdapter() {
		if (bagTypeItemProvider == null) {
			bagTypeItemProvider = new BagTypeItemProvider(this);
		}

		return bagTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.CollectionType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CollectionTypeItemProvider collectionTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.CollectionType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCollectionTypeAdapter() {
		if (collectionTypeItemProvider == null) {
			collectionTypeItemProvider = new CollectionTypeItemProvider(this);
		}

		return collectionTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.ElementType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementTypeItemProvider elementTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.ElementType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementTypeAdapter() {
		if (elementTypeItemProvider == null) {
			elementTypeItemProvider = new ElementTypeItemProvider(this);
		}

		return elementTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.InvalidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InvalidTypeItemProvider invalidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.InvalidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInvalidTypeAdapter() {
		if (invalidTypeItemProvider == null) {
			invalidTypeItemProvider = new InvalidTypeItemProvider(this);
		}

		return invalidTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.MessageType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageTypeItemProvider messageTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.MessageType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageTypeAdapter() {
		if (messageTypeItemProvider == null) {
			messageTypeItemProvider = new MessageTypeItemProvider(this);
		}

		return messageTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.OrderedSetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderedSetTypeItemProvider orderedSetTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.OrderedSetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderedSetTypeAdapter() {
		if (orderedSetTypeItemProvider == null) {
			orderedSetTypeItemProvider = new OrderedSetTypeItemProvider(this);
		}

		return orderedSetTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.PrimitiveType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveTypeItemProvider primitiveTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.PrimitiveType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveTypeAdapter() {
		if (primitiveTypeItemProvider == null) {
			primitiveTypeItemProvider = new PrimitiveTypeItemProvider(this);
		}

		return primitiveTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.SequenceType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SequenceTypeItemProvider sequenceTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.SequenceType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSequenceTypeAdapter() {
		if (sequenceTypeItemProvider == null) {
			sequenceTypeItemProvider = new SequenceTypeItemProvider(this);
		}

		return sequenceTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.SetType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SetTypeItemProvider setTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.SetType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSetTypeAdapter() {
		if (setTypeItemProvider == null) {
			setTypeItemProvider = new SetTypeItemProvider(this);
		}

		return setTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.TemplateParameterType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TemplateParameterTypeItemProvider templateParameterTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.TemplateParameterType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTemplateParameterTypeAdapter() {
		if (templateParameterTypeItemProvider == null) {
			templateParameterTypeItemProvider = new TemplateParameterTypeItemProvider(
				this);
		}

		return templateParameterTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.TupleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TupleTypeItemProvider tupleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.TupleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTupleTypeAdapter() {
		if (tupleTypeItemProvider == null) {
			tupleTypeItemProvider = new TupleTypeItemProvider(this);
		}

		return tupleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.TypeType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeTypeItemProvider typeTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.TypeType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypeTypeAdapter() {
		if (typeTypeItemProvider == null) {
			typeTypeItemProvider = new TypeTypeItemProvider(this);
		}

		return typeTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.ocl.types.VoidType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected VoidTypeItemProvider voidTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.ocl.types.VoidType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVoidTypeAdapter() {
		if (voidTypeItemProvider == null) {
			voidTypeItemProvider = new VoidTypeItemProvider(this);
		}

		return voidTypeItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null
			? this
			: parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(
			ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>)
				|| (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (anyTypeItemProvider != null)
			anyTypeItemProvider.dispose();
		if (bagTypeItemProvider != null)
			bagTypeItemProvider.dispose();
		if (collectionTypeItemProvider != null)
			collectionTypeItemProvider.dispose();
		if (elementTypeItemProvider != null)
			elementTypeItemProvider.dispose();
		if (invalidTypeItemProvider != null)
			invalidTypeItemProvider.dispose();
		if (messageTypeItemProvider != null)
			messageTypeItemProvider.dispose();
		if (orderedSetTypeItemProvider != null)
			orderedSetTypeItemProvider.dispose();
		if (primitiveTypeItemProvider != null)
			primitiveTypeItemProvider.dispose();
		if (sequenceTypeItemProvider != null)
			sequenceTypeItemProvider.dispose();
		if (setTypeItemProvider != null)
			setTypeItemProvider.dispose();
		if (templateParameterTypeItemProvider != null)
			templateParameterTypeItemProvider.dispose();
		if (tupleTypeItemProvider != null)
			tupleTypeItemProvider.dispose();
		if (typeTypeItemProvider != null)
			typeTypeItemProvider.dispose();
		if (voidTypeItemProvider != null)
			voidTypeItemProvider.dispose();
	}

}
