/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.utilities;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.examples.domain.compatibility.EMF_2_9;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectMap
extends StandaloneProjectMap {
    public static ProjectMap findAdapter(ResourceSet resourceSet) {
        return (ProjectMap)EcoreUtil.getAdapter((List)resourceSet.eAdapters(), ProjectMap.class);
    }

    public static synchronized ProjectMap getAdapter(ResourceSet resourceSet) {
        ProjectMap adapter = ProjectMap.findAdapter(resourceSet);
        if (adapter == null) {
            adapter = new ProjectMap();
            resourceSet.eAdapters().add((Object)adapter);
            adapter.initializeResourceSet(resourceSet);
        }
        return adapter;
    }

    @Override
    protected StandaloneProjectMap.IProjectDescriptor.Internal createProjectDescriptor(String projectName, URI locationURI) {
        return new ProjectDescriptor(projectName, locationURI);
    }

    @Override
    public URI getLocation(String projectName) {
        URI uri = super.getLocation(projectName);
        if (uri == null && EMFPlugin.IS_ECLIPSE_RUNNING) {
            uri = URI.createPlatformPluginURI((String)("/" + projectName + "/"), (boolean)true);
        }
        return uri;
    }

    @Override
    public synchronized void initializeGenModelLocationMap(boolean force) {
        if (force || !this.initializedGenModelLocationMap && !EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.initializeGenModelLocationMap(force);
        }
    }

    @Override
    public synchronized void initializePackageRegistry(ResourceSet resourceSet) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.initializePackageRegistry(resourceSet);
        } else {
            EPackage.Registry packageRegistry = ProjectMap.getPackageRegistry(resourceSet);
            Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
            for (String ePackageNsURI : ePackageNsURIToGenModelLocationMap.keySet()) {
                URI genModelURI = ePackageNsURIToGenModelLocationMap.get(ePackageNsURI);
                if (!genModelURI.isPlatformPlugin()) continue;
                StandaloneProjectMap.IProjectDescriptor.Internal projectDescriptor = this.getProjectDescriptorInternal(genModelURI);
                Object ePackageDescriptor = EPackage.Registry.INSTANCE.get((Object)ePackageNsURI);
                packageRegistry.put((Object)ePackageNsURI, ePackageDescriptor);
                StandaloneProjectMap.IPackageDescriptor packageDescriptor = projectDescriptor.getPackageDescriptor(URI.createURI((String)ePackageNsURI));
                URI localModelURI = packageDescriptor.getEcoreModelURI();
                if (localModelURI == null) continue;
                URI ecorePackageResourceURI = localModelURI.resolve(projectDescriptor.getPlatformResourceURI());
                URI ecorePackagePluginURI = localModelURI.resolve(projectDescriptor.getPlatformPluginURI());
                packageRegistry.put((Object)ecorePackageResourceURI.toString(), (Object)packageDescriptor);
                packageRegistry.put((Object)ecorePackagePluginURI.toString(), (Object)packageDescriptor);
            }
        }
    }

    @Override
    public synchronized void initializePlatformResourceMap(boolean force) {
        if (force || !this.initializedPlatformResourceMap && !EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.initializePlatformResourceMap(force);
        }
    }

    @Override
    public synchronized void initializeURIMap(ResourceSet resourceSet) {
        super.initializeURIMap(resourceSet);
        if (EMFPlugin.IS_ECLIPSE_RUNNING) {
            Map<URI, URI> uriMap = ProjectMap.getURIMap(resourceSet);
            URI resourceURI = URI.createPlatformResourceURI((String)"/", (boolean)true);
            URI pluginURI = URI.createPlatformPluginURI((String)"/", (boolean)true);
            uriMap.put(resourceURI, pluginURI);
        }
    }

    @Override
    public boolean isAdapterForType(Object type) {
        return type instanceof Class && ((Class)type).isAssignableFrom(ProjectMap.class);
    }

    @Override
    protected void scanClassPath(Map<String, StandaloneProjectMap.IProjectDescriptor.Internal> projectDescriptors, SAXParser saxParser) {
        if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
            super.scanClassPath(projectDescriptors, saxParser);
        } else {
            this.scanProjects(projectDescriptors);
            this.scanGenModels(saxParser);
        }
    }

    protected void scanGenModels(SAXParser saxParser) {
        ExtensibleURIConverterImpl uriConverter = new ExtensibleURIConverterImpl();
        Map<String, URI> ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap(false);
        for (String ePackageNsURI : ePackageNsURIToGenModelLocationMap.keySet()) {
            URI nsURI;
            URI genModelURI = ePackageNsURIToGenModelLocationMap.get(ePackageNsURI);
            if (!genModelURI.isPlatformPlugin()) continue;
            StandaloneProjectMap.IProjectDescriptor.Internal projectDescriptor = this.getProjectDescriptorInternal(genModelURI);
            StandaloneProjectMap.IPackageDescriptor.Internal packageDescriptor = (StandaloneProjectMap.IPackageDescriptor.Internal)projectDescriptor.getPackageDescriptor(nsURI = URI.createURI((String)ePackageNsURI));
            if (packageDescriptor == null) {
                packageDescriptor = projectDescriptor.createPackageDescriptor(nsURI, genModelURI.deresolve(projectDescriptor.getLocationURI(), true, true, true));
            }
            StandaloneProjectMap.GenModelEcorePackageHandler genModelEcorePackageHandler = packageDescriptor.createGenModelEcorePackageHandler();
            InputStream inputStream = null;
            try {
                try {
                    inputStream = uriConverter.createInputStream(genModelURI);
                    saxParser.parse(inputStream, (DefaultHandler)genModelEcorePackageHandler);
                }
                catch (Exception e) {
                    this.logException(new File(genModelURI.toString()), e);
                    try {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                if (inputStream == null) continue;
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void scanProjects(Map<String, StandaloneProjectMap.IProjectDescriptor.Internal> projectDescriptors) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] iProjectArray = root.getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project.isOpen()) {
                String projectName = project.getName();
                String projectKey = "/" + projectName + "/";
                projectDescriptors.put(projectName, this.createProjectDescriptor(projectName, URI.createPlatformResourceURI((String)projectKey, (boolean)true)));
            }
            ++n2;
        }
    }

    public static /* bridge */ /* synthetic */ StandaloneProjectMap findAdapter(ResourceSet resourceSet) {
        return ProjectMap.findAdapter(resourceSet);
    }

    public static /* bridge */ /* synthetic */ StandaloneProjectMap getAdapter(ResourceSet resourceSet) {
        return ProjectMap.getAdapter(resourceSet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProjectDescriptor
    extends StandaloneProjectMap.ProjectDescriptor {
        public ProjectDescriptor(String name, URI locationURI) {
            super(name, locationURI);
        }

        @Override
        public void initializeURIMap(Map<URI, URI> uriMap) {
            if (!EMFPlugin.IS_ECLIPSE_RUNNING) {
                super.initializeURIMap(uriMap);
            } else if (this.locationURI.isPlatformResource()) {
                URI resourceURI = this.locationURI;
                URI pluginURI = this.getPlatformPluginURI();
                uriMap.put(resourceURI, resourceURI);
                uriMap.put(pluginURI, resourceURI);
            }
        }
    }
}

