/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.impl.IntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.LongIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

public class IntIntegerValueImpl
extends IntegerValueImpl {
    private static final long serialVersionUID = -6577108495688855442L;
    private final int value;
    private BigInteger bigValue = null;

    public IntIntegerValueImpl(int value) {
        this.value = value;
    }

    @NonNull
    public IntegerValue abs() {
        if (this.value >= 0) {
            return this;
        }
        if (this.value > Integer.MIN_VALUE) {
            return ValuesUtil.integerValueOf(-this.value);
        }
        return ValuesUtil.integerValueOf(0x80000000L);
    }

    @NonNull
    public IntegerValue addInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            int sum = this.value + thatValue;
            if (this.value >= 0 ? thatValue >= 0 && sum >= 0 : thatValue <= 0 && sum <= 0) {
                return ValuesUtil.integerValueOf(sum);
            }
            return ValuesUtil.integerValueOf((long)this.value + (long)thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValuesUtil.integerValueOf((long)this.value + thatValue);
        }
        BigInteger result = this.bigIntegerValue().add(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public Double asDouble() {
        Double result = this.value;
        return result;
    }

    @NonNull
    public Integer asInteger() {
        Integer result = this.value;
        return result;
    }

    @NonNull
    public Number asNumber() {
        return this.value;
    }

    @NonNull
    public Object asObject() {
        Integer result = this.value;
        return result;
    }

    @NonNull
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }

    @NonNull
    public BigInteger bigIntegerValue() {
        BigInteger bigValue2 = this.bigValue;
        if (bigValue2 != null) {
            return bigValue2;
        }
        BigInteger bigValue3 = this.bigValue = BigInteger.valueOf(this.value);
        return bigValue3;
    }

    public int compareToInteger(@NonNull IntegerValue o) {
        try {
            if (o instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)o).intValue();
                return this.value < thatValue ? -1 : (this.value == thatValue ? 0 : 1);
            }
            if (o instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)o).longValue();
                return (long)this.value < thatValue ? -1 : ((long)this.value == thatValue ? 0 : 1);
            }
            return this.bigIntegerValue().compareTo(o.bigIntegerValue());
        }
        catch (InvalidValueException e) {
            return this.hashCode() - o.hashCode();
        }
    }

    @NonNull
    public IntegerValue divInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("div zero", new Object[0]);
        }
        BigInteger result = this.bigIntegerValue().divide(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public RealValue divideInteger(@NonNull IntegerValue right) {
        BigDecimal bigLeft = this.bigDecimalValue();
        BigDecimal bigRight = right.bigDecimalValue();
        return RealValueImpl.divideBigDecimal(bigLeft, bigRight);
    }

    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object obj) {
        try {
            if (obj instanceof IntIntegerValueImpl) {
                int thatValue = ((IntIntegerValueImpl)obj).intValue();
                return this.value == thatValue;
            }
            if (obj instanceof LongIntegerValueImpl) {
                long thatValue = ((LongIntegerValueImpl)obj).longValue();
                return (long)this.value == thatValue;
            }
            if (obj instanceof IntegerValue) {
                BigInteger bigIntegerValue = ((IntegerValue)obj).bigIntegerValue();
                return this.bigIntegerValue().compareTo(bigIntegerValue) == 0;
            }
            if (obj instanceof RealValue) {
                BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
                return this.bigDecimalValue().compareTo(bigDecimalValue) == 0;
            }
        }
        catch (InvalidValueException invalidValueException) {
            // empty catch block
        }
        return this == obj;
    }

    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public int intValue() {
        return this.value;
    }

    public boolean isUnlimitedNatural() {
        return this.value >= 0;
    }

    public long longValue() {
        return this.value;
    }

    @NonNull
    public IntegerValue maxInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value >= thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return (long)this.value >= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) >= 0 ? this : right;
    }

    @NonNull
    public IntegerValue minInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return this.value <= thatValue ? this : right;
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return (long)this.value <= thatValue ? this : right;
        }
        return this.bigIntegerValue().compareTo(right.bigIntegerValue()) <= 0 ? this : right;
    }

    @NonNull
    public IntegerValue modInteger(@NonNull IntegerValue right) {
        if (right.bigIntegerValue().signum() == 0) {
            throw new InvalidValueException("mod zero", new Object[0]);
        }
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            return ValuesUtil.integerValueOf(this.value % thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValuesUtil.integerValueOf((long)this.value % thatValue);
        }
        BigInteger result = this.bigIntegerValue().remainder(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public IntegerValue multiplyInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            long thatValue = ((IntIntegerValueImpl)right).intValue();
            return ValuesUtil.integerValueOf((long)this.value * thatValue);
        }
        BigInteger result = this.bigIntegerValue().multiply(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    @NonNull
    public IntegerValue negate() {
        if (this.value > Integer.MIN_VALUE) {
            return ValuesUtil.integerValueOf(-this.value);
        }
        return ValuesUtil.integerValueOf(0x80000000L);
    }

    public int signum() {
        return Integer.signum(this.value);
    }

    @NonNull
    public IntegerValue subtractInteger(@NonNull IntegerValue right) {
        if (right instanceof IntIntegerValueImpl) {
            int thatValue = ((IntIntegerValueImpl)right).intValue();
            int diff = this.value - thatValue;
            if (this.value >= 0 ? thatValue <= 0 && diff >= 0 : thatValue >= 0 && diff <= 0) {
                return ValuesUtil.integerValueOf(diff);
            }
            return ValuesUtil.integerValueOf((long)this.value - (long)thatValue);
        }
        if (right instanceof LongIntegerValueImpl) {
            long thatValue = ((LongIntegerValueImpl)right).longValue();
            return ValuesUtil.integerValueOf((long)this.value - thatValue);
        }
        BigInteger result = this.bigIntegerValue().subtract(right.bigIntegerValue());
        return ValuesUtil.integerValueOf(result);
    }

    public String toString() {
        return Integer.toString(this.value);
    }
}

