/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.CollectionValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseOrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.util.ValuesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrderedSetValueImpl
extends CollectionValueImpl
implements OrderedSetValue {
    @Override
    protected EClass eStaticClass() {
        return ValuesPackage.Literals.ORDERED_SET_VALUE;
    }

    public OrderedSetValueImpl(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> elements) {
        super(typeId, elements);
        assert (this.checkElementsAreUnique(this.elements));
    }

    @Override
    @NonNull
    public OrderedSetValueImpl asOrderedSetValue() {
        return this;
    }

    @Override
    @NonNull
    public SequenceValue asSequenceValue() {
        return this;
    }

    @Override
    @NonNull
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    @Nullable
    public Object at(int index) {
        if (--index < 0 || index >= this.elements.size()) {
            throw new InvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        int curr = 0;
        for (Object object : this) {
            if (curr++ != index) continue;
            return object;
        }
        throw new InvalidValueException("Null collection content", new Object[0]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof OrderedSetValue) || obj instanceof NullValue) {
            return false;
        }
        Iterator<Object> theseElements = this.iterator();
        Iterator<Object> thoseElements = ((OrderedSetValue)obj).iterator();
        while (theseElements.hasNext() && thoseElements.hasNext()) {
            Object thisElement = theseElements.next();
            Object thatElement = thoseElements.next();
            if (!(thisElement == null ? thatElement != null : !thisElement.equals(thatElement))) continue;
            return false;
        }
        return !theseElements.hasNext() && !thoseElements.hasNext();
    }

    @Override
    @NonNull
    public OrderedSetValue excluding(@Nullable Object value) {
        OrderedSetImpl result = new OrderedSetImpl();
        if (value == null) {
            for (Object element : this.elements) {
                if (element == null) continue;
                result.add(element);
            }
        } else {
            for (Object element : this.elements) {
                if (value.equals(element)) continue;
                result.add(element);
            }
        }
        if (result.size() < this.elements.size()) {
            return new SparseOrderedSetValueImpl(this.getTypeId(), result);
        }
        return this;
    }

    @Override
    @NonNull
    public String getKind() {
        return "OrderedSet";
    }

    @Override
    @NonNull
    public IntegerValue indexOf(@Nullable Object object) {
        int index = 1;
        if (object == null) {
            for (Object next : this.elements) {
                if (next == null) {
                    return ValuesUtil.integerValueOf(index);
                }
                ++index;
            }
        } else {
            for (Object next : this.elements) {
                if (object.equals(next)) {
                    return ValuesUtil.integerValueOf(index);
                }
                ++index;
            }
        }
        throw new InvalidValueException(EvaluatorMessages.MissingValue, "indexOf");
    }

    @Override
    @NonNull
    public OrderedSetValue insertAt(int index, @Nullable Object object) {
        if (object instanceof InvalidValueException) {
            throw new InvalidValueException(EvaluatorMessages.InvalidSource, "insertAt");
        }
        boolean isContained = this.elements.contains(object);
        int effectiveSize = this.elements.size() - (isContained ? 1 : 0);
        if (--index < 0 || effectiveSize < index) {
            throw new InvalidValueException(EvaluatorMessages.IndexOutOfRange, index + 1, this.size());
        }
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>();
        int curr = 0;
        if (object == null) {
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                Object next;
                if (curr == index) {
                    result.add(object);
                }
                if ((next = it.next()) == null) continue;
                result.add(next);
                ++curr;
            }
        } else {
            Iterator<Object> it = this.iterator();
            while (it.hasNext()) {
                Object next;
                if (curr == index) {
                    result.add(object);
                }
                if (object.equals(next = it.next())) continue;
                result.add(next);
                ++curr;
            }
        }
        if (index == effectiveSize) {
            result.add(object);
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public boolean isUnique() {
        return true;
    }

    @Override
    @NonNull
    public OrderedSetValue minus(@NonNull UniqueCollectionValue set) {
        OrderedSetImpl result = new OrderedSetImpl(this.elements);
        result.removeAll(set.asCollection());
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public OrderedSetValue reverse() {
        List<? extends Object> elements = this.asList();
        Collections.reverse(elements);
        return new SparseOrderedSetValueImpl(this.getTypeId(), elements);
    }

    @Override
    @NonNull
    public OrderedSetValue sort(@NonNull Comparator<Object> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new SparseOrderedSetValueImpl(this.getTypeId(), values);
    }

    @Override
    @NonNull
    public OrderedSetValue subOrderedSet(int lower, int upper) {
        --upper;
        if (--lower < 0) {
            throw new InvalidValueException(new IndexOutOfBoundsException("lower: " + (lower + 1)));
        }
        if (upper >= this.elements.size()) {
            throw new InvalidValueException(new IndexOutOfBoundsException("upper: " + (upper + 1) + ", size: " + this.size()));
        }
        if (upper < lower) {
            throw new InvalidValueException(new IllegalArgumentException("lower: " + (lower + 1) + ", upper: " + (upper + 1)));
        }
        OrderedSetImpl result = new OrderedSetImpl();
        int curr = 0;
        for (Object object : this.elements) {
            if (curr >= lower && curr <= upper) {
                result.add(object);
            }
            ++curr;
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    @NonNull
    public SequenceValue subSequence(int lower, int upper) {
        return this.subOrderedSet(lower, upper);
    }

    @Override
    @NonNull
    public OrderedSetValue symmetricDifference(@NonNull UniqueCollectionValue set) {
        OrderedSetImpl<Object> result = new OrderedSetImpl<Object>(this.elements);
        for (Object object : set.iterable()) {
            if (result.contains(object)) {
                result.remove(object);
                continue;
            }
            result.add(object);
        }
        return new SparseOrderedSetValueImpl(this.getTypeId(), result);
    }

    @Override
    public SequenceValue toSequenceValue() {
        return this;
    }
}

