/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.SequenceValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseSequenceValueImpl
extends SequenceValueImpl {
    @NonNull
    public static List<Object> createSequenceOfEach(@NonNull Object[] boxedValues) {
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = boxedValues;
        int n = boxedValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object boxedValue = objectArray[n2];
            result.add(boxedValue);
            ++n2;
        }
        return result;
    }

    public SparseSequenceValueImpl(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> boxedValues) {
        super(typeId, boxedValues);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SparseSequenceValueImpl) {
            return this.elements.equals(((SparseSequenceValueImpl)obj).elements);
        }
        return super.equals(obj);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Accumulator
    extends SparseSequenceValueImpl
    implements SequenceValue.Accumulator {
        public Accumulator(@NonNull CollectionTypeId typeId) {
            super(typeId, new ArrayList());
        }

        public Accumulator(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> values) {
            super(typeId, values);
        }

        @Override
        public boolean add(@Nullable Object value) {
            return this.elements.add(value);
        }

        @Override
        @NonNull
        public SequenceValue append(@Nullable Object value) {
            assert (!(value instanceof InvalidValueException));
            this.add(value);
            return this;
        }
    }
}

