/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.domain.values.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCollectionType;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.domain.elements.DomainEnumerationLiteral;
import org.eclipse.ocl.examples.domain.elements.DomainParameterTypes;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypeParameters;
import org.eclipse.ocl.examples.domain.evaluation.DomainModelManager;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.ElementId;
import org.eclipse.ocl.examples.domain.ids.TemplateableId;
import org.eclipse.ocl.examples.domain.ids.TuplePartId;
import org.eclipse.ocl.examples.domain.ids.TupleTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.UnsupportedOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.messages.StatusCodes;
import org.eclipse.ocl.examples.domain.types.AbstractInheritance;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.utilities.StandaloneProjectMap;
import org.eclipse.ocl.examples.domain.validation.DomainSubstitutionLabelProvider;
import org.eclipse.ocl.examples.domain.values.Bag;
import org.eclipse.ocl.examples.domain.values.BagValue;
import org.eclipse.ocl.examples.domain.values.CollectionValue;
import org.eclipse.ocl.examples.domain.values.IntegerRange;
import org.eclipse.ocl.examples.domain.values.IntegerValue;
import org.eclipse.ocl.examples.domain.values.NullValue;
import org.eclipse.ocl.examples.domain.values.ObjectValue;
import org.eclipse.ocl.examples.domain.values.OrderedSetValue;
import org.eclipse.ocl.examples.domain.values.RealValue;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.SetValue;
import org.eclipse.ocl.examples.domain.values.TupleValue;
import org.eclipse.ocl.examples.domain.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.domain.values.Unlimited;
import org.eclipse.ocl.examples.domain.values.UnlimitedValue;
import org.eclipse.ocl.examples.domain.values.Value;
import org.eclipse.ocl.examples.domain.values.ValuesPackage;
import org.eclipse.ocl.examples.domain.values.impl.BagImpl;
import org.eclipse.ocl.examples.domain.values.impl.BagValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.BigIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.CollectionValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.IntegerRangeImpl;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.domain.values.impl.JavaObjectValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.LongIntegerValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.NullValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.OrderedSetImpl;
import org.eclipse.ocl.examples.domain.values.impl.RangeSequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.RealValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseOrderedSetValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.SparseSequenceValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.TupleValueImpl;
import org.eclipse.ocl.examples.domain.values.impl.UnlimitedValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValuesUtil {
    @NonNull
    public static final String NULL_STRING = "null";
    private static final int NEGATIVE_INTEGERS = 256;
    private static final int POSITIVE_INTEGERS = 1025;
    @NonNull
    private static final IntegerValue[] INTEGER_VALUES = new IntegerValue[1281];
    @NonNull
    public static Bag<?> EMPTY_BAG = new BagImpl();
    @NonNull
    public static final Set<Object> EMPTY_SET = Collections.emptySet();
    @NonNull
    public static final BigInteger INTEGER_MAX_VALUE = BigInteger.valueOf(Integer.MAX_VALUE);
    @NonNull
    public static final BigInteger INTEGER_MIN_VALUE = BigInteger.valueOf(Integer.MIN_VALUE);
    @NonNull
    public static final BigInteger LONG_MAX_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    @NonNull
    public static final BigInteger LONG_MIN_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static final String maxLongValue = Long.toString(Long.MAX_VALUE);
    private static final int maxLongSize = maxLongValue.length();
    @NonNull
    public static final Boolean FALSE_VALUE = Boolean.FALSE;
    @NonNull
    public static final InvalidValueException INVALID_VALUE = new InvalidValueException("invalid", new Object[0]);
    @NonNull
    public static final NullValue NULL_VALUE = new NullValueImpl();
    @NonNull
    public static final IntegerValue ONE_VALUE = ValuesUtil.integerValueOf(1);
    @NonNull
    public static final Boolean TRUE_VALUE = Boolean.TRUE;
    @NonNull
    public static final UnlimitedValue UNLIMITED_VALUE = new UnlimitedValueImpl();
    @NonNull
    public static final IntegerValue ZERO_VALUE = ValuesUtil.integerValueOf(0);
    private static boolean allStaticsInitialized = false;

    @NonNull
    public static BagValue asBagValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asBagValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Bag", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static Boolean asBoolean(@Nullable Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Boolean", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static DomainCollectionType asCollectionType(@Nullable Object value) {
        if (value instanceof DomainCollectionType) {
            return (DomainCollectionType)value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "CollectionType", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static CollectionValue asCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asCollectionValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Collection", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static Integer asInteger(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asInteger();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static IntegerValue asIntegerValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asIntegerValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Integer", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static EObject asNavigableObject(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asNavigableObject();
        }
        if (value instanceof EObject) {
            return (EObject)value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "NavigableObject", ValuesUtil.getTypeName(value));
    }

    @Nullable
    public static Object asObject(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asObject();
        }
        return value;
    }

    @NonNull
    public static OrderedSetValue asOrderedSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asOrderedSetValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OrderedSet", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static RealValue asRealValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asRealValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Real", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static SequenceValue asSequenceValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSequenceValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Sequence", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static SetValue asSetValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asSetValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Set", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static String asString(@Nullable Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "String", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static TupleValue asTupleValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asTupleValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Tuple", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static DomainType asType(@Nullable Object value) {
        if (value instanceof DomainType) {
            return (DomainType)value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "Type", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static UniqueCollectionValue asUniqueCollectionValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUniqueCollectionValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "UniqueCollection", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static Value asUnlimitedNaturalValue(@Nullable Object value) {
        if (value instanceof Value) {
            return ((Value)value).asUnlimitedNaturalValue();
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "UnlimitedNatural", ValuesUtil.getTypeName(value));
    }

    public static Object asValue(Object value) {
        if (value != null) {
            return value;
        }
        throw new InvalidValueException(EvaluatorMessages.TypedValueRequired, "OclAny", ValuesUtil.getTypeName(value));
    }

    @NonNull
    public static BigDecimal bigDecimalValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigDecimal) {
            return (BigDecimal)anObject;
        }
        if (anObject instanceof Unlimited) {
            return BigDecimal.valueOf(Double.POSITIVE_INFINITY);
        }
        if (anObject instanceof Number) {
            return BigDecimal.valueOf(((Number)anObject).doubleValue());
        }
        if (anObject instanceof Character) {
            return BigDecimal.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(EvaluatorMessages.InvalidReal, anObject);
    }

    @NonNull
    public static BigInteger bigIntegerValueOf(@NonNull Object anObject) {
        if (anObject instanceof BigInteger) {
            return (BigInteger)anObject;
        }
        if (anObject instanceof Number) {
            return BigInteger.valueOf(((Number)anObject).longValue());
        }
        if (anObject instanceof Character) {
            return BigInteger.valueOf(((Character)anObject).charValue());
        }
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, anObject);
    }

    @NonNull
    public static Character characterValueOf(@NonNull Object anObject) {
        if (anObject instanceof Character) {
            return (Character)anObject;
        }
        if (anObject instanceof Number) {
            return Character.valueOf((char)((Number)anObject).longValue());
        }
        throw new InvalidValueException(EvaluatorMessages.InvalidCharacter, anObject);
    }

    @NonNull
    public static BagValue.Accumulator createBagAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new BagValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static BagValue createBagOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new BagValueImpl(typeId, BagValueImpl.createBagOfEach(boxedValues));
    }

    @NonNull
    public static BagValue createBagRange(@NonNull CollectionTypeId typeId, Object ... values) {
        BagImpl<Object> allValues = new BagImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new BagValueImpl(typeId, (Bag<? extends Object>)allValues);
    }

    @NonNull
    public static BagValue createBagValue(@NonNull CollectionTypeId typeId, @NonNull Bag<? extends Object> boxedValues) {
        return new BagValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static CollectionValue.Accumulator createCollectionAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        CollectionTypeId collectionId = collectedId.getGeneralizedId();
        if (collectionId == TypeId.BAG) {
            return new BagValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.ORDERED_SET) {
            return new SparseOrderedSetValueImpl.Accumulator(collectedId);
        }
        if (collectionId == TypeId.SEQUENCE) {
            return new SparseSequenceValueImpl.Accumulator(collectedId);
        }
        return new SetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static InvalidValueException createInvalidValue(@NonNull Exception e) {
        if (e instanceof InvalidValueException) {
            return (InvalidValueException)e;
        }
        return new InvalidValueException(e);
    }

    @NonNull
    public static ObjectValue createObjectValue(@NonNull TypeId typeId, @NonNull Object object) {
        return new JavaObjectValueImpl(typeId, object);
    }

    @NonNull
    public static OrderedSetValue.Accumulator createOrderedSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseOrderedSetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static OrderedSetValue createOrderedSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, SparseOrderedSetValueImpl.createOrderedSetOfEach(boxedValues));
    }

    @NonNull
    public static OrderedSetValue createOrderedSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        OrderedSetImpl<Object> allValues = new OrderedSetImpl<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseOrderedSetValueImpl(typeId, allValues);
    }

    @NonNull
    public static OrderedSetValue createOrderedSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SparseOrderedSetValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static IntegerRange createRange(@NonNull IntegerValue firstInteger, @NonNull IntegerValue lastInteger) {
        return new IntegerRangeImpl(firstInteger, lastInteger);
    }

    @NonNull
    public static SequenceValue.Accumulator createSequenceAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SparseSequenceValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static SequenceValue createSequenceOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SparseSequenceValueImpl(typeId, SparseSequenceValueImpl.createSequenceOfEach(boxedValues));
    }

    @NonNull
    public static SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, @NonNull IntegerRange range) {
        return new RangeSequenceValueImpl(typeId, range);
    }

    @NonNull
    public static SequenceValue createSequenceRange(@NonNull CollectionTypeId typeId, Object ... values) {
        ArrayList<Object> allValues = new ArrayList<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SparseSequenceValueImpl(typeId, (List<? extends Object>)allValues);
    }

    @NonNull
    public static SequenceValue createSequenceValue(@NonNull CollectionTypeId typeId, @NonNull List<? extends Object> boxedValues) {
        return new SparseSequenceValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static SetValue.Accumulator createSetAccumulatorValue(@NonNull CollectionTypeId collectedId) {
        return new SetValueImpl.Accumulator(collectedId);
    }

    @NonNull
    public static SetValue createSetOfEach(@NonNull CollectionTypeId typeId, Object ... boxedValues) {
        return new SetValueImpl(typeId, SetValueImpl.createSetOfEach(boxedValues));
    }

    @NonNull
    public static SetValue createSetRange(@NonNull CollectionTypeId typeId, Object ... values) {
        HashSet<Object> allValues = new HashSet<Object>();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (value instanceof IntegerRange) {
                allValues.addAll((IntegerRange)value);
            } else {
                allValues.add(value);
            }
            ++n2;
        }
        return new SetValueImpl(typeId, allValues);
    }

    @NonNull
    public static SetValue createSetValue(@NonNull CollectionTypeId typeId, @NonNull Collection<? extends Object> boxedValues) {
        return new SetValueImpl(typeId, boxedValues);
    }

    @NonNull
    public static TupleValue createTupleValue(@NonNull TupleTypeId typeId, @NonNull Map<? extends TuplePartId, Object> values) {
        return new TupleValueImpl(typeId, values);
    }

    @NonNull
    public static TupleValue createTupleOfEach(@NonNull TupleTypeId typeId, Object ... values) {
        return new TupleValueImpl(typeId, values);
    }

    @Deprecated
    @NonNull
    public static TupleValue createTupleValue(@NonNull TupleTypeId typeId, Object ... values) {
        return ValuesUtil.createTupleOfEach(typeId, values);
    }

    @Deprecated
    @NonNull
    public static DomainType createTypeValue(@Nullable DomainType type) {
        if (type == null) {
            throw new InvalidValueException("null type", new Object[0]);
        }
        return type;
    }

    public static String getTypeName(@Nullable Object value) {
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Value) {
            return ((Value)value).getTypeId().getDisplayName();
        }
        if (value == null) {
            return "OclVoid";
        }
        return "Object";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean initAllStatics() {
        if (allStaticsInitialized) return false;
        Class<ValuesUtil> clazz = ValuesUtil.class;
        synchronized (ValuesUtil.class) {
            block4: {
                if (allStaticsInitialized) break block4;
                allStaticsInitialized = true;
                DomainParameterTypes.EMPTY_LIST.getClass();
                DomainTypeParameters.EMPTY_LIST.getClass();
                DomainModelManager.NULL.getClass();
                TemplateableId.NULL_TEMPLATEABLE_ID_ARRAY.getClass();
                TypeId.INTEGER.getClass();
                AbstractInheritance.initStatics();
                UnsupportedOperation.INSTANCE.getClass();
                EvaluatorMessages.InvalidOperation.getClass();
                new StatusCodes();
                AbstractInheritance.initStatics();
                DomainUtil.createNumberFromString("0");
                StandaloneProjectMap.initStatics();
                DomainSubstitutionLabelProvider.INSTANCE.getClass();
                ValuesPackage.eINSTANCE.getClass();
                CollectionValueImpl.initStatics();
                RealValueImpl.initStatics();
                // ** MonitorExit[var0] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static IntegerValue integerValueOf(int value) {
        if (value > -256 && value < 1025) {
            int index = value + 256;
            IntegerValue integerValue = INTEGER_VALUES[index];
            if (integerValue != null) {
                return integerValue;
            }
            IntegerValue[] integerValueArray = INTEGER_VALUES;
            synchronized (INTEGER_VALUES) {
                integerValue = INTEGER_VALUES[index];
                if (integerValue != null) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return integerValue;
                }
                ValuesUtil.INTEGER_VALUES[index] = new IntIntegerValueImpl(value);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return ValuesUtil.INTEGER_VALUES[index];
            }
        }
        return new IntIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(long value) {
        if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            return new IntIntegerValueImpl((int)value);
        }
        return new LongIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(@NonNull BigInteger value) {
        if (value.signum() >= 0) {
            if (value.compareTo(INTEGER_MAX_VALUE) <= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MAX_VALUE) <= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        } else {
            if (value.compareTo(INTEGER_MIN_VALUE) >= 0) {
                return new IntIntegerValueImpl(value.intValue());
            }
            if (value.compareTo(LONG_MIN_VALUE) >= 0) {
                return new LongIntegerValueImpl(value.longValue());
            }
        }
        return new BigIntegerValueImpl(value);
    }

    @NonNull
    public static IntegerValue integerValueOf(@NonNull Object aValue) {
        if (aValue instanceof BigInteger) {
            return new BigIntegerValueImpl((BigInteger)aValue);
        }
        if (aValue instanceof Unlimited) {
            return UNLIMITED_VALUE;
        }
        if (aValue instanceof Number) {
            return ValuesUtil.integerValueOf(((Number)aValue).longValue());
        }
        if (aValue instanceof Character) {
            return ValuesUtil.integerValueOf(((Character)aValue).charValue());
        }
        if (aValue instanceof IntegerValue) {
            return (IntegerValue)aValue;
        }
        throw new InvalidValueException(EvaluatorMessages.InvalidInteger, aValue);
    }

    @NonNull
    public static IntegerValue integerValueOf(@NonNull String aValue) {
        try {
            int len = aValue.length();
            if (len < maxLongSize || len == maxLongSize && maxLongValue.compareTo(aValue) >= 0) {
                BigInteger result = BigInteger.valueOf(Long.parseLong(aValue));
                return ValuesUtil.integerValueOf(result);
            }
            return ValuesUtil.integerValueOf(new BigInteger(aValue));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, EvaluatorMessages.InvalidInteger, aValue);
        }
    }

    public static boolean isBoxed(@Nullable Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof DomainEnumerationLiteral) {
            return false;
        }
        if (object instanceof EEnumLiteral) {
            return false;
        }
        if (object instanceof Number && !(object instanceof RealValue)) {
            return false;
        }
        return !(object instanceof Iterable) || object instanceof CollectionValue;
    }

    @Nullable
    public static CollectionValue isCollectionValue(@Nullable Object value) {
        if (value instanceof CollectionValue && !(value instanceof NullValue)) {
            return (CollectionValue)value;
        }
        return null;
    }

    public static IntegerValue isIntegerValue(@Nullable Object value) {
        if (value instanceof IntegerValue && !(value instanceof NullValue)) {
            return (IntegerValue)value;
        }
        return null;
    }

    public static boolean isUnboxed(Object object) {
        if (object instanceof NullValue) {
            return false;
        }
        if (object instanceof ElementId) {
            return false;
        }
        if (object instanceof RealValue) {
            return false;
        }
        return !(object instanceof CollectionValue);
    }

    public static boolean isUnlimited(@Nullable Object value) {
        return value instanceof UnlimitedValue && !(value instanceof NullValue);
    }

    @NonNull
    public static String oclToString(@NonNull Object value) {
        String result = value.toString();
        return result;
    }

    @NonNull
    public static RealValue realValueOf(double value) {
        return new RealValueImpl(value);
    }

    @NonNull
    public static RealValue realValueOf(@NonNull BigDecimal value) {
        return new RealValueImpl(value);
    }

    @NonNull
    public static RealValue realValueOf(@NonNull IntegerValue integerValue) {
        try {
            return ValuesUtil.realValueOf(integerValue.bigDecimalValue());
        }
        catch (InvalidValueException e) {
            throw new InvalidValueException(e, EvaluatorMessages.InvalidInteger, integerValue);
        }
    }

    @NonNull
    public static RealValue realValueOf(@NonNull Number aNumber) {
        if (aNumber instanceof BigDecimal) {
            return new RealValueImpl((BigDecimal)aNumber);
        }
        if (aNumber instanceof BigInteger) {
            return new RealValueImpl(new BigDecimal((BigInteger)aNumber));
        }
        if (aNumber instanceof Unlimited) {
            return new RealValueImpl(Double.POSITIVE_INFINITY);
        }
        return new RealValueImpl(aNumber.doubleValue());
    }

    @NonNull
    public static RealValue realValueOf(@NonNull String aValue) {
        try {
            return new RealValueImpl(new BigDecimal(aValue.trim()));
        }
        catch (NumberFormatException e) {
            throw new InvalidValueException(e, EvaluatorMessages.InvalidReal, aValue);
        }
    }

    @NonNull
    public static String stringValueOf(@Nullable Object aValue) {
        String stringValue = null;
        if (aValue == null) {
            stringValue = NULL_STRING;
        } else if (aValue instanceof String) {
            stringValue = "'" + DomainUtil.convertToOCLString((String)aValue) + "'";
        } else if (aValue instanceof EObject && !(aValue instanceof DomainElement) && !(aValue instanceof EEnumLiteral)) {
            stringValue = DomainUtil.getLabel((EObject)aValue);
        } else {
            if (aValue.getClass().isArray()) {
                throw new UnsupportedOperationException();
            }
            if (aValue instanceof Iterable) {
                throw new UnsupportedOperationException();
            }
            stringValue = String.valueOf(aValue);
        }
        return stringValue != null ? stringValue : "<<null>>";
    }

    public static Object throwInvalidValueException() {
        throw new InvalidValueException("invalid", new Object[0]);
    }

    public static void toString(@Nullable Object value, @NonNull StringBuilder s, int sizeLimit) {
        if (value instanceof Value) {
            ((Value)value).toString(s, sizeLimit);
        } else if (value instanceof String) {
            s.append("'");
            ValuesUtil.toStringWithLimit(s, (String)value, sizeLimit);
            s.append("'");
        } else if (value != null) {
            ValuesUtil.toStringWithLimit(s, value.toString(), sizeLimit);
        } else {
            ValuesUtil.toStringWithLimit(s, NULL_STRING, sizeLimit);
        }
    }

    private static void toStringWithLimit(@NonNull StringBuilder s, String string, int sizeLimit) {
        int available;
        int length = string.length();
        if (length <= (available = sizeLimit - (length + 1))) {
            s.append(string);
        } else {
            if (available > 0) {
                s.append(string.substring(0, available));
            }
            s.append("...");
        }
    }
}

