/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.library.string;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainCallExp;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.evaluation.DomainEvaluator;
import org.eclipse.ocl.examples.domain.ids.CollectionTypeId;
import org.eclipse.ocl.examples.domain.ids.TypeId;
import org.eclipse.ocl.examples.domain.library.AbstractPolyOperation;
import org.eclipse.ocl.examples.domain.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.SequenceValue;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;

public class StringTokenizeOperation
extends AbstractPolyOperation {
    @NonNull
    public static final StringTokenizeOperation INSTANCE = new StringTokenizeOperation();
    @NonNull
    private static final String DELIMS = " \t\n\r\f";

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, DELIMS, false);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object argumentValue) {
        boolean returnDelims = StringTokenizeOperation.asBoolean((Object)argumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, DELIMS, returnDelims);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull TypeId returnTypeId, @Nullable Object sourceValue, @Nullable Object firstArgumentValue, @Nullable Object secondArgumentValue) {
        String delims = StringTokenizeOperation.asString((Object)firstArgumentValue);
        boolean returnDelims = StringTokenizeOperation.asBoolean((Object)secondArgumentValue);
        return this.evaluate(evaluator, (CollectionTypeId)returnTypeId, sourceValue, delims, returnDelims);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull DomainCallExp callExp, @Nullable Object sourceValue, Object ... argumentValues) {
        String delims = DELIMS;
        boolean returnDelims = false;
        if (argumentValues.length > 0) {
            if (argumentValues.length > 1) {
                if (argumentValues.length > 2) {
                    throw new InvalidValueException(EvaluatorMessages.InvalidArgument, new Object[]{argumentValues[2]});
                }
                Object argumentValue1 = argumentValues[1];
                assert (argumentValue1 != null);
                returnDelims = StringTokenizeOperation.asBoolean((Object)argumentValue1);
            }
            Object argumentValue0 = argumentValues[0];
            assert (argumentValue0 != null);
            delims = StringTokenizeOperation.asString((Object)argumentValue0);
        }
        return this.evaluate(evaluator, (CollectionTypeId)((DomainType)DomainUtil.nonNullPivot((Object)callExp.getType())).getTypeId(), sourceValue, delims, returnDelims);
    }

    @NonNull
    public SequenceValue evaluate(@NonNull DomainEvaluator evaluator, @NonNull CollectionTypeId returnTypeId, @Nullable Object sourceValue, @NonNull String delims, boolean returnDelims) {
        String sourceString = StringTokenizeOperation.asString((Object)sourceValue);
        StringTokenizer tokenizer = new StringTokenizer(sourceString, delims, returnDelims);
        ArrayList<String> results = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            String nextToken = tokenizer.nextToken();
            results.add(nextToken);
        }
        return StringTokenizeOperation.createSequenceValue((CollectionTypeId)returnTypeId, results);
    }
}

