/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.OCLCommon;
import org.eclipse.ocl.common.delegate.VirtualDelegateMapping;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.validation.DomainSubstitutionLabelProvider;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCLExpression;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.context.ClassContext;
import org.eclipse.ocl.examples.pivot.context.DiagnosticContext;
import org.eclipse.ocl.examples.pivot.delegate.DelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.DelegateEPackageAdapter;
import org.eclipse.ocl.examples.pivot.delegate.DelegatedBehavior;
import org.eclipse.ocl.examples.pivot.delegate.InvocationBehavior;
import org.eclipse.ocl.examples.pivot.delegate.SettingBehavior;
import org.eclipse.ocl.examples.pivot.delegate.ValidationBehavior;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDelegatedBehavior<E extends EModelElement, R, F>
implements DelegatedBehavior<E, R, F> {
    private static List<DelegatedBehavior<?, ?, ?>> delegatedBehaviors = null;

    @NonNull
    public static List<DelegatedBehavior<?, ?, ?>> getDelegatedBehaviors() {
        List<DelegatedBehavior<?, ?, ?>> delegatedBehaviors2 = delegatedBehaviors;
        if (delegatedBehaviors2 == null) {
            delegatedBehaviors = new ArrayList();
            delegatedBehaviors2 = delegatedBehaviors;
            delegatedBehaviors2.add(InvocationBehavior.INSTANCE);
            delegatedBehaviors2.add(SettingBehavior.INSTANCE);
            delegatedBehaviors2.add(ValidationBehavior.INSTANCE);
        }
        return delegatedBehaviors2;
    }

    public List<DelegateDomain> getDelegateDomains(@NonNull E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<DelegateDomain> delegateDomains = new ArrayList<DelegateDomain>();
        for (DelegateDomain delegateDomain : adapter.getAllDelegateDomains()) {
            String uri = delegateDomain.getURI();
            if (!this.hasDelegateAnnotation(eObject, ePackage, uri)) continue;
            delegateDomains.add(delegateDomain);
        }
        return delegateDomains;
    }

    @Override
    @NonNull
    public List<F> getFactories(@NonNull E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        ArrayList<F> factories = new ArrayList<F>();
        for (DelegateDomain delegateDomain : adapter.getAllDelegateDomains()) {
            String uri = delegateDomain.getURI();
            if (!this.hasDelegateAnnotation(eObject, ePackage, uri)) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            if (factory == null || factories.contains(factory)) continue;
            factories.add(factory);
        }
        return factories;
    }

    @Nullable
    protected abstract F getFactory(@NonNull DelegateDomain var1, @NonNull E var2);

    @Override
    @Nullable
    public F getFactory(@NonNull E eObject) {
        EPackage ePackage = this.getEPackage(eObject);
        DelegateEPackageAdapter adapter = DelegateEPackageAdapter.getAdapter(ePackage);
        for (DelegateDomain delegateDomain : adapter.getAllDelegateDomains()) {
            String uri = delegateDomain.getURI();
            if (eObject.getEAnnotation(uri) == null) continue;
            F factory = this.getFactory(delegateDomain, eObject);
            if (factory == null) {
                factory = this.getDefaultFactory();
            }
            return factory;
        }
        return null;
    }

    protected ExpressionInOCL getExpressionInOCL(@NonNull ClassContext parserContext, @NonNull Constraint constraint) {
        OpaqueExpression valueSpecification = constraint.getSpecification();
        if (valueSpecification instanceof ExpressionInOCL) {
            return (ExpressionInOCL)valueSpecification;
        }
        if (valueSpecification != null) {
            try {
                String expression = PivotUtil.getBody(valueSpecification);
                if (expression != null) {
                    ExpressionInOCL expressionInOCL = parserContext.parse(expression);
                    constraint.setSpecification(expressionInOCL);
                    String message = PivotUtil.getMessage(valueSpecification);
                    if (message != null && message.length() > 0) {
                        DiagnosticContext messageContext = new DiagnosticContext(parserContext, constraint);
                        ExpressionInOCL resolveSpecification = messageContext.parse(message);
                        OCLExpression messageExpression = resolveSpecification.getBodyExpression();
                        TreeIterator tit = messageExpression.eAllContents();
                        while (tit.hasNext()) {
                            VariableExp variable;
                            EObject eObject = (EObject)tit.next();
                            if (!(eObject instanceof VariableExp) || (variable = (VariableExp)eObject).getReferredVariable() != resolveSpecification.getContextVariable()) continue;
                            variable.setReferredVariable(expressionInOCL.getContextVariable());
                        }
                        PivotUtil.setMessage(expressionInOCL, messageExpression, message);
                    }
                    return expressionInOCL;
                }
            }
            catch (ParserException e) {
                throw new OCLDelegateException(e.getLocalizedMessage(), (Exception)e);
            }
        }
        return null;
    }

    protected ExpressionInOCL getExpressionInOCL(@NonNull ClassContext parserContext, @NonNull OpaqueExpression specification) {
        if (specification instanceof ExpressionInOCL) {
            return (ExpressionInOCL)specification;
        }
        try {
            String expression = PivotUtil.getBody(specification);
            if (expression != null) {
                return parserContext.parse(expression);
            }
        }
        catch (ParserException e) {
            throw new OCLDelegateException(e.getLocalizedMessage(), (Exception)e);
        }
        return null;
    }

    private boolean hasDelegateAnnotation(@NonNull E eObject, @NonNull EPackage ePackage, @NonNull String uri) {
        VirtualDelegateMapping registry;
        String resolvedURI;
        if (eObject.getEAnnotation(uri) != null) {
            return true;
        }
        EAnnotation delegateAnnotation = OCLCommon.getDelegateAnnotation(eObject);
        return delegateAnnotation != null && uri.equals(resolvedURI = (String)(registry = VirtualDelegateMapping.getRegistry((EModelElement)ePackage)).getPreferredValue());
    }

    @Override
    public void setDelegates(@NonNull EPackage ePackage, @Nullable List<String> delegateURIs) {
        String name = this.getName();
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
        if (delegateURIs == null || delegateURIs.isEmpty()) {
            if (eAnnotation != null) {
                eAnnotation.getDetails().remove((Object)name);
            }
        } else {
            if (eAnnotation == null) {
                eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
                ePackage.getEAnnotations().add((Object)eAnnotation);
            }
            StringBuilder value = new StringBuilder();
            Iterator<String> i = delegateURIs.iterator();
            while (i.hasNext()) {
                value.append(i.next());
                if (!i.hasNext()) continue;
                value.append(' ');
            }
            eAnnotation.getDetails().put((Object)name, (Object)value.toString());
        }
    }

    public String toString() {
        return String.valueOf(this.getName()) + " => " + this.getFactoryClass().getName();
    }

    public void validate(EObject eObject) {
        Map validationContext = DomainSubstitutionLabelProvider.createDefaultContext((EValidator)Diagnostician.INSTANCE);
        BasicDiagnostic diagnostics = Diagnostician.INSTANCE.createDefaultDiagnostic(eObject);
        if (!Diagnostician.INSTANCE.validate(eObject, (DiagnosticChain)diagnostics, validationContext)) {
            StringBuilder s = null;
            for (Diagnostic diagnostic : diagnostics.getChildren()) {
                if (s == null) {
                    s = new StringBuilder();
                } else {
                    s.append("\n");
                }
                s.append(diagnostic.getMessage());
            }
            if (s != null) {
                throw new OCLDelegateException(s.toString());
            }
        }
    }
}

