/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.common.internal.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.domain.evaluation.DomainException;
import org.eclipse.ocl.examples.domain.utilities.DomainUtil;
import org.eclipse.ocl.examples.domain.values.impl.InvalidValueException;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Query;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.SettingBehavior;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.osgi.util.NLS;

public class OCLSettingDelegate
extends BasicSettingDelegate.Stateless {
    protected final OCLDelegateDomain delegateDomain;
    private Property property;
    private ExpressionInOCL specification;

    public OCLSettingDelegate(@NonNull OCLDelegateDomain delegateDomain, @NonNull EStructuralFeature structuralFeature) {
        super(structuralFeature);
        this.delegateDomain = delegateDomain;
    }

    protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
        try {
            OCL ocl = this.delegateDomain.getOCL();
            MetaModelManager metaModelManager = ocl.getEnvironment().getMetaModelManager();
            PivotIdResolver idResolver = metaModelManager.getIdResolver();
            ExpressionInOCL specification2 = this.specification;
            if (specification2 == null) {
                Property property2 = this.getProperty();
                specification2 = this.specification = SettingBehavior.INSTANCE.getExpressionInOCL(metaModelManager, property2);
                SettingBehavior.INSTANCE.validate(property2);
            }
            Query query = ocl.createQuery(specification2);
            Object result = query.evaluate(owner);
            return idResolver.unboxedValueOf(result);
        }
        catch (InvalidValueException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.property);
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
        catch (DomainException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)this.property);
            throw new OCLDelegateException(message, (Exception)((Object)e));
        }
    }

    @NonNull
    public Property getProperty() {
        Property property2 = this.property;
        if (property2 == null && (property2 = (this.property = this.delegateDomain.getPivot(Property.class, (EObject)DomainUtil.nonNullEMF((Object)this.eStructuralFeature)))) == null) {
            throw new OCLDelegateException("No pivot property for " + this.eStructuralFeature);
        }
        return property2;
    }

    protected boolean isSet(InternalEObject owner) {
        return false;
    }

    public String toString() {
        if (this.property != null) {
            return "<" + this.delegateDomain.getURI() + ":setting> " + this.property;
        }
        String name = String.valueOf(this.eStructuralFeature.getEContainingClass().getEPackage().getName()) + "::" + this.eStructuralFeature.getEContainingClass().getName() + "." + this.eStructuralFeature.getName();
        return "<" + this.delegateDomain.getURI() + ":setting> " + name;
    }
}

