/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.Import;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.Root;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.delegate.DelegateInstaller;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreDeclarationVisitor
extends AbstractExtendingVisitor<Object, Pivot2Ecore> {
    @NonNull
    protected final DelegateInstaller delegateInstaller;

    public Pivot2EcoreDeclarationVisitor(@NonNull Pivot2Ecore context) {
        super(context);
        this.delegateInstaller = context.getDelegateInstaller();
    }

    protected void copyClassifier(@NonNull EClassifier eClassifier, @NonNull Type pivotType) {
        this.copyNamedElement((ENamedElement)eClassifier, pivotType);
        this.copyTemplateSignature((List<ETypeParameter>)eClassifier.getETypeParameters(), pivotType);
        this.safeVisitAll((List)eClassifier.getEAnnotations(), (List<? extends Element>)pivotType.getOwnedAnnotation());
        if (pivotType.eIsSet((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME)) {
            eClassifier.setInstanceClassName(pivotType.getInstanceClassName());
        } else {
            eClassifier.eUnset((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
        }
        for (Constraint pivotInvariant : pivotType.getOwnedInvariant()) {
            if (pivotInvariant.isCallable()) continue;
            this.safeVisit(pivotInvariant);
        }
        this.delegateInstaller.installDelegates(eClassifier, pivotType);
    }

    protected void copyDataTypeOrEnum(@NonNull EDataType eDataType, @NonNull DataType pivotDataType) {
        this.copyClassifier((EClassifier)eDataType, pivotDataType);
        eDataType.setSerializable(pivotDataType.isSerializable());
    }

    protected void copyDetails(@NonNull EAnnotation eAnnotation, @NonNull Annotation pivotAnnotation) {
        this.copyModelElement((EModelElement)eAnnotation, pivotAnnotation);
        this.safeVisitAll((List)eAnnotation.getEAnnotations(), (List<? extends Element>)pivotAnnotation.getOwnedAnnotation());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetail()) {
            String name = pivotDetail.getName();
            String value = StringUtils.splice(pivotDetail.getValue(), (String)"");
            eAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyModelElement(@NonNull EModelElement eModelElement, @NonNull Element pivotModelElement) {
        ((Pivot2Ecore)this.context).putCreated(pivotModelElement, eModelElement);
        Pivot2Ecore.copyComments(eModelElement, pivotModelElement);
    }

    protected void copyNamedElement(@NonNull ENamedElement eNamedElement, @NonNull NamedElement pivotNamedElement) {
        this.copyModelElement((EModelElement)eNamedElement, pivotNamedElement);
        eNamedElement.setName(pivotNamedElement.getName());
    }

    protected void copyTemplateSignature(List<ETypeParameter> eTypeParameters, TemplateableElement pivotElement) {
        TemplateSignature templateSignature = pivotElement.getOwnedTemplateSignature();
        if (templateSignature != null) {
            List<TemplateParameter> parameters = templateSignature.getParameter();
            this.safeVisitAll(eTypeParameters, parameters);
        }
    }

    protected void copyTypedElement(@NonNull ETypedElement eTypedElement, @NonNull TypedMultiplicityElement pivotTypedElement) {
        this.copyNamedElement((ENamedElement)eTypedElement, pivotTypedElement);
        this.safeVisitAll((List)eTypedElement.getEAnnotations(), (List<? extends Element>)pivotTypedElement.getOwnedAnnotation());
        ((Pivot2Ecore)this.context).defer(pivotTypedElement);
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EObject visiting(@NonNull Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Declaration pass");
    }

    @Override
    public EObject visitAnnotation(@NonNull Annotation pivotAnnotation) {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(eAnnotation, pivotAnnotation);
        eAnnotation.setSource(pivotAnnotation.getName());
        this.safeVisitAll((List)eAnnotation.getContents(), (List<? extends Element>)pivotAnnotation.getOwnedContent());
        if (!pivotAnnotation.getReference().isEmpty()) {
            ((Pivot2Ecore)this.context).defer(pivotAnnotation);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(@NonNull Class pivotClass) {
        if (pivotClass.getTemplateBinding().size() > 0) {
            return null;
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotClass);
        eClass.setAbstract(pivotClass.isAbstract());
        eClass.setInterface(pivotClass.isInterface());
        ((Pivot2Ecore)this.context).defer(pivotClass);
        this.safeVisitAll((List)eClass.getEOperations(), (List<? extends Element>)pivotClass.getOwnedOperation());
        this.safeVisitAll((List)eClass.getEStructuralFeatures(), (List<? extends Element>)pivotClass.getOwnedAttribute());
        for (Constraint pivotInvariant : pivotClass.getOwnedInvariant()) {
            if (!pivotInvariant.isCallable()) continue;
            EOperation eOperation = Pivot2Ecore.createConstraintEOperation(pivotInvariant, pivotInvariant.getName());
            eClass.getEOperations().add((Object)eOperation);
            ((Pivot2Ecore)this.context).putCreated(pivotInvariant, (EModelElement)eOperation);
            this.copyConstraint((EModelElement)eOperation, pivotInvariant);
        }
        return eClass;
    }

    @Override
    public EObject visitConstraint(@NonNull Constraint pivotConstraint) {
        EModelElement eModelElement;
        Element eContainer = (Element)pivotConstraint.eContainer();
        if (eContainer != null && (eModelElement = ((Pivot2Ecore)this.context).getCreated(EModelElement.class, eContainer)) != null) {
            this.copyConstraint(eModelElement, pivotConstraint);
        }
        return null;
    }

    @Nullable
    protected EAnnotation copyConstraint(@NonNull EModelElement eModelElement, @NonNull Constraint pivotConstraint) {
        EAnnotation eAnnotation = this.delegateInstaller.createConstraintDelegate(eModelElement, pivotConstraint, ((Pivot2Ecore)this.context).getEcoreURI());
        if (eAnnotation != null) {
            if (eModelElement instanceof EOperation) {
                Pivot2Ecore.copyAnnotationComments(eAnnotation, pivotConstraint);
            } else {
                Pivot2Ecore.copyComments((EModelElement)eAnnotation, pivotConstraint);
            }
        }
        return eAnnotation;
    }

    @Override
    public EObject visitDataType(@NonNull DataType pivotDataType) {
        if (pivotDataType.getTemplateBinding().size() > 0) {
            return null;
        }
        EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.copyDataTypeOrEnum(eDataType, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitEnumeration(@NonNull Enumeration pivotEnumeration) {
        if (pivotEnumeration.getTemplateBinding().size() > 0) {
            return null;
        }
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.copyDataTypeOrEnum((EDataType)eEnum, pivotEnumeration);
        this.safeVisitAll((List)eEnum.getELiterals(), (List<? extends Element>)pivotEnumeration.getOwnedLiteral());
        return eEnum;
    }

    @Override
    public EObject visitEnumerationLiteral(@NonNull EnumerationLiteral pivotEnumLiteral) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        this.copyNamedElement((ENamedElement)eEnumLiteral, pivotEnumLiteral);
        if (pivotEnumLiteral.eIsSet((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE)) {
            eEnumLiteral.setValue(pivotEnumLiteral.getValue().intValue());
        } else {
            eEnumLiteral.eUnset((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE);
        }
        return eEnumLiteral;
    }

    @Override
    public EObject visitOperation(@NonNull Operation pivotOperation) {
        if (pivotOperation.getTemplateBinding().size() > 0) {
            return null;
        }
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        this.copyTypedElement((ETypedElement)eOperation, pivotOperation);
        this.copyTemplateSignature((List<ETypeParameter>)eOperation.getETypeParameters(), pivotOperation);
        this.safeVisitAll((List)eOperation.getEParameters(), (List<? extends Element>)pivotOperation.getOwnedParameter());
        OpaqueExpression bodyExpression = pivotOperation.getBodyExpression();
        if (bodyExpression != null) {
            this.delegateInstaller.installOperationDelegate(eOperation, bodyExpression, ((Pivot2Ecore)this.context).getEcoreURI());
        }
        for (Constraint pivotConstraint : pivotOperation.getPrecondition()) {
            this.safeVisit(pivotConstraint);
        }
        for (Constraint pivotConstraint : pivotOperation.getPostcondition()) {
            this.safeVisit(pivotConstraint);
        }
        return eOperation;
    }

    @Override
    public EObject visitPackage(@NonNull Package pivotPackage) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.copyNamedElement((ENamedElement)ePackage, pivotPackage);
        this.safeVisitAll((List)ePackage.getEAnnotations(), (List<? extends Element>)pivotPackage.getOwnedAnnotation());
        ((Pivot2Ecore)this.context).defer(pivotPackage);
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_PREFIX)) {
            ePackage.setNsPrefix(pivotPackage.getNsPrefix());
        }
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_URI)) {
            ePackage.setNsURI(pivotPackage.getNsURI());
        }
        this.safeVisitAll((List)ePackage.getESubpackages(), (List<? extends Element>)pivotPackage.getNestedPackage());
        this.safeVisitAll((List)ePackage.getEClassifiers(), (List<? extends Element>)pivotPackage.getOwnedType());
        return ePackage;
    }

    @Override
    public EObject visitParameter(@NonNull Parameter pivotParameter) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        this.copyTypedElement((ETypedElement)eParameter, pivotParameter);
        return eParameter;
    }

    @Override
    public EObject visitProperty(@NonNull Property pivotProperty) {
        EAttribute eStructuralFeature;
        if (pivotProperty.isImplicit()) {
            return null;
        }
        Type type = pivotProperty.getType();
        if (type instanceof CollectionType) {
            type = ((CollectionType)type).getElementType();
        }
        if (type instanceof DataType) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            eAttribute.setID(pivotProperty.isID());
            eStructuralFeature = eAttribute;
        } else {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
                ((Pivot2Ecore)this.context).defer(pivotProperty);
            }
            eReference.setContainment(pivotProperty.isComposite());
            eReference.setResolveProxies(pivotProperty.isResolveProxies());
            eStructuralFeature = eReference;
        }
        this.copyTypedElement((ETypedElement)eStructuralFeature, pivotProperty);
        eStructuralFeature.setChangeable(!pivotProperty.isReadOnly());
        eStructuralFeature.setDerived(pivotProperty.isDerived());
        eStructuralFeature.setTransient(pivotProperty.isTransient());
        eStructuralFeature.setUnsettable(pivotProperty.isUnsettable());
        eStructuralFeature.setVolatile(pivotProperty.isVolatile());
        if (pivotProperty.eIsSet((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT)) {
            eStructuralFeature.setDefaultValueLiteral(pivotProperty.getDefault());
        } else {
            eStructuralFeature.eUnset((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL);
        }
        OpaqueExpression defaultExpression = pivotProperty.getDefaultExpression();
        if (defaultExpression != null) {
            this.delegateInstaller.installPropertyDelegate((EStructuralFeature)eStructuralFeature, defaultExpression, ((Pivot2Ecore)this.context).getEcoreURI());
        }
        return eStructuralFeature;
    }

    @Override
    public Object visitRoot(@NonNull Root pivotRoot) {
        EAnnotation importAnnotation = null;
        EModelElement firstElement = null;
        ArrayList<EObject> outputObjects = new ArrayList<EObject>();
        for (Package pivotObject : pivotRoot.getNestedPackage()) {
            Object ecoreObject = this.safeVisit(pivotObject);
            if (!(ecoreObject instanceof EObject)) continue;
            outputObjects.add((EObject)ecoreObject);
            if (!(ecoreObject instanceof EModelElement)) continue;
            firstElement = (EModelElement)ecoreObject;
        }
        for (Import anImport : pivotRoot.getImports()) {
            Namespace importedNamespace;
            if (importAnnotation == null) {
                importAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                importAnnotation.setSource("http://www.eclipse.org/OCL/Import");
            }
            if ((importedNamespace = anImport.getImportedNamespace()) == null) continue;
            EObject eTarget = importedNamespace.getETarget();
            URI uri = EcoreUtil.getURI((EObject)eTarget);
            URI uri2 = uri.deresolve(((Pivot2Ecore)this.context).getEcoreURI());
            importAnnotation.getDetails().put((Object)anImport.getName(), (Object)uri2.toString());
        }
        if (firstElement != null && importAnnotation != null) {
            firstElement.getEAnnotations().add(importAnnotation);
        }
        return outputObjects;
    }

    @Override
    public EObject visitTypeTemplateParameter(@NonNull TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        eTypeParameter.setName(((Type)pivotTypeTemplateParameter.getParameteredElement()).getName());
        ((Pivot2Ecore)this.context).putCreated(pivotTypeTemplateParameter, (EModelElement)eTypeParameter);
        if (!pivotTypeTemplateParameter.getConstrainingType().isEmpty()) {
            ((Pivot2Ecore)this.context).defer(pivotTypeTemplateParameter);
        }
        return eTypeParameter;
    }
}

