/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainInheritance;
import org.eclipse.ocl.examples.domain.elements.DomainPackage;
import org.eclipse.ocl.examples.domain.elements.DomainStandardLibrary;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.ids.PackageId;
import org.eclipse.ocl.examples.library.executor.ReflectivePackage;
import org.eclipse.ocl.examples.pivot.AnyType;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.ElementExtension;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.manager.AnyTypeServer;
import org.eclipse.ocl.examples.pivot.manager.CollectionTypeServer;
import org.eclipse.ocl.examples.pivot.manager.EnumerationTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ExtensibleTypeServer;
import org.eclipse.ocl.examples.pivot.manager.ExtensionTypeServer;
import org.eclipse.ocl.examples.pivot.manager.InvalidTypeServer;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.MetaclassServer;
import org.eclipse.ocl.examples.pivot.manager.NestedPackageServer;
import org.eclipse.ocl.examples.pivot.manager.PackageManager;
import org.eclipse.ocl.examples.pivot.manager.PackageServerParent;
import org.eclipse.ocl.examples.pivot.manager.PackageTracker;
import org.eclipse.ocl.examples.pivot.manager.TemplateableTypeServer;
import org.eclipse.ocl.examples.pivot.manager.TypeServer;
import org.eclipse.ocl.examples.pivot.manager.VoidTypeServer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PackageServer
extends ReflectivePackage
implements PackageServerParent {
    @Nullable
    private Map<String, NestedPackageServer> packageServers = null;
    @NonNull
    protected final PackageManager packageManager;
    @NonNull
    private final List<PackageTracker> trackers = new ArrayList<PackageTracker>();
    @Nullable
    private Map<String, TypeServer> typeServers = null;
    @Nullable
    private Package representativePackage = null;

    protected PackageServer(@NonNull PackageManager packageManager, @NonNull String name, @Nullable String nsPrefix, @Nullable String nsURI, @NonNull PackageId packageId) {
        super(name, nsPrefix, nsURI, packageId);
        this.packageManager = packageManager;
    }

    void addedMemberType(@NonNull DomainType pivotType) {
        if (pivotType instanceof LambdaType || pivotType instanceof TupleType) {
            return;
        }
        if (this.typeServers != null) {
            this.getTypeServer(pivotType);
        }
    }

    @NonNull
    public PackageTracker addTrackedPackage(@NonNull DomainPackage pivotPackage) {
        PackageTracker packageTracker = this.packageManager.findPackageTracker(pivotPackage);
        if (packageTracker == null) {
            packageTracker = new PackageTracker(this, pivotPackage);
            this.packageManager.addPackageTracker(pivotPackage, packageTracker);
            if (this.typeServers != null) {
                this.initMemberTypes(pivotPackage);
            }
            this.initMemberPackages(pivotPackage);
        }
        if (!this.trackers.contains(packageTracker)) {
            this.trackers.add(packageTracker);
            this.representativePackage = null;
        }
        return packageTracker;
    }

    public void addedMemberPackage(@NonNull DomainPackage pivotPackage) {
        NestedPackageServer packageServer = this.getMemberPackageServer(pivotPackage);
        packageServer.addTrackedPackage(pivotPackage);
    }

    @NonNull
    protected DomainInheritance createExecutorType(@NonNull DomainType domainType) {
        return this.getTypeServer(domainType);
    }

    protected void dispose() {
        Map<String, NestedPackageServer> packageServers2;
        Map<String, TypeServer> typeServers2;
        if (!this.trackers.isEmpty()) {
            ArrayList<PackageTracker> savedPackageTrackers = new ArrayList<PackageTracker>(this.trackers);
            this.trackers.clear();
            for (PackageTracker tracker : savedPackageTrackers) {
                tracker.dispose();
            }
        }
        if ((typeServers2 = this.typeServers) != null) {
            ArrayList<TypeServer> savedTypeServers = new ArrayList<TypeServer>(typeServers2.values());
            typeServers2.clear();
            for (TypeServer typeServer : savedTypeServers) {
                typeServer.dispose();
            }
            this.typeServers = null;
        }
        if ((packageServers2 = this.packageServers) != null) {
            ArrayList<NestedPackageServer> savedPackageServers = new ArrayList<NestedPackageServer>(packageServers2.values());
            packageServers2.clear();
            for (NestedPackageServer packageServer : savedPackageServers) {
                packageServer.dispose();
            }
            this.packageServers = null;
        }
    }

    public void disposedNestedPackageServer(@NonNull NestedPackageServer packageServer) {
        Map<String, NestedPackageServer> packageServers2 = this.packageServers;
        if (packageServers2 != null) {
            packageServers2.remove(packageServer.getName());
        }
        this.packageManager.disposedPackageServer(packageServer.getNsURI());
    }

    void disposedPackageTracker(@NonNull PackageTracker packageTracker) {
        this.trackers.remove(packageTracker);
        this.representativePackage = null;
        if (this.trackers.size() <= 0) {
            this.dispose();
        }
        this.packageManager.disposedPackageTracker(packageTracker);
    }

    void disposedTypeServer(@NonNull TypeServer typeServer) {
        Map<String, TypeServer> typeServers2 = this.typeServers;
        if (typeServers2 != null) {
            typeServers2.remove(typeServer.getName());
        }
    }

    @Nullable
    public Package findPivotPackage() {
        for (PackageTracker packageTracker : this.trackers) {
            DomainPackage trackedPackage = packageTracker.getPackage();
            if (!(trackedPackage instanceof Package)) continue;
            return (Package)trackedPackage;
        }
        return null;
    }

    @NonNull
    protected Iterable<? extends DomainType> getDomainTypes() {
        return this.getMemberTypes();
    }

    public EPackage getEPackage() {
        for (PackageTracker packageTracker : this.trackers) {
            Package pivotPackage;
            EObject eTarget;
            DomainPackage target = packageTracker.getPackage();
            if (!(target instanceof Package) || !((eTarget = (pivotPackage = (Package)target).getETarget()) instanceof EPackage)) continue;
            return (EPackage)eTarget;
        }
        return null;
    }

    @Nullable
    public NestedPackageServer getMemberPackage(@NonNull String memberPackageName) {
        Map<String, NestedPackageServer> packageServers2 = this.packageServers;
        if (packageServers2 == null) {
            return null;
        }
        return packageServers2.get(memberPackageName);
    }

    @Override
    @NonNull
    public NestedPackageServer getMemberPackageServer(@NonNull DomainPackage pivotPackage) {
        String name;
        Map<String, NestedPackageServer> packageServers2 = this.packageServers;
        if (packageServers2 == null) {
            packageServers2 = this.packageServers = new HashMap<String, NestedPackageServer>();
        }
        if ((name = pivotPackage.getName()) == null) {
            throw new IllegalStateException("Unnamed package");
        }
        NestedPackageServer packageServer = packageServers2.get(name);
        if (packageServer == null) {
            String nsPrefix = pivotPackage.getNsPrefix();
            String nsURI = pivotPackage.getNsURI();
            packageServer = new NestedPackageServer(this, name, nsPrefix, nsURI, pivotPackage.getPackageId());
            packageServers2.put(name, packageServer);
            if (nsURI != null) {
                this.packageManager.addPackageServer(packageServer);
            }
        }
        return packageServer;
    }

    @Nullable
    public NestedPackageServer getMemberPackageServer(@NonNull String name) {
        Map<String, NestedPackageServer> packageServers2 = this.packageServers;
        return packageServers2 != null ? packageServers2.get(name) : null;
    }

    @NonNull
    public List<NestedPackageServer> getMemberPackages() {
        Map<String, NestedPackageServer> packageServers2 = this.packageServers;
        if (packageServers2 == null) {
            return NestedPackageServer.EMPTY_LIST;
        }
        ArrayList<NestedPackageServer> values = new ArrayList<NestedPackageServer>(packageServers2.values());
        return values;
    }

    public Type getMemberType(String typeName) {
        TypeServer typeServer;
        Map<String, TypeServer> typeServers2 = this.typeServers;
        if (typeServers2 == null) {
            typeServers2 = this.initMemberTypes();
        }
        return (typeServer = typeServers2.get(typeName)) != null ? typeServer.getPivotType() : null;
    }

    @NonNull
    public Iterable<TypeServer> getMemberTypes() {
        Map<String, TypeServer> typeServers2 = this.typeServers;
        if (typeServers2 == null) {
            typeServers2 = this.initMemberTypes();
        }
        Collection<TypeServer> values = typeServers2.values();
        return values;
    }

    @NonNull
    public MetaModelManager getMetaModelManager() {
        return this.packageManager.getMetaModelManager();
    }

    public List<NestedPackageServer> getNestedPackage() {
        return this.getMemberPackages();
    }

    @NonNull
    public final PackageManager getPackageManager() {
        return this.packageManager;
    }

    @NonNull
    public PackageTracker getPackageTracker(@NonNull DomainPackage pivotPackage) {
        for (PackageTracker packageTracker : this.trackers) {
            if (packageTracker.getPackage() != pivotPackage) continue;
            return packageTracker;
        }
        return this.addTrackedPackage(pivotPackage);
    }

    @NonNull
    PackageServerParent getParentPackageServer(@NonNull DomainPackage pivotPackage) {
        DomainPackage pivotPackageParent = pivotPackage.getNestingPackage();
        if (pivotPackageParent == null) {
            return this;
        }
        PackageTracker parentTracker = this.getPackageTracker(pivotPackageParent);
        return parentTracker.getPackageServer();
    }

    @NonNull
    public Iterable<DomainPackage> getPartialPackages() {
        return Iterables.transform(this.trackers, PackageTracker.tracker2package);
    }

    @NonNull
    public Package getPivotPackage() {
        Package representativePackage2 = this.representativePackage;
        if (representativePackage2 == null && (representativePackage2 = (this.representativePackage = this.findPivotPackage())) == null) {
            throw new IllegalStateException("Missing pivot package");
        }
        return representativePackage2;
    }

    @NonNull
    protected DomainStandardLibrary getStandardLibrary() {
        return this.packageManager.getMetaModelManager();
    }

    @NonNull
    TypeServer getTypeServer(@NonNull DomainType pivotType) {
        String name;
        assert (!(pivotType instanceof Type) || pivotType instanceof Metaclass || ((Type)pivotType).getUnspecializedElement() == null);
        Map<String, TypeServer> typeServers2 = this.typeServers;
        if (typeServers2 == null) {
            typeServers2 = this.initMemberTypes();
        }
        if ((name = pivotType.getName()) == null) {
            throw new IllegalStateException("Unnamed type");
        }
        TypeServer typeServer = typeServers2.get(name);
        if (typeServer == null) {
            typeServer = pivotType instanceof InvalidType ? new InvalidTypeServer(this, (InvalidType)pivotType) : (pivotType instanceof VoidType ? new VoidTypeServer(this, (VoidType)pivotType) : (pivotType instanceof AnyType ? new AnyTypeServer(this, (AnyType)pivotType) : (pivotType instanceof Enumeration ? new EnumerationTypeServer(this, (Enumeration)pivotType) : (pivotType instanceof CollectionType ? new CollectionTypeServer(this, (CollectionType)pivotType) : (pivotType instanceof PrimitiveType ? this.packageManager.getPrimitiveTypeServer((PrimitiveType)pivotType) : (pivotType instanceof Metaclass ? new MetaclassServer(this, (Metaclass)pivotType) : (pivotType instanceof ElementExtension ? new ExtensionTypeServer(this, (ElementExtension)pivotType) : new TemplateableTypeServer(this, pivotType))))))));
            if (pivotType instanceof Type && ((Type)pivotType).getUnspecializedElement() == null) {
                typeServers2.put(name, typeServer);
            }
        }
        if (typeServer instanceof ExtensibleTypeServer) {
            ((ExtensibleTypeServer)typeServer).getTypeTracker(pivotType);
        }
        return typeServer;
    }

    private void initMemberPackages(@NonNull DomainPackage pivotPackage) {
        for (DomainPackage nestedPackage : pivotPackage.getNestedPackage()) {
            if (nestedPackage == null) continue;
            this.addedMemberPackage(nestedPackage);
        }
    }

    @NonNull
    private Map<String, TypeServer> initMemberTypes() {
        Map<String, TypeServer> typeServers2 = this.typeServers;
        if (typeServers2 == null) {
            typeServers2 = this.typeServers = new HashMap<String, TypeServer>();
            if (!"http://www.eclipse.org/ocl/3.1.0/orphanage".equals(this.nsURI)) {
                for (PackageTracker packageTracker : this.trackers) {
                    this.initMemberTypes(packageTracker.getPackage());
                }
            }
        }
        return typeServers2;
    }

    private void initMemberTypes(@NonNull DomainPackage pivotPackage) {
        for (DomainType pivotType : pivotPackage.getOwnedType()) {
            if (pivotType == null) continue;
            this.addedMemberType(pivotType);
        }
    }

    void removedMemberPackage(@NonNull DomainPackage pivotPackage) {
        this.packageManager.removedPackage(pivotPackage);
    }

    void removedMemberType(@NonNull DomainType pivotType) {
        this.packageManager.removedType(pivotType);
    }

    public String toString() {
        if (this.trackers.size() > 0) {
            return String.valueOf(this.trackers.get(0).getPackage());
        }
        return "<<null>>";
    }
}

