/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.manager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.domain.elements.DomainType;
import org.eclipse.ocl.examples.domain.elements.DomainTypedElement;
import org.eclipse.ocl.examples.domain.ids.TemplateParameterId;
import org.eclipse.ocl.examples.domain.types.IdResolver;
import org.eclipse.ocl.examples.library.ecore.EcoreExecutorManager;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.Metaclass;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotTables;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.manager.PivotIdResolver;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateParameterSubstitutionVisitor
extends AbstractExtendingVisitor<Object, Map<TemplateParameter, List<DomainType>>> {
    private final MetaModelManager metaModelManager;
    private final Type selfType;
    private Map<Integer, List<TemplateParameter>> indexedTemplateParameters = null;
    private DomainType actual;

    public TemplateParameterSubstitutionVisitor(MetaModelManager metaModelManager, Type selfType) {
        super(new HashMap());
        this.metaModelManager = metaModelManager;
        this.selfType = selfType;
    }

    @Nullable
    public DomainType specialize(@Nullable TemplateParameter templateParameter) {
        if (templateParameter == null) {
            return null;
        }
        List list = (List)((Map)this.context).get(templateParameter);
        if (list == null) {
            return null;
        }
        int iMax = list.size();
        if (iMax < 1) {
            return null;
        }
        if (iMax == 1) {
            return (DomainType)list.get(0);
        }
        DomainType bestType = (DomainType)list.get(0);
        if (iMax > 1) {
            PivotIdResolver idResolver = null;
            if (this.metaModelManager != null) {
                idResolver = this.metaModelManager.getIdResolver();
            }
            if (idResolver == null) {
                EcoreExecutorManager evaluator = new EcoreExecutorManager((Object)templateParameter, PivotTables.LIBRARY);
                idResolver = evaluator.getIdResolver();
            }
            int i = 1;
            while (i < iMax) {
                DomainType commonType;
                DomainType anotherType = (DomainType)list.get(i);
                bestType = commonType = bestType.getCommonType((IdResolver)idResolver, anotherType);
                if (this.metaModelManager != null) {
                    bestType = this.metaModelManager.getType(bestType);
                }
                ++i;
            }
        }
        return bestType;
    }

    @NonNull
    public DomainType specialize(@NonNull TemplateableElement templateableElement) {
        HashMap<TemplateParameter, ParameterableElement> usageBindings = new HashMap<TemplateParameter, ParameterableElement>();
        for (TemplateParameter templateParameter : ((Map)this.context).keySet()) {
            DomainType specialize = this.specialize(templateParameter);
            if (specialize == null) continue;
            Type specialized = this.metaModelManager.getType(specialize);
            usageBindings.put(templateParameter, specialized);
        }
        return this.metaModelManager.getSpecializedType((Type)templateableElement, usageBindings);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        for (TemplateParameter templateParameter : ((Map)this.context).keySet()) {
            if (!isFirst) {
                s.append("\n");
            }
            s.append(templateParameter + " => " + ((Map)this.context).get(templateParameter));
            isFirst = false;
        }
        if (this.indexedTemplateParameters != null) {
            for (Integer index : this.indexedTemplateParameters.keySet()) {
                s.append("\n");
                s.append(index + " => " + this.indexedTemplateParameters.get(index));
            }
        }
        return s.toString();
    }

    protected void visit(@Nullable TypedElement formalElement, @Nullable DomainTypedElement actualElement) {
        if (formalElement != null && actualElement != null) {
            Type formalType = formalElement.getType();
            DomainType actualType = actualElement.getType();
            this.visit(formalType, actualType);
        }
    }

    protected void visit(@Nullable Type formalType, @Nullable DomainTypedElement actualElement) {
        if (actualElement != null) {
            DomainType actualType = actualElement.getType();
            this.visit(formalType, actualType);
        }
    }

    protected void visit(@Nullable Type newFormal, @Nullable DomainType newActual) {
        if (newFormal != null && newActual != null) {
            DomainType oldActual = this.actual;
            try {
                this.actual = newActual;
                newFormal.accept(this);
            }
            finally {
                this.actual = oldActual;
            }
        }
    }

    protected void visitAllTypes(@NonNull List<? extends Type> formalElements, @NonNull List<? extends DomainType> actualElements) {
        int iMax = Math.min(formalElements.size(), actualElements.size());
        int i = 0;
        while (i < iMax) {
            this.visit(formalElements.get(i), actualElements.get(i));
            ++i;
        }
    }

    protected void visitAllTypedElements(@NonNull List<? extends TypedElement> formalElements, @Nullable List<? extends DomainTypedElement> actualElements) {
        if (actualElements != null) {
            int iMax = Math.min(formalElements.size(), actualElements.size());
            int i = 0;
            while (i < iMax) {
                TypedElement formalElement = formalElements.get(i);
                DomainTypedElement actualElement = actualElements.get(i);
                this.visit(formalElement, actualElement);
                ++i;
            }
        }
    }

    @Override
    public String visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unsupported " + this.getClass().getSimpleName() + " " + visitable.getClass().getSimpleName());
    }

    @Override
    @Nullable
    public Object visitClass(@NonNull Class object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            owningTemplateParameter.accept(this);
            return null;
        }
        return super.visitClass(object);
    }

    @Override
    @Nullable
    public Object visitCollectionType(@NonNull CollectionType object) {
        if (this.actual instanceof CollectionType) {
            Type formalElementType = object.getElementType();
            Type actualElementType = ((CollectionType)this.actual).getElementType();
            this.visit(formalElementType, actualElementType);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitIterateExp(@NonNull IterateExp object) {
        Iteration referredIteration = object.getReferredIteration();
        this.visit(referredIteration, (DomainTypedElement)object);
        this.visit(referredIteration.getOwningType(), (DomainTypedElement)object.getSource());
        this.visitAllTypedElements(referredIteration.getOwnedIterator(), object.getIterator());
        this.visitAllTypedElements(referredIteration.getOwnedAccumulator(), Collections.singletonList(object.getResult()));
        this.visitAllTypedElements(referredIteration.getOwnedParameter(), Collections.singletonList(object.getBody()));
        return null;
    }

    @Override
    @Nullable
    public Object visitIteratorExp(@NonNull IteratorExp object) {
        Iteration referredIteration = object.getReferredIteration();
        this.visit(referredIteration, (DomainTypedElement)object);
        this.visit(referredIteration.getOwningType(), (DomainTypedElement)object.getSource());
        this.visitAllTypedElements(referredIteration.getOwnedIterator(), object.getIterator());
        this.visitAllTypedElements(referredIteration.getOwnedParameter(), Collections.singletonList(object.getBody()));
        return null;
    }

    @Override
    @Nullable
    public Object visitLambdaType(@NonNull LambdaType object) {
        if (this.actual instanceof LambdaType) {
            LambdaType actualLambdaType = (LambdaType)this.actual;
            this.visit(object.getContextType(), actualLambdaType.getContextType());
            this.visit(object.getResultType(), actualLambdaType.getResultType());
            this.visitAllTypes(object.getParameterType(), actualLambdaType.getParameterType());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitMetaclass(@NonNull Metaclass object) {
        if (this.actual instanceof Metaclass) {
            Type formalElementType = object.getInstanceType();
            Type actualElementType = ((Metaclass)this.actual).getInstanceType();
            this.visit(formalElementType, actualElementType);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = object.getReferredOperation();
        this.visit(referredOperation, (DomainTypedElement)object);
        this.visit(referredOperation.getOwningType(), (DomainTypedElement)object.getSource());
        this.visitAllTypedElements(referredOperation.getOwnedParameter(), object.getArgument());
        return null;
    }

    @Override
    @Nullable
    public Object visitPrimitiveType(@NonNull PrimitiveType object) {
        return null;
    }

    @Override
    @Nullable
    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property referredProperty = object.getReferredProperty();
        this.visit(referredProperty, (DomainTypedElement)object);
        this.visit(referredProperty.getOwningType(), (DomainTypedElement)object.getSource());
        return null;
    }

    @Override
    @Nullable
    public Object visitSelfType(@NonNull SelfType object) {
        this.visit(this.selfType, this.actual);
        return null;
    }

    @Override
    @Nullable
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        int index;
        List<TemplateParameter> indexList;
        TemplateParameterId elementId = object.getElementId();
        ArrayList<DomainType> actualList = (ArrayList<DomainType>)((Map)this.context).get(object);
        if (actualList == null) {
            actualList = new ArrayList<DomainType>();
            ((Map)this.context).put(object, actualList);
        }
        if (!actualList.contains(this.actual)) {
            actualList.add(this.actual);
        }
        if (this.indexedTemplateParameters == null) {
            this.indexedTemplateParameters = new HashMap<Integer, List<TemplateParameter>>();
        }
        if ((indexList = this.indexedTemplateParameters.get(index = elementId.getIndex())) == null) {
            indexList = new ArrayList<TemplateParameter>();
            this.indexedTemplateParameters.put(index, indexList);
        }
        if (!indexList.contains(object)) {
            indexList.add(object);
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitTupleType(@NonNull TupleType object) {
        if (this.actual instanceof TupleType) {
            this.visitAllTypedElements(object.getOwnedAttribute(), ((TupleType)this.actual).getOwnedAttribute());
        }
        return null;
    }

    @Override
    @Nullable
    public Object visitType(@NonNull Type object) {
        for (TemplateBinding templateBinding : object.getTemplateBinding()) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitution()) {
                this.safeVisit(templateParameterSubstitution.getActual());
            }
        }
        return null;
    }
}

