/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainElement;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.SelfType;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.xtext.essentialocl.attributes.AbstractOperationFilter;

public class BinaryOperationFilter
extends AbstractOperationFilter {
    @NonNull
    protected final Type argumentType;

    public BinaryOperationFilter(@NonNull Type sourceType, @NonNull Type argumentType) {
        super(sourceType);
        this.argumentType = argumentType;
    }

    public boolean matches(@NonNull EnvironmentView environmentView, @NonNull DomainElement eObject) {
        if (eObject instanceof Iteration) {
            return false;
        }
        if (eObject instanceof Operation) {
            Map<TemplateParameter, ParameterableElement> bindings;
            Operation candidateOperation = (Operation)eObject;
            List candidateParameters = candidateOperation.getOwnedParameter();
            if (candidateParameters.size() != 1) {
                return false;
            }
            Parameter candidateParameter = (Parameter)candidateParameters.get(0);
            Type candidateType = candidateParameter.getType();
            if (candidateType instanceof SelfType) {
                candidateType = candidateOperation.getOwningType();
            }
            if (candidateType == null) {
                return false;
            }
            MetaModelManager metaModelManager = environmentView.getMetaModelManager();
            if (!metaModelManager.conformsTo(this.argumentType, candidateType, bindings = this.getOperationBindings(metaModelManager, candidateOperation))) {
                return false;
            }
            if (bindings != null) {
                this.installBindings(environmentView, eObject, bindings);
            }
            return true;
        }
        return false;
    }
}

