/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.attributes;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.domain.elements.DomainNamedElement;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOCL;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.context.ParserContext;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.pivot.scoping.EnvironmentView;
import org.eclipse.ocl.examples.pivot.scoping.ScopeView;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.BaseResource;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.xtext.base.scoping.AbstractRootCSAttribution;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;

public class ContextCSAttribution
extends AbstractRootCSAttribution {
    @NonNull
    public static final ContextCSAttribution INSTANCE = new ContextCSAttribution();

    public ScopeView computeLookup(@NonNull EObject target, @NonNull EnvironmentView environmentView, @NonNull ScopeView scopeView) {
        URI nonPivotBaseURI;
        String nonPivotScheme;
        URI baseURI;
        Resource eResource;
        MetaModelManager metaModelManager = environmentView.getMetaModelManager();
        ContextCS targetElement = (ContextCS)target;
        ExpressionInOCL pivot = (ExpressionInOCL)PivotUtil.getPivot(ExpressionInOCL.class, (Pivotable)targetElement);
        if (pivot != null && pivot.getContextVariable() != null && pivot.getContextVariable().getType() != null) {
            Variable resultVariable = pivot.getResultVariable();
            if (resultVariable != null) {
                environmentView.addNamedElement((DomainNamedElement)resultVariable);
            }
            for (Variable parameterVariable : pivot.getParameterVariable()) {
                assert (parameterVariable != null);
                environmentView.addNamedElement((DomainNamedElement)parameterVariable);
            }
            Variable contextVariable = pivot.getContextVariable();
            if (contextVariable != null) {
                Type type;
                environmentView.addNamedElement((DomainNamedElement)contextVariable);
                if (!environmentView.hasFinalResult() && (type = contextVariable.getType()) != null) {
                    environmentView.addAllElements(type, scopeView);
                }
            }
        } else {
            Type contextType;
            ParserContext parserContext;
            Resource resource = target.eResource();
            if (resource instanceof BaseResource && (parserContext = ((BaseResource)resource).getParserContext()) != null && (contextType = parserContext.getClassContext()) != null) {
                environmentView.computeLookups((Element)contextType, null);
            }
        }
        if (!environmentView.hasFinalResult()) {
            environmentView.addRootPackages();
        }
        if (pivot != null && !environmentView.hasFinalResult() && (eResource = pivot.eResource()) != null && (baseURI = eResource.getURI()) != null && (nonPivotScheme = (nonPivotBaseURI = PivotUtil.getNonPivotURI((URI)baseURI)).scheme()) != null && !"null".equals(nonPivotScheme)) {
            environmentView.addImportedElement(baseURI);
        }
        if (!environmentView.hasFinalResult()) {
            environmentView.addElementsOfScope((Element)metaModelManager.getOclAnyType().getPackage(), scopeView);
        }
        return super.computeLookup((EObject)targetElement, environmentView, scopeView);
    }
}

