/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.serializer;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Comment;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.RootCS;
import org.eclipse.ocl.examples.xtext.essentialocl.services.EssentialOCLGrammarAccess;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.serializer.sequencer.HiddenTokenSequencer;

public class EssentialOCLHiddenTokenSequencer
extends HiddenTokenSequencer {
    @Inject
    private EssentialOCLGrammarAccess grammarAccess;
    private static List<String> indents = new ArrayList<String>();

    protected void emitComments(EObject semanticChild) {
        List ownedComment;
        Element pivot;
        if (semanticChild instanceof ModelElementCS && (pivot = ((ModelElementCS)semanticChild).getPivot()) != null && (ownedComment = pivot.getOwnedComment()).size() > 0) {
            String commentIndent = this.getCommentIndent(semanticChild);
            TerminalRule ml_COMMENTRule = this.grammarAccess.getML_COMMENTRule();
            for (Comment comment : ownedComment) {
                String indentedBody = comment.getBody().replaceAll("\\n", "\n" + commentIndent + " * ");
                String body = "/*\n" + commentIndent + " * " + indentedBody + "\n" + commentIndent + " */";
                this.delegate.acceptComment((AbstractRule)ml_COMMENTRule, body, null);
            }
        }
    }

    public boolean enterAssignedAction(Action action, EObject semanticChild, ICompositeNode node) {
        this.emitComments(semanticChild);
        return super.enterAssignedAction(action, semanticChild, node);
    }

    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject semanticChild, ICompositeNode node) {
        if (!super.enterAssignedParserRuleCall(rc, semanticChild, node)) {
            return false;
        }
        this.emitComments(semanticChild);
        return true;
    }

    protected String getCommentIndent(EObject semanticChild) {
        int i = 0;
        EObject eObject = semanticChild;
        while (eObject != null) {
            EObject eContainer = eObject.eContainer();
            if (eContainer instanceof RootCS) break;
            eObject = eContainer;
            ++i;
        }
        if (i >= indents.size()) {
            int j = indents.size();
            while (j <= i) {
                if (j == 0) {
                    indents.add("");
                } else {
                    indents.add(String.valueOf(indents.get(j - 1)) + "\t");
                }
                ++j;
            }
        }
        return indents.get(i);
    }
}

