/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.generation.layout;

import java.util.List;
import org.eclipse.papyrus.customization.properties.generation.Activator;
import org.eclipse.papyrus.customization.properties.generation.generators.IGenerator;
import org.eclipse.papyrus.customization.properties.generation.generators.ProfileGenerator;
import org.eclipse.papyrus.customization.properties.generation.layout.StandardLayoutGenerator;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.views.properties.contexts.DataContextRoot;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.environment.CompositeWidgetType;
import org.eclipse.papyrus.views.properties.environment.Environment;
import org.eclipse.papyrus.views.properties.environment.LayoutType;
import org.eclipse.papyrus.views.properties.environment.PropertyEditorType;
import org.eclipse.papyrus.views.properties.environment.Type;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.ui.CompositeWidget;
import org.eclipse.papyrus.views.properties.ui.Layout;
import org.eclipse.papyrus.views.properties.ui.PropertyEditor;
import org.eclipse.papyrus.views.properties.ui.UiFactory;
import org.eclipse.papyrus.views.properties.ui.ValueAttribute;
import org.eclipse.papyrus.views.properties.util.PropertiesUtil;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileWithDatatypes
extends StandardLayoutGenerator {
    protected IGenerator generator;

    @Override
    protected void sortEditors(List<PropertyEditor> editors) {
        for (PropertyEditor editor : editors) {
            TypeCategory category = new TypeCategory(editor.getProperty());
            this.getByCategory(category).add(editor);
            if (editor.getWidgetType() == null) {
                Activator.log.warn(String.format("Editor for property %s doesn't have a WidgetType", editor.getProperty().getName()));
                continue;
            }
            this.namespaces.add(editor.getWidgetType().getNamespace());
        }
    }

    @Override
    protected CompositeWidget layoutCategorizedEditors(StandardLayoutGenerator.Category category, List<PropertyEditor> editors) {
        if (((TypeCategory)category).isDatatype) {
            CompositeWidgetType compositeType = ConfigurationManager.getInstance().getDefaultCompositeType();
            CompositeWidget container = UiFactory.eINSTANCE.createCompositeWidget();
            container.setWidgetType(compositeType);
            Layout layout = this.createLayout(category.getNumColumns());
            container.setLayout(layout);
            for (PropertyEditor editor : editors) {
                CompositeWidget group = this.createDataTypeGroup(editor.getProperty());
                PropertyEditor viewEditor = UiFactory.eINSTANCE.createPropertyEditor();
                viewEditor.setWidgetType(this.getViewEditor());
                viewEditor.setProperty(editor.getProperty());
                ValueAttribute view = UiFactory.eINSTANCE.createValueAttribute();
                view.setName("view");
                view.setValue(this.getViewName(editor.getProperty()));
                viewEditor.getAttributes().add((Object)view);
                group.getWidgets().add((Object)viewEditor);
                container.getWidgets().add((Object)group);
            }
            return container;
        }
        return super.layoutCategorizedEditors(category, editors);
    }

    protected String getViewName(org.eclipse.papyrus.views.properties.contexts.Property property) {
        Package nearestPackage;
        if (!(this.generator instanceof ProfileGenerator)) {
            return "";
        }
        Property attribute = ((ProfileGenerator)this.generator).getAttribute(property);
        Package rootPackage = nearestPackage = attribute.getType().getNearestPackage();
        while (rootPackage.getNestingPackage() != null) {
            rootPackage = rootPackage.getNestingPackage();
        }
        return String.valueOf(rootPackage.getName()) + ":Single " + attribute.getType().getName();
    }

    protected Context findContext(org.eclipse.papyrus.views.properties.contexts.Property property) {
        DataContextElement element = property.getContextElement();
        if (element instanceof DataContextRoot) {
            return (Context)element.eContainer();
        }
        return this.findContext(element);
    }

    protected Context findContext(DataContextElement element) {
        DataContextPackage dataContextPackage = element.getPackage();
        if (dataContextPackage instanceof DataContextRoot) {
            return (Context)dataContextPackage.eContainer();
        }
        return this.findContext((DataContextElement)dataContextPackage);
    }

    protected String getQualifiedName(View view) {
        return String.valueOf(view.getContext().getName()) + ":" + view.getName();
    }

    protected CompositeWidget createDataTypeGroup(org.eclipse.papyrus.views.properties.contexts.Property property) {
        CompositeWidgetType groupType = this.getGroupComposite();
        CompositeWidget group = UiFactory.eINSTANCE.createCompositeWidget();
        group.setWidgetType(groupType);
        ValueAttribute text = UiFactory.eINSTANCE.createValueAttribute();
        text.setName("text");
        text.setValue(PropertiesUtil.getLabel((org.eclipse.papyrus.views.properties.contexts.Property)property));
        group.getAttributes().add((Object)text);
        Layout layout = this.createLayout(1);
        group.setLayout(layout);
        return group;
    }

    protected Layout createLayout(Integer columns) {
        LayoutType propertiesLayoutType = ConfigurationManager.getInstance().getDefaultLayoutType();
        Layout layout = UiFactory.eINSTANCE.createLayout();
        ValueAttribute numColumns = UiFactory.eINSTANCE.createValueAttribute();
        numColumns.setName("numColumns");
        numColumns.setValue(columns.toString());
        layout.getAttributes().add((Object)numColumns);
        layout.setLayoutType(propertiesLayoutType);
        return layout;
    }

    protected CompositeWidgetType getGroupComposite() {
        for (Environment environment : ConfigurationManager.getInstance().getPropertiesRoot().getEnvironments()) {
            for (CompositeWidgetType widgetType : environment.getCompositeWidgetTypes()) {
                if (widgetType.getNamespace() != null || !widgetType.getWidgetClass().equals("Group")) continue;
                return widgetType;
            }
        }
        Activator.log.warn("Cannot find the Group composite type");
        return ConfigurationManager.getInstance().getDefaultCompositeType();
    }

    protected PropertyEditorType getViewEditor() {
        for (Environment environment : ConfigurationManager.getInstance().getPropertiesRoot().getEnvironments()) {
            for (PropertyEditorType widgetType : environment.getPropertyEditorTypes()) {
                if (widgetType.getNamespace() == null || !"ppe".equals(widgetType.getNamespace().getName()) || !widgetType.getWidgetClass().equals("ViewEditor")) continue;
                return widgetType;
            }
        }
        Activator.log.warn("Cannot find the Group composite type");
        return ConfigurationManager.getInstance().getDefaultEditorType(Type.STRING, false);
    }

    @Override
    public void setGenerator(IGenerator generator) {
        this.generator = generator;
    }

    @Override
    public String getName() {
        return "UML Profile with DataTypes";
    }

    protected class TypeCategory
    extends StandardLayoutGenerator.Category {
        protected boolean isDatatype;

        public TypeCategory(org.eclipse.papyrus.views.properties.contexts.Property property) {
            super(ProfileWithDatatypes.this, property);
            Property attribute = this.resolveProperty(property);
            if (attribute != null) {
                this.isDatatype = attribute.getType().eClass() == UMLPackage.eINSTANCE.getDataType();
            }
        }

        protected Property resolveProperty(org.eclipse.papyrus.views.properties.contexts.Property property) {
            if (ProfileWithDatatypes.this.generator instanceof ProfileGenerator) {
                ProfileGenerator profileGenerator = (ProfileGenerator)ProfileWithDatatypes.this.generator;
                return profileGenerator.getAttribute(property);
            }
            return null;
        }

        public Integer getNumColumns() {
            if (this.isDatatype) {
                return 1;
            }
            return super.getNumColumns();
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.isDatatype ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (!(obj instanceof TypeCategory)) {
                return false;
            }
            TypeCategory other = (TypeCategory)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.isDatatype == other.isDatatype;
        }

        public Integer getTypeIndex() {
            if (this.isDatatype) {
                return orderedTypes.length + 1;
            }
            return super.getTypeIndex();
        }

        private ProfileWithDatatypes getOuterType() {
            return ProfileWithDatatypes.this;
        }
    }
}

