/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.views.properties.contexts.DataContextElement;
import org.eclipse.papyrus.views.properties.contexts.DataContextPackage;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.ui.internal.misc.StringMatcher;

public class ViewFilter
extends ViewerFilter {
    private StringMatcher matcher;

    public void setPattern(String pattern) {
        this.matcher = new StringMatcher("*" + pattern + "*", true, false);
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        EObject eObject;
        if (this.matcher == null) {
            return true;
        }
        if (element instanceof IAdaptable && (eObject = (EObject)((IAdaptable)element).getAdapter(EObject.class)) != null) {
            if (eObject instanceof View) {
                String viewName = ((View)eObject).getName();
                if (viewName == null) {
                    return true;
                }
                return this.matcher.match(viewName);
            }
            if (eObject instanceof DataContextPackage) {
                return this.select((DataContextPackage)eObject);
            }
            if (eObject instanceof DataContextElement) {
                return this.select((DataContextElement)eObject);
            }
        }
        return true;
    }

    private boolean select(DataContextPackage dataContextPackage) {
        if (dataContextPackage.getName() == null) {
            return true;
        }
        if (this.matcher.match(dataContextPackage.getName())) {
            return true;
        }
        for (DataContextElement subElement : dataContextPackage.getElements()) {
            if (subElement instanceof DataContextPackage && this.select((DataContextPackage)subElement)) {
                return true;
            }
            if (!this.select(subElement)) continue;
            return true;
        }
        return false;
    }

    private boolean select(DataContextElement dataContextElement) {
        if (dataContextElement.getName() == null) {
            return true;
        }
        if (this.matcher.match(dataContextElement.getName())) {
            return true;
        }
        DataContextPackage dataContextPackage = dataContextElement.getPackage();
        while (dataContextPackage != null) {
            if (this.matcher.match(dataContextPackage.getName())) {
                return true;
            }
            dataContextPackage = dataContextPackage.getPackage();
        }
        return false;
    }
}

