/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.editor.actions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.StaticSelectionCommandAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.customization.properties.editor.actions.CompoundCommandActionDelegate;
import org.eclipse.papyrus.customization.properties.editor.actions.CreateResourceCommand;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.ContextsFactory;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;
import org.eclipse.papyrus.views.properties.runtime.ConfigurationManager;
import org.eclipse.papyrus.views.properties.ui.CompositeWidget;
import org.eclipse.papyrus.views.properties.ui.Layout;
import org.eclipse.papyrus.views.properties.ui.UiFactory;
import org.eclipse.papyrus.views.properties.ui.ValueAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateSectionAction
extends StaticSelectionCommandAction {
    private IStructuredSelection selection;
    private String sectionName;
    private String sectionFile;

    public CreateSectionAction(ISelection selection, String sectionName, String sectionFile) {
        this.sectionName = sectionName;
        this.sectionFile = sectionFile;
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
            this.configureAction(selection);
        }
    }

    protected Command createActionCommand(EditingDomain editingDomain, Collection<?> collection) {
        Context context;
        Object selectedElement = this.selection.getFirstElement();
        View view = null;
        if (selectedElement instanceof View) {
            view = (View)selectedElement;
        }
        if (view == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Tab tab = null;
        for (Section section : view.getSections()) {
            if (section.getTab() == null) continue;
            tab = section.getTab();
            break;
        }
        if (tab == null && (context = (Context)view.eContainer()).getTabs().size() > 0) {
            tab = (EObject)context.getTabs().get(0);
        }
        if (tab == null) {
            return UnexecutableCommand.INSTANCE;
        }
        Section newSection = ContextsFactory.eINSTANCE.createSection();
        newSection.setName(this.getSectionName());
        CompositeWidget newWidget = this.createWidget();
        CommandParameter tabParameter = new CommandParameter((Object)tab, (Object)tab.eClass().getEStructuralFeature("sections"), (Object)newSection);
        Command createInTab = CreateChildCommand.create((EditingDomain)editingDomain, (Object)tab, (Object)tabParameter, collection);
        Command addInView = AddCommand.create((EditingDomain)editingDomain, (Object)view, (Object)view.eClass().getEStructuralFeature("sections"), (Object)newSection);
        Command createWidgetResource = this.getCreateResourceCommand(newWidget, newSection, view.eResource());
        Command setWidget = this.getSetWidgetCommand(newWidget, newSection);
        CompoundCommandActionDelegate createActionCommand = new CompoundCommandActionDelegate();
        createActionCommand.append(createInTab);
        createActionCommand.append(addInView);
        createActionCommand.append(createWidgetResource);
        createActionCommand.append(setWidget);
        return createActionCommand;
    }

    private CompositeWidget createWidget() {
        CompositeWidget newWidget = UiFactory.eINSTANCE.createCompositeWidget();
        for (Map.Entry<String, String> entry : this.getNamespaces().entrySet()) {
            ValueAttribute attribute = UiFactory.eINSTANCE.createValueAttribute();
            attribute.setName(entry.getKey());
            attribute.setValue(entry.getValue());
            newWidget.getAttributes().add((Object)attribute);
        }
        newWidget.setWidgetType(ConfigurationManager.getInstance().getDefaultCompositeType());
        Layout layout = UiFactory.eINSTANCE.createLayout();
        layout.setLayoutType(ConfigurationManager.getInstance().getDefaultLayoutType());
        newWidget.setLayout(layout);
        return newWidget;
    }

    private Map<String, String> getNamespaces() {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("xmlns", "http://www.eclipse.org/xwt/presentation");
        namespaces.put("xmlns:x", "http://www.eclipse.org/xwt");
        namespaces.put("xmlns:ppe", "clr-namespace:org.eclipse.papyrus.views.properties.widgets");
        namespaces.put("xmlns:ppel", "clr-namespace:org.eclipse.papyrus.views.properties.widgets.layout");
        return namespaces;
    }

    private Command getCreateResourceCommand(CompositeWidget newWidget, Section section, Resource baseResource) {
        if (section.getSectionFile() == null || section.getSectionFile().equals("")) {
            section.setSectionFile(this.getSectionFile());
        }
        URI widgetURI = URI.createURI((String)section.getSectionFile());
        widgetURI = widgetURI.resolve(baseResource.getURI());
        CreateResourceCommand createWidget = new CreateResourceCommand((EObject)newWidget, widgetURI, baseResource.getResourceSet());
        return createWidget;
    }

    private Command getSetWidgetCommand(CompositeWidget newWidget, Section section) {
        if (section.getWidget() == null) {
            return SetCommand.create((EditingDomain)this.editingDomain, (Object)section, (Object)section.eClass().getEStructuralFeature("widget"), (Object)newWidget);
        }
        return UnexecutableCommand.INSTANCE;
    }

    private String getSectionFile() {
        return this.sectionFile;
    }

    private String getSectionName() {
        return this.sectionName;
    }
}

