/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.properties.providers;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.customization.properties.providers.AbstractContextualContentProvider;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.DisplayUnit;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.papyrus.views.properties.contexts.Section;
import org.eclipse.papyrus.views.properties.contexts.Tab;
import org.eclipse.papyrus.views.properties.contexts.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintDescriptorContentProvider
extends AbstractContextualContentProvider {
    private EClass type;

    public ConstraintDescriptorContentProvider(EObject source, EClass type) {
        super(source);
        this.type = type;
    }

    public Object[] getElements() {
        LinkedList<ConstraintDescriptor> result = new LinkedList<ConstraintDescriptor>();
        for (Context context : this.contexts) {
            for (View view : context.getViews()) {
                result.addAll(this.getFilteredConstraintsFromDisplayUnit((DisplayUnit)view));
            }
            for (Tab tab : context.getTabs()) {
                for (Section section : tab.getSections()) {
                    result.addAll(this.getFilteredConstraintsFromDisplayUnit((DisplayUnit)section));
                }
            }
        }
        return result.toArray();
    }

    private List<ConstraintDescriptor> getFilteredConstraintsFromDisplayUnit(DisplayUnit unit) {
        LinkedList<ConstraintDescriptor> result = new LinkedList<ConstraintDescriptor>();
        for (ConstraintDescriptor constraint : unit.getConstraints()) {
            if (!this.type.isInstance((Object)constraint)) continue;
            result.add(constraint);
        }
        return result;
    }

    public Object[] getElements(Object inputElement) {
        return this.getElements();
    }
}

